/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.insight;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.StyleContext;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.htmlpopup.ContentProvider;
import oracle.ide.ceditor.htmlpopup.HtmlPopup;
import oracle.ide.ceditor.htmlpopup.HtmlPopupView;
import oracle.ide.ceditor.htmlpopup.PopupEventListener;
import oracle.ide.ceditor.htmlpopup.StaticContentProvider;
import oracle.ide.ceditor.insight.InsightBundle;
import oracle.ide.ceditor.insight.ListDataItem;
import oracle.ide.config.Preferences;
import oracle.javatools.editor.ActionPreInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.ui.ColorUtils2;

public abstract class BasicInsight
extends AbstractInsight {
    protected HtmlPopupView _htmlPopupView;
    protected Listeners _listeners = new Listeners();
    protected JToggleButton docButton;
    private JLabel statusLabel;
    private static final Color STATUS_DIVIDER_COLOR = new Color(125, 125, 125, 125);
    protected String visibilityPrefKey = String.format("%s.Visibility", ((Object)((Object)this)).getClass().getName());
    protected static final String COMPLETION_INSTANCE = "java-completion";
    protected static final String PARAMETER_INSTANCE = "java-parameter";

    protected abstract ListInsightView getListInsightView();

    protected boolean isDocInitiallyVisible() {
        Preferences preferences = Preferences.getPreferences();
        return preferences.getProperties().getBoolean(this.visibilityPrefKey, true);
    }

    protected void setDocVisibility(boolean visible) {
        Preferences preferences = Preferences.getPreferences();
        preferences.getProperties().putBoolean(this.visibilityPrefKey, visible);
    }

    public Context getContext() {
        Context context = CodeEditor.getContext(this.getEditorPane());
        return context;
    }

    public AbstractInsight getInsight(int type) {
        String typeString = this.getTypeString(type);
        BasicEditorPane editor = this.getEditorPane();
        return (AbstractInsight)editor.getProperty(typeString);
    }

    protected String getTypeString(int type) {
        switch (type) {
            case 1: {
                return COMPLETION_INSTANCE;
            }
            case 2: {
                return PARAMETER_INSTANCE;
            }
        }
        throw new IllegalStateException("unknown type: " + type);
    }

    public void showInsight(boolean wasAutoInvoked) {
        boolean wasActive = this.isActive();
        super.showInsight(wasAutoInvoked);
        if (!wasActive && this.isActive()) {
            BasicEditorPane editorPane1 = this.getEditorPane();
            editorPane1.addPreActionInvoker((ActionPreInvoker)this._listeners, 2.0);
            if (this.isDocInitiallyVisible()) {
                this.showQuickDoc();
            }
        }
    }

    public void hideInsight() {
        this._listeners._timer.stop();
        if (this.isActive()) {
            BasicEditorPane editorPane = this.getEditorPane();
            editorPane.removePreActionInvoker((ActionPreInvoker)this._listeners, 2.0);
            if (this._htmlPopupView != null) {
                this.hideQuickDoc();
            }
        }
        super.hideInsight();
    }

    protected void toggleHtmlDoc() {
        if (this._htmlPopupView == null) {
            this.showQuickDoc();
        } else {
            this.hideQuickDoc();
        }
    }

    protected ContentProvider getSelectedContentProvider() {
        ContentProvider ret = null;
        Object selectedValue = this.getListInsightView().getSelectedValue();
        if (selectedValue instanceof ListDataItem) {
            ListDataItem listDataItem = (ListDataItem)((Object)selectedValue);
            Context context = this.getContext();
            ret = listDataItem.getContentProvider(context);
        }
        return ret;
    }

    public void hideQuickDoc() {
        BasicEditorPane editorPane = this.getEditorPane();
        HtmlPopup.cancelPopup(editorPane);
        if (this._htmlPopupView != null) {
            this._htmlPopupView.removePopupEventListener(this._listeners);
            this.getListInsightView().removeListSelectionListener((ListSelectionListener)this._listeners);
        }
    }

    public void showQuickDoc() {
        ContentProvider contentProvider = this.getSelectedContentProvider();
        if (contentProvider != null) {
            BasicEditorPane editorPane = this.getEditorPane();
            EnumSet<HtmlPopup.Options> options = EnumSet.noneOf(HtmlPopup.Options.class);
            this._htmlPopupView = HtmlPopup.invokePopup(editorPane, contentProvider, options);
            if (this._htmlPopupView != null) {
                this._htmlPopupView.setToolbarVisible(false);
                this._htmlPopupView.addPopupEventListener(this._listeners);
                this.getListInsightView().addListSelectionListener((ListSelectionListener)this._listeners);
            }
        }
    }

    protected JComponent createStatusComponent() {
        JPanel p = null;
        if (this.getListInsightView() != null) {
            this.statusLabel = new JLabel("");
            this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(9.0f));
            this.statusLabel.setHorizontalAlignment(10);
            this.statusLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, STATUS_DIVIDER_COLOR), BorderFactory.createEmptyBorder(1, 1, 1, 6)));
            this.docButton = new JToggleButton(InsightBundle.get("INSIGHT_DOC_POPUP_BUTTON"), UIManager.getIcon("Tree.collapsedIcon"));
            this.docButton.setFont(this.docButton.getFont().deriveFont(9.0f));
            this.docButton.setMargin(new Insets(0, 0, 0, 0));
            this.docButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.docButton.setContentAreaFilled(false);
            this.docButton.setSelectedIcon(UIManager.getIcon("Tree.expandedIcon"));
            this.docButton.setHorizontalTextPosition(10);
            this.docButton.setSelected(this.isDocInitiallyVisible());
            this.docButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicInsight.this.setDocVisibility(BasicInsight.this.docButton.isSelected());
                    if (BasicInsight.this.docButton.isSelected()) {
                        BasicInsight.this.showQuickDoc();
                    } else {
                        BasicInsight.this.hideQuickDoc();
                    }
                }
            });
            p = new JPanel(new BorderLayout(4, 0));
            p.add((Component)this.statusLabel, "Center");
            p.add((Component)this.docButton, "After");
            p.setOpaque(true);
            Color c = ColorUtils2.shadeColorPercent((Color)this.getListInsightView().getBackground(), (double)12.0);
            p.setBackground(c);
        }
        return p;
    }

    protected JLabel getStatusLabel() {
        return this.statusLabel;
    }

    static {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                StyleContext.getDefaultStyleContext().getFont("Courier", 0, 11);
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    private class Listeners
    implements ActionPreInvoker,
    PopupEventListener,
    ListSelectionListener,
    ActionListener {
        private Timer _timer = new Timer(200, this);

        private Listeners() {
            this._timer.setRepeats(false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean invokeAction(String actionKey) {
            if (actionKey.equals("show-doc-popup")) {
                BasicInsight.this.toggleHtmlDoc();
                return true;
            } else {
                if (BasicInsight.this._htmlPopupView == null) return false;
                if (actionKey.equals("scroll-line-up")) {
                    BasicInsight.this._htmlPopupView.up();
                    return true;
                } else if (actionKey.equals("scroll-line-down")) {
                    BasicInsight.this._htmlPopupView.down();
                    return true;
                } else {
                    if (!actionKey.equals("cancel")) return false;
                    BasicInsight.this.hideQuickDoc();
                }
            }
            return true;
        }

        @Override
        public void popupCanceled() {
        }

        @Override
        public void popupClosed() {
            this._timer.stop();
            BasicInsight.this.getListInsightView().removeListSelectionListener((ListSelectionListener)this);
            BasicInsight.this.hideQuickDoc();
            BasicInsight.this._htmlPopupView.removePopupEventListener(this);
            BasicInsight.this._htmlPopupView = null;
        }

        @Override
        public void contentsChanged() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this._timer.restart();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicInsight.this.getEditorPane() == null) {
                return;
            }
            ContentProvider contentProvider = BasicInsight.this.getSelectedContentProvider();
            if (contentProvider == null) {
                contentProvider = new StaticContentProvider(InsightBundle.get("INSIGHT_DOC_NO_INFORMATION_AVAILABLE"), true);
            }
            if (BasicInsight.this._htmlPopupView != null) {
                BasicInsight.this._htmlPopupView.push(contentProvider);
            }
        }
    }
}

