/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindDialog;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.IncrementalOptionPanel;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.internal.Exceptions;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class IncrementalSearch
implements EditorPlugin {
    private static final String INCREMENTAL_SEARCH_PROPERTY = "incremental_search_property";
    private Listeners _listeners = new Listeners();
    private ArrayList<StackEntry> _stack = new ArrayList();
    private BasicEditorPane _editorPane;
    private SearchField _searchField;
    private Popup _notFoundPopup;
    private IncrementalOptionPanel _optionPanel;
    private Action _showOptionsAction;

    public static boolean activateSearch(BasicEditorPane editorPane) {
        JTextField textField;
        boolean ret = false;
        IncrementalSearch incrementalSearch = IncrementalSearch.getIncrementalSearch(editorPane);
        if (incrementalSearch != null && (textField = IncrementalSearch.getTextField((Container)incrementalSearch._searchField)).isShowing()) {
            if (editorPane.hasFocus()) {
                String text = FindDialog.getInitialText(editorPane);
                FindController.getInstance().updateSearchText(text);
                incrementalSearch._searchField.setText(text, true);
                textField.requestFocus();
            } else {
                incrementalSearch.whenInvokeFindDialog(editorPane);
            }
            ret = true;
        }
        return ret;
    }

    private static IncrementalSearch getIncrementalSearch(BasicEditorPane editorPane) {
        return (IncrementalSearch)editorPane.getProperty(INCREMENTAL_SEARCH_PROPERTY);
    }

    static String getIncrementalSearchString(BasicEditorPane editorPane) {
        IncrementalSearch incrementalSearch = IncrementalSearch.getIncrementalSearch(editorPane);
        if (incrementalSearch != null && incrementalSearch._searchField.isShowing() && incrementalSearch._searchField.getText().length() > 0) {
            return incrementalSearch._searchField.getText();
        }
        return "";
    }

    private void whenInvokeFindDialog(BasicEditorPane editorPane) {
        FindController findController = FindController.getInstance();
        CodeEditor codeEditor = CodeEditor.getCodeEditor(editorPane);
        if (codeEditor != null) {
            Context context = codeEditor.getContext();
            FindOptions findOptions = FindController.getFindOptions();
            findController.invokeFindDialog(context, findOptions);
            String searchText = findController.getSearchText();
            this._searchField.setText(searchText, true);
            this._editorPane.requestFocus();
        }
    }

    private static JTextField getTextField(Container parent) {
        if (parent instanceof JTextField) {
            JTextField jTextField = (JTextField)parent;
            return jTextField;
        }
        Component[] children = parent.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Container container;
            JTextField textField;
            Component child = children[i];
            if (!(child instanceof Container) || (textField = IncrementalSearch.getTextField(container = (Container)child)) == null) continue;
            return textField;
        }
        return null;
    }

    private void clearStack() {
        this._stack.clear();
    }

    private void navigate(String searchText) {
        int searchStart;
        StackEntry entry;
        char stackChar;
        char typedChar;
        int commonChars;
        int minLen = Math.min(searchText.length(), this._stack.size());
        for (commonChars = 0; commonChars < minLen && (typedChar = searchText.charAt(commonChars)) == (stackChar = (entry = this._stack.get(commonChars))._c); ++commonChars) {
        }
        boolean isShorter = false;
        for (int i = this._stack.size() - 1; i >= commonChars; --i) {
            this._stack.remove(i);
            isShorter = true;
        }
        FindOptions findOptions = FindController.getFindOptions();
        FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(this._editorPane);
        int searchPosition = searchStart = this._editorPane.getSelectionStart();
        int searchLength = searchText.length();
        boolean highlightOccurrences = false;
        for (int pos = commonChars; pos < searchLength; ++pos) {
            char c = searchText.charAt(pos);
            String searchedText = searchText.substring(0, pos + 1);
            if (pos > 0 && pos + 1 == searchLength) {
                highlightOccurrences = findOptions.getHighlightOccurrences();
            }
            int textPos = findHighlightPlugin.findText(searchedText, searchPosition, true, findOptions.getMatchCase(), false, findOptions.getWholeWordOnly(), highlightOccurrences);
            StackEntry entry2 = new StackEntry(c, textPos, searchedText.length());
            this._stack.add(entry2);
            if (textPos < 0) continue;
            searchPosition = textPos;
        }
        this.hideNotFoundTip();
        StackEntry lastEntry = this.getLastEntry();
        if (lastEntry != null) {
            if (lastEntry._position >= 0) {
                this.navigateTo(lastEntry._position, searchText.length());
            } else {
                int textPos;
                StackEntry lastValidEntry;
                if (searchPosition != searchStart && (lastValidEntry = this.getLastValidEntry()) != null) {
                    this.navigateTo(lastValidEntry._position, lastValidEntry._matchLength);
                }
                if ((textPos = findHighlightPlugin.findText(searchText, searchPosition, true, findOptions.getMatchCase(), true, findOptions.getWholeWordOnly(), highlightOccurrences)) >= 0 && textPos != searchPosition) {
                    this.showNotFoundTip(true, true);
                } else {
                    this.showNotFoundTip(false, true);
                    if (!isShorter) {
                        this._editorPane.getToolkit().beep();
                    }
                }
            }
        } else {
            this.navigateTo(searchPosition, 0);
        }
        FindController findController = FindController.getInstance();
        findController.updateSearchText(searchText);
        this.updateSearchActions();
    }

    private void updateSearchActions() {
        CodeEditor codeEditor = CodeEditor.getCodeEditor(this._editorPane);
        codeEditor.updateVisibleActions();
    }

    private void findNext(boolean forward) {
        String searchedText = this._searchField.getText();
        if (searchedText.length() > 0) {
            int searchStart = this._editorPane.getSelectionStart();
            int searchFrom = forward ? searchStart + searchedText.length() : searchStart;
            boolean wrapAround = this._notFoundPopup != null;
            this.hideNotFoundTip();
            FindOptions findOptions = FindController.getFindOptions();
            FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(this._editorPane);
            boolean highlightOccurrences = searchedText.length() > 1 && findOptions.getHighlightOccurrences();
            int textPos = findHighlightPlugin.findText(searchedText, searchFrom, forward, findOptions.getMatchCase(), wrapAround, findOptions.getWholeWordOnly(), highlightOccurrences);
            if (textPos >= 0) {
                this.navigateTo(textPos, searchedText.length());
            } else {
                int wrapPos = findHighlightPlugin.findText(searchedText, searchFrom, forward, findOptions.getMatchCase(), true, findOptions.getWholeWordOnly(), highlightOccurrences);
                boolean canWrap = wrapPos >= 0 && wrapPos != searchStart;
                this.showNotFoundTip(canWrap, forward);
            }
        }
    }

    private void navigateTo(int position, int matchLength) {
        this._editorPane.setCaretPositionCenter(position);
        this._editorPane.setSelectionEnd(position + matchLength);
    }

    private StackEntry getLastValidEntry() {
        for (int i = this._stack.size() - 1; i >= 0; --i) {
            StackEntry entry = this._stack.get(i);
            if (entry._position < 0) continue;
            return entry;
        }
        return null;
    }

    private StackEntry getLastEntry() {
        int stackSize = this._stack.size();
        StackEntry lastEntry = stackSize > 0 ? this._stack.get(stackSize - 1) : null;
        return lastEntry;
    }

    private void showNotFoundTip(boolean canWrap, boolean forward) {
        this.hideNotFoundTip();
        if (this._notFoundPopup == null) {
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            Point location = new Point(0, this._searchField.getHeight());
            SwingUtilities.convertPointToScreen(location, (Component)this._searchField);
            String text = canWrap ? (forward ? FindArb.getString(52) : FindArb.getString(53)) : FindArb.getString(54);
            JLabel contents = new JLabel(text);
            contents.setOpaque(true);
            contents.setBackground(UIManager.getColor("ToolTip.background"));
            contents.setForeground(UIManager.getColor("ToolTip.foreground"));
            Border tooltipBorder = UIManager.getBorder("ToolTip.border");
            contents.setBorder(BorderFactory.createCompoundBorder(tooltipBorder, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this._notFoundPopup = popupFactory.getPopup((Component)this._searchField, contents, location.x, location.y);
            this._notFoundPopup.show();
        }
    }

    private void hideNotFoundTip() {
        if (this._notFoundPopup != null) {
            this._notFoundPopup.hide();
            this._notFoundPopup = null;
            this._editorPane.repaint();
        }
    }

    private void showOptionPanel() {
        this.hideNotFoundTip();
        if (this._optionPanel == null) {
            this._optionPanel = IncrementalOptionPanel.getIncrementalOptionPanel();
            InputMap inputMap = this._optionPanel.getInputMap(1);
            ActionMap actionMap = this._optionPanel.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(40, 8), "showOptions");
            inputMap.put(KeyStroke.getKeyStroke(38, 8), "showOptions");
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "showOptions");
            actionMap.put("showOptions", this._showOptionsAction);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelOptions");
            actionMap.put("cancelOptions", new MyAction('o'));
        }
        if (this._optionPanel.isShowing()) {
            this._optionPanel.dismiss();
            this._optionPanel.saveOptions();
            this._searchField.requestFocus();
            String searchText = this._searchField.getText();
            if (searchText.length() > 0) {
                this.navigate(searchText);
            }
            return;
        }
        this._optionPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                IncrementalSearch.this._optionPanel.removeAncestorListener(this);
                IncrementalSearch.this._optionPanel.saveOptions();
                String searchText = IncrementalSearch.this._searchField.getText();
                if (searchText.length() > 0) {
                    try {
                        IncrementalSearch.this.navigate(searchText);
                    }
                    catch (ExpiredTextBufferException expiredTextBufferException) {
                        // empty catch block
                    }
                }
            }
        });
        this._optionPanel.show((Component)this._searchField, 3, this._searchField.getHeight() + 3);
    }

    private void hideOptionPanel() {
        JTextField textField = IncrementalSearch.getTextField((Container)this._searchField);
        textField.requestFocus();
    }

    private void whenAccept() {
        FindOptions findOptions = FindController.getFindOptions();
        String searchedText = this._searchField.getText();
        if (searchedText.length() > 0) {
            findOptions.updateSearchHistory(searchedText);
        }
        this._editorPane.requestFocus();
        this.updateSearchActions();
    }

    private void whenCancel() {
        if (this._notFoundPopup == null) {
            FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(this._editorPane);
            findHighlightPlugin.clearFindHighlighting();
            this._editorPane.requestFocus();
            this.updateSearchActions();
        } else {
            this.hideNotFoundTip();
        }
    }

    private void whenSearchEnds() {
        this.hideNotFoundTip();
        if (this._optionPanel != null) {
            this._optionPanel.dismiss();
        }
    }

    public void install(BasicEditorPane editor) {
        Toolbar toolbar;
        CodeEditor codeEditor = CodeEditor.getCodeEditor(editor);
        if (codeEditor != null && (toolbar = codeEditor.getToolbar()) != null) {
            this._showOptionsAction = new MyAction('O');
            this._showOptionsAction.putValue("SmallIcon", OracleIcons.getIcon((String)"find.png"));
            KeyStroke keyStroke = KeyStroke.getKeyStroke("alt DOWN");
            this._showOptionsAction.putValue("AcceleratorKey", keyStroke);
            String tooltip = MessageFormat.format(FindArb.getString(58), KeyUtil.toString((KeyStroke)keyStroke));
            this._showOptionsAction.putValue("ShortDescription", tooltip);
            this._searchField = new SearchField();
            this._searchField.setStyle(SearchField.Style.FIND);
            this._searchField.setAutoFind(true);
            Listeners listeners = this._listeners;
            this._searchField.addSearchListener((SearchListener)listeners);
            this._searchField.setPopDownAction(this._showOptionsAction);
            this._searchField.setPrompt(FindArb.getString(57));
            JTextField textField = IncrementalSearch.getTextField((Container)this._searchField);
            InputMap inputMap = textField.getInputMap(0);
            ActionMap actionMap = textField.getActionMap();
            MyAction cancelAction = new MyAction('C');
            MyAction acceptAction = new MyAction('A');
            inputMap.put(KeyStroke.getKeyStroke(10, 0), acceptAction);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
            actionMap.put(acceptAction, acceptAction);
            actionMap.put(cancelAction, cancelAction);
            actionMap.put(this._showOptionsAction, this._showOptionsAction);
            textField.addFocusListener(listeners);
            Dimension preferredSize = this._searchField.getPreferredSize();
            this._searchField.setMaximumSize(new Dimension(250, preferredSize.height));
            toolbar.add((Component)this._searchField);
            toolbar.addComponentListener((ComponentListener)this._listeners);
            codeEditor.addViewListener(this._listeners);
            this._editorPane = editor;
            editor.putProperty(INCREMENTAL_SEARCH_PROPERTY, (Object)this);
        }
    }

    public void deinstall(BasicEditorPane editor) {
        this.hideNotFoundTip();
        this.hideOptionPanel();
        CodeEditor codeEditor = CodeEditor.getCodeEditor(editor);
        if (codeEditor != null) {
            Toolbar toolbar = codeEditor.getToolbar();
            if (toolbar != null) {
                toolbar.remove((Component)this._searchField);
                toolbar.removeComponentListener((ComponentListener)this._listeners);
            }
            codeEditor.removeViewListener(this._listeners);
        }
        editor.putProperty(INCREMENTAL_SEARCH_PROPERTY, null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private static class StackEntry {
        private char _c;
        private int _position;
        private int _matchLength;

        public StackEntry(char c, int position, int matchLength) {
            this._c = c;
            this._position = position;
            this._matchLength = matchLength;
        }
    }

    private class MyAction
    extends AbstractAction {
        private char _type;

        public MyAction(char type) {
            this._type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this._type) {
                case 'A': {
                    IncrementalSearch.this.whenAccept();
                    break;
                }
                case 'C': {
                    IncrementalSearch.this.whenCancel();
                    break;
                }
                case 'O': {
                    IncrementalSearch.this.showOptionPanel();
                    break;
                }
                case 'o': {
                    IncrementalSearch.this.showOptionPanel();
                }
            }
        }
    }

    private class Listeners
    implements SearchListener,
    FocusListener,
    PropertyChangeListener,
    ViewListener,
    ComponentListener {
        private int _hasGlobalFocusListener;

        private Listeners() {
        }

        private void installFocusListener() {
            ++this._hasGlobalFocusListener;
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            currentKeyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        private void deinstallFocusListener() {
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            currentKeyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", this);
            --this._hasGlobalFocusListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component focusedComponent;
            String propertyName = evt.getPropertyName();
            if ("permanentFocusOwner".equals(propertyName) && (focusedComponent = (Component)evt.getNewValue()) != null) {
                boolean isInSearchFields = false;
                if (SwingUtilities.isDescendingFrom(focusedComponent, (Component)IncrementalSearch.this._searchField)) {
                    isInSearchFields = true;
                } else if (IncrementalSearch.this._optionPanel != null && SwingUtilities.isDescendingFrom(focusedComponent, IncrementalSearch.this._optionPanel)) {
                    isInSearchFields = true;
                }
                if (!isInSearchFields) {
                    this.deinstallFocusListener();
                    IncrementalSearch.this.whenSearchEnds();
                }
            }
        }

        public void searchPerformed(SearchEvent se) {
            try {
                if (se.isTriggeredByKeypress()) {
                    String searchText = se.getSearchText();
                    IncrementalSearch.this.navigate(searchText);
                } else {
                    SearchEvent.Direction direction = se.getDirection();
                    IncrementalSearch.this.findNext(direction == SearchEvent.Direction.FORWARD);
                }
            }
            catch (ExpiredTextBufferException e) {
                Exceptions.swallow((Throwable)e);
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            IncrementalSearch.this.clearStack();
            IncrementalSearch.this.hideNotFoundTip();
            JTextField textField = IncrementalSearch.getTextField((Container)IncrementalSearch.this._searchField);
            textField.selectAll();
            CodeEditor.updateToolbarActions((Toolbar)Ide.getToolbar());
            CodeEditor.getCodeEditor(IncrementalSearch.this._editorPane).updateVisibleActions();
            if (this._hasGlobalFocusListener == 0) {
                this.installFocusListener();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getOppositeComponent() == IncrementalSearch.this._editorPane) {
                CodeEditor.updateToolbarActions((Toolbar)Ide.getToolbar());
                CodeEditor.getCodeEditor(IncrementalSearch.this._editorPane).updateVisibleActions();
            }
        }

        public void viewActivated(ViewEvent e) {
        }

        public void viewDeactivated(ViewEvent e) {
            IncrementalSearch.this.hideNotFoundTip();
        }

        public void viewClosed(ViewEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            IncrementalSearch.this.hideNotFoundTip();
        }
    }
}

