/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.util.ArrayList;
import oracle.ide.ceditor.find.NavigableHighlighter;
import oracle.javatools.editor.BasicEditorPane;

public final class FindNavigator {
    private static FindNavigator INSTANCE;
    private ArrayList _navigables = new ArrayList();
    private boolean _isSearchHighlightMode;

    private FindNavigator() {
    }

    static void createFindNavigator() {
        INSTANCE = new FindNavigator();
    }

    public static FindNavigator getFindNavigator() {
        return INSTANCE;
    }

    boolean isSearchHighlightMode() {
        return this._isSearchHighlightMode;
    }

    public void setSearchHighlightMode(boolean searchHighlightMode) {
        this._isSearchHighlightMode = searchHighlightMode;
    }

    public void registerNavigableHighlighter(NavigableHighlighter navigableHighlighter) {
        this._navigables.add(navigableHighlighter);
    }

    public void unregisterNavigableHighlighter(NavigableHighlighter navigableHighlighter) {
        this._navigables.remove(navigableHighlighter);
    }

    public boolean hasHighlights(BasicEditorPane basicEditorPane) {
        for (int i = 0; i < this._navigables.size(); ++i) {
            NavigableHighlighter navigableHighlighter = (NavigableHighlighter)this._navigables.get(i);
            if (!navigableHighlighter.hasHighlights(basicEditorPane)) continue;
            return true;
        }
        return false;
    }

    private boolean getHighlightAfter(BasicEditorPane basicEditorPane, int position, int[] range) {
        int minFrom = Integer.MAX_VALUE;
        int to = Integer.MAX_VALUE;
        for (int i = 0; i < this._navigables.size(); ++i) {
            NavigableHighlighter navigableHighlighter = (NavigableHighlighter)this._navigables.get(i);
            if (!navigableHighlighter.getHighlightAfter(basicEditorPane, position, range) || range[0] >= minFrom) continue;
            minFrom = range[0];
            to = range[1];
        }
        range[1] = to;
        return minFrom != Integer.MAX_VALUE;
    }

    private boolean getHighlightBefore(BasicEditorPane basicEditorPane, int position, int[] range) {
        int maxFrom = Integer.MIN_VALUE;
        int to = Integer.MIN_VALUE;
        for (int i = 0; i < this._navigables.size(); ++i) {
            NavigableHighlighter navigableHighlighter = (NavigableHighlighter)this._navigables.get(i);
            if (!navigableHighlighter.getHighlightBefore(basicEditorPane, position, range) || range[0] <= maxFrom) continue;
            maxFrom = range[0];
            to = range[1];
        }
        range[1] = to;
        return maxFrom != Integer.MIN_VALUE;
    }

    void searchForward(BasicEditorPane basicEditorPane) {
        int[] range;
        int position = basicEditorPane.getSelectionEnd();
        if (this.getHighlightAfter(basicEditorPane, position, range = new int[2])) {
            basicEditorPane.setSelectionStart(range[0]);
            basicEditorPane.setSelectionEnd(range[1]);
        } else if (this.getHighlightAfter(basicEditorPane, 0, range)) {
            basicEditorPane.setSelectionStart(range[0]);
            basicEditorPane.setSelectionEnd(range[1]);
        }
    }

    void searchBackward(BasicEditorPane basicEditorPane) {
        int[] range;
        int position = basicEditorPane.getSelectionStart();
        if (this.getHighlightBefore(basicEditorPane, position, range = new int[2])) {
            basicEditorPane.setSelectionStart(range[0]);
            basicEditorPane.setSelectionEnd(range[1]);
        } else {
            int documentSize = basicEditorPane.getDocument().getLength();
            if (this.getHighlightBefore(basicEditorPane, documentSize, range)) {
                basicEditorPane.setSelectionStart(range[0]);
                basicEditorPane.setSelectionEnd(range[1]);
            }
        }
    }

    public void clearHighlights(BasicEditorPane basicEditorPane) {
        for (int i = 0; i < this._navigables.size(); ++i) {
            NavigableHighlighter navigableHighlighter = (NavigableHighlighter)this._navigables.get(i);
            navigableHighlighter.clearHighlights(basicEditorPane);
        }
    }
}

