/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindNavigator;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.find.NavigableHighlighter;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.ResourceUtils;
import oracle.ide.vcs.VCSManager;
import oracle.ide.view.View;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.plugins.FindHighlightPlugin;

final class FindDialog {
    public static final int FIND = 1;
    public static final int SEARCH_FORWARD = 2;
    public static final int REPLACE = 3;
    public static final int SEARCH_BACKWARD = 4;
    public static final int FIND_NEXT_AT_CURSOR = 5;
    public static final int FIND_PREVIOUS_AT_CURSOR = 6;
    private ReplaceOccurenceDialog replaceDialog = null;
    JComboBox findComboBox;
    private JEWTDialog dialog;
    private String searchText = "";
    private Pattern searchPattern = null;
    private String _replaceText = "";
    private boolean optionSearchForward = true;
    private boolean optionReplace = false;
    private boolean optionSelectedText = false;
    private int hitReplaceCount = 0;
    private int hitSkipCount = 0;
    private static final int YES = 0;
    private static final int NO = 1;
    private static final int CANCEL = 2;
    private static final int GLOBAL = 3;
    private static final EditDescriptor replaceDescriptor;
    private static final EditDescriptor replaceAllDescriptor;
    private static final boolean NO_INITIAL_TEXT;

    FindDialog() {
        FindNavigator.getFindNavigator().registerNavigableHighlighter(new FindHighlightAdaptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFind(int findType, Context context, FindOptions findOptions) {
        int selectEnd;
        if (!this.canPerformFind(findType, findOptions) || context == null || !(context.getView() instanceof FindableEditor)) {
            return;
        }
        this.setOptionReplace(false);
        boolean localSearchFromStart = false;
        View view = context.getView();
        BasicEditorPane editor = ((FindableEditor)view).getFocusedEditorPane();
        boolean checkForSelectedRegion = editor.hasSelection();
        switch (findType) {
            case 1: 
            case 3: {
                if (!this.showDialog(editor, context, FindDialog.getInitialText(editor), findType, findOptions)) {
                    return;
                }
                localSearchFromStart = findOptions.getSearchFromBeginning();
                break;
            }
            case 2: {
                checkForSelectedRegion = false;
                this.setOptionSearchForward(true);
                break;
            }
            case 4: {
                checkForSelectedRegion = false;
                this.setOptionSearchForward(false);
                break;
            }
            case 5: 
            case 6: {
                checkForSelectedRegion = false;
                findOptions.setRegexpSearch(false);
                this.setOptionSearchForward(findType == 5);
                String sWord = FindDialog.getInitialText(editor);
                if (sWord == null) {
                    return;
                }
                this.setSearchText(sWord);
                break;
            }
            default: {
                throw new IllegalStateException("unknown type: " + findType);
            }
        }
        String localSearchText = this.getSearchText();
        if (localSearchText == null || localSearchText.length() == 0) {
            return;
        }
        if (this.isOptionReplace() && !editor.isEditable() && this.isNodeVersioned(context) && !editor.makeEditable()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        BasicDocument document = (BasicDocument)editor.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        boolean doRegexp = findOptions.getRegexpSearch();
        Matcher patternMatcher = null;
        if (doRegexp) {
            int matchFlags = 8;
            if (!findOptions.getMatchCase()) {
                matchFlags |= 0x42;
            }
            if (this.searchPattern.flags() != matchFlags) {
                this.searchPattern = Pattern.compile(this.searchPattern.pattern(), matchFlags);
            }
            BufferCharSequence bufferSequence = new BufferCharSequence((ReadTextBuffer)textBuffer);
            patternMatcher = this.searchPattern.matcher(bufferSequence);
        }
        boolean selectedRegionOnly = checkForSelectedRegion && this.getOptionSelectedText();
        int selectStart = selectedRegionOnly ? editor.getSelectionStart() : -1;
        int n = selectEnd = selectedRegionOnly ? editor.getSelectionEnd() : -1;
        if (this.isOptionReplace() && findType != 2 && findType != 4) {
            this.hitSkipCount = 0;
            this.hitReplaceCount = 0;
            if (doRegexp) {
                this.performCancelHighlighting(editor);
                this._doRegexpReplace(context, patternMatcher, selectStart, selectEnd, localSearchFromStart, findOptions);
            } else {
                this._doReplace(context, localSearchText, selectStart, selectEnd, localSearchFromStart, findOptions);
            }
            String resultText = FindArb.format(15, Integer.toString(this.hitReplaceCount), Integer.toString(this.hitSkipCount));
            FeedbackManager feedbackManager = editor.getFeedbackManager();
            if (feedbackManager != null) {
                feedbackManager.showFeedback(editor, resultText, 20000);
            }
        } else {
            int initialOffset = localSearchFromStart ? 0 : this._getFindStartOffset(editor);
            boolean searchForward = this.getOptionSearchForward() || localSearchFromStart;
            boolean doWrapAround = findOptions.getWrapAround() && !localSearchFromStart && !selectedRegionOnly;
            int result = -1;
            textBuffer.readLock();
            try {
                if (doRegexp) {
                    this.performCancelHighlighting(editor);
                    result = selectedRegionOnly ? this._doRegexpSearchBounded(context, patternMatcher, selectStart, selectEnd, null) : this._doRegexpSearch(context, patternMatcher, initialOffset, doWrapAround, null);
                } else {
                    result = selectedRegionOnly ? this._doSearchBounded(context, localSearchText, selectStart, selectEnd, null, findOptions) : this._doSearch(context, localSearchText, initialOffset, searchForward, doWrapAround, null, findOptions);
                }
            }
            finally {
                textBuffer.readUnlock();
            }
            if (doWrapAround) {
                int currentOffset = editor.getCaretPosition();
                if (searchForward && currentOffset < initialOffset || !searchForward && initialOffset < currentOffset) {
                    String wrappedText = FindArb.getString(14);
                    FeedbackManager feedbackManager = editor.getFeedbackManager();
                    if (feedbackManager != null) {
                        feedbackManager.showFeedback(editor, wrappedText, 5000);
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            if (result == -1) {
                this.showErrorDialog((Component)editor);
            }
        }
    }

    private boolean isNodeVersioned(Context context) {
        if (VCSManager.getVCSManager() == null) {
            return false;
        }
        Node node = context.getNode();
        return node != null && node.getURL() != null && VCSManager.getVCSManager().isVersioned(node.getURL());
    }

    private static BasicEditorPane _getEditorPane(Context context) {
        return ((FindableEditor)context.getView()).getFocusedEditorPane();
    }

    private int _doSearch(Context context, String localSearchText, int searchStart, boolean searchForward, boolean wrapAround, int[] foundOffsets, FindOptions findOptions) {
        BasicEditorPane editor = FindDialog._getEditorPane(context);
        FindHighlightPlugin findPlugin = FindController.getFindHighlightPlugin(editor);
        int offsetFound = findPlugin.findText(localSearchText, searchStart, searchForward, findOptions.getMatchCase(), wrapAround, findOptions.getWholeWordOnly(), findOptions.getHighlightOccurrences());
        if (offsetFound != -1) {
            int foundStart = offsetFound;
            int foundEnd = offsetFound + localSearchText.length();
            if (foundOffsets != null) {
                foundOffsets[0] = foundStart;
                foundOffsets[1] = foundEnd;
            } else {
                this._setCaretPosition(context, foundStart, foundEnd, false);
            }
        }
        return offsetFound;
    }

    private int _doSearchBounded(Context context, String localSearchText, int searchStart, int searchEnd, int[] foundOffsets, FindOptions findOptions) {
        BasicEditorPane editor = FindDialog._getEditorPane(context);
        FindHighlightPlugin findPlugin = FindController.getFindHighlightPlugin(editor);
        int offsetFound = findPlugin.findText(localSearchText, searchStart, true, findOptions.getMatchCase(), false, findOptions.getWholeWordOnly(), findOptions.getHighlightOccurrences());
        if (offsetFound == -1) {
            return -1;
        }
        int foundStart = offsetFound;
        int foundEnd = offsetFound + localSearchText.length();
        if (foundEnd > searchEnd) {
            return -1;
        }
        if (foundOffsets != null) {
            foundOffsets[0] = foundStart;
            foundOffsets[1] = foundEnd;
        } else {
            this._setCaretPosition(context, foundStart, foundEnd, false);
        }
        return offsetFound;
    }

    private int _doRegexpSearch(Context context, Matcher patternMatcher, int searchStart, boolean wrapAround, int[] foundOffsets) {
        boolean result;
        try {
            result = patternMatcher.find(searchStart);
            if (!result && wrapAround && searchStart != 0) {
                result = patternMatcher.find(0);
            }
        }
        catch (RuntimeException e) {
            result = false;
        }
        if (!result) {
            return -1;
        }
        int start = patternMatcher.start();
        int end = patternMatcher.end();
        if (foundOffsets != null) {
            foundOffsets[0] = start;
            foundOffsets[1] = end;
        } else {
            this._setCaretPosition(context, start, end, false);
        }
        return start;
    }

    private int _doRegexpSearchBounded(Context context, Matcher patternMatcher, int searchStart, int searchEnd, int[] foundOffsets) {
        boolean result = patternMatcher.find(searchStart);
        if (!result) {
            return -1;
        }
        int start = patternMatcher.start();
        int end = patternMatcher.end();
        if (end > searchEnd) {
            return -1;
        }
        if (foundOffsets != null) {
            foundOffsets[0] = start;
            foundOffsets[1] = end;
        } else {
            this._setCaretPosition(context, start, end, false);
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doReplace(Context context, String localSearchText, int searchStart, int searchEnd, boolean forceFromStart, FindOptions findOptions) {
        boolean doGlobalScope;
        boolean replaceOk = true;
        BasicEditorPane editor = FindDialog._getEditorPane(context);
        boolean bl = doGlobalScope = findOptions.getScope() == 3;
        if (doGlobalScope) {
            editor.beginEdit(replaceAllDescriptor);
        }
        try {
            boolean doSelectedRegion;
            boolean doWrapAround = findOptions.getWrapAround();
            if (doGlobalScope && doWrapAround) {
                forceFromStart = true;
            }
            int initialOffset = forceFromStart ? 0 : this._getReplaceStartOffset(editor, false);
            boolean bl2 = doSelectedRegion = searchStart != -1 && searchEnd != -1;
            if (doSelectedRegion) {
                Position endPosition = editor.getDocument().createPosition(searchEnd);
                this._doRegionalReplace(context, localSearchText, true, searchStart, endPosition, findOptions);
            } else if (forceFromStart || initialOffset == 0) {
                this._doRegionalReplace(context, localSearchText, true, 0, null, findOptions);
            } else {
                boolean searchForward = this.getOptionSearchForward();
                Position stopPosition = null;
                if (doWrapAround && !searchForward) {
                    stopPosition = editor.getDocument().createPosition(initialOffset);
                }
                replaceOk = this._doRegionalReplace(context, localSearchText, searchForward, initialOffset, null, findOptions);
                if (doWrapAround && searchForward) {
                    stopPosition = editor.getDocument().createPosition(initialOffset);
                }
                if (stopPosition != null && replaceOk) {
                    int nextOffset = searchForward ? 0 : editor.getDocument().getLength();
                    replaceOk = this._doRegionalReplace(context, localSearchText, searchForward, nextOffset, stopPosition, findOptions);
                }
                if (doGlobalScope && stopPosition != null) {
                    this._setCaretPosition(context, stopPosition.getOffset(), stopPosition.getOffset(), true);
                }
            }
        }
        catch (BadLocationException e) {
        }
        finally {
            if (doGlobalScope) {
                editor.endEdit();
            }
        }
        if (replaceOk && this.hitSkipCount == 0 && this.hitReplaceCount == 0) {
            this.showErrorDialog((Component)editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doRegexpReplace(Context context, Matcher patternMatcher, int searchStart, int searchEnd, boolean forceFromStart, FindOptions findOptions) {
        boolean doGlobalScope;
        boolean replaceOk = true;
        BasicEditorPane editor = FindDialog._getEditorPane(context);
        boolean bl = doGlobalScope = findOptions.getScope() == 3;
        if (doGlobalScope) {
            editor.beginEdit(replaceAllDescriptor);
        }
        try {
            boolean doSelectedRegion;
            boolean doWrapAround = findOptions.getWrapAround();
            if (doGlobalScope && doWrapAround) {
                forceFromStart = true;
            }
            int initialOffset = forceFromStart ? 0 : this._getReplaceStartOffset(editor, true);
            boolean bl2 = doSelectedRegion = searchStart != -1 && searchEnd != -1;
            if (doSelectedRegion) {
                Position endPosition = editor.getDocument().createPosition(searchEnd);
                this._doRegionalRegexpReplace(context, patternMatcher, searchStart, endPosition, findOptions);
            } else if (forceFromStart || initialOffset == 0) {
                this._doRegionalRegexpReplace(context, patternMatcher, 0, null, findOptions);
            } else {
                boolean searchForward = this.getOptionSearchForward();
                Position stopPosition = null;
                if (doWrapAround && !searchForward) {
                    stopPosition = editor.getDocument().createPosition(initialOffset);
                }
                replaceOk = this._doRegionalRegexpReplace(context, patternMatcher, initialOffset, null, findOptions);
                if (doWrapAround && searchForward) {
                    stopPosition = editor.getDocument().createPosition(initialOffset);
                }
                if (stopPosition != null && replaceOk) {
                    int nextOffset = searchForward ? 0 : editor.getDocument().getLength();
                    replaceOk = this._doRegionalRegexpReplace(context, patternMatcher, nextOffset, stopPosition, findOptions);
                }
                if (doGlobalScope && stopPosition != null) {
                    this._setCaretPosition(context, stopPosition.getOffset(), stopPosition.getOffset(), true);
                }
            }
        }
        catch (BadLocationException e) {
        }
        finally {
            if (doGlobalScope) {
                editor.endEdit();
            }
        }
        if (replaceOk && this.hitSkipCount == 0 && this.hitReplaceCount == 0) {
            this.showErrorDialog((Component)editor);
        }
    }

    private boolean _doRegionalReplace(Context context, String localSearchText, boolean forceForward, int searchStart, Position searchEndPosition, FindOptions findOptions) {
        boolean searchForward;
        int offset = searchStart;
        int[] foundOffsets = new int[2];
        BasicEditorPane editor = FindDialog._getEditorPane(context);
        String replaceText = this.getReplaceText();
        boolean haveToCloseTransaction = false;
        boolean bl = searchForward = this.getOptionSearchForward() || forceForward;
        while (true) {
            int replaceLength;
            if ((offset = this._doSearch(context, localSearchText, offset, searchForward, false, foundOffsets, findOptions)) == -1) {
                if (haveToCloseTransaction) {
                    editor.endEdit();
                }
                return true;
            }
            if (searchEndPosition != null) {
                if (searchForward) {
                    int endOffset = foundOffsets[1];
                    if (endOffset > searchEndPosition.getOffset()) {
                        if (haveToCloseTransaction) {
                            editor.endEdit();
                        }
                        return true;
                    }
                } else {
                    int startOffset = foundOffsets[0];
                    if (startOffset < searchEndPosition.getOffset()) {
                        if (haveToCloseTransaction) {
                            editor.endEdit();
                        }
                        return true;
                    }
                }
            }
            boolean replaceDone = false;
            if (findOptions.getScope() == 3) {
                this._replaceOccurrence(context, null, foundOffsets, replaceText, false);
                replaceDone = true;
            } else {
                if (findOptions.getScope() == 1) {
                    this._replaceOccurrence(context, replaceDescriptor, foundOffsets, replaceText, true);
                    return false;
                }
                if (findOptions.getScope() == 2) {
                    this._setCaretPosition(context, foundOffsets[0], foundOffsets[1], false);
                    int result = this._showReplaceDialog();
                    if (result == 0) {
                        this._replaceOccurrence(context, replaceDescriptor, foundOffsets, replaceText, true);
                        replaceDone = true;
                    } else {
                        if (result == 2) {
                            ++this.hitSkipCount;
                            return false;
                        }
                        if (result == 3) {
                            findOptions.setScope(3);
                            haveToCloseTransaction = true;
                            editor.beginEdit(replaceAllDescriptor);
                            this._replaceOccurrence(context, null, foundOffsets, replaceText, false);
                            replaceDone = true;
                        } else if (result == 1) {
                            ++this.hitSkipCount;
                            replaceDone = false;
                        }
                    }
                }
            }
            if (searchForward) {
                if (replaceDone) {
                    replaceLength = replaceText.length();
                    offset += replaceLength;
                    continue;
                }
                ++offset;
                continue;
            }
            if (replaceDone) {
                replaceLength = replaceText.length();
                offset -= replaceLength;
                continue;
            }
            --offset;
        }
    }

    private boolean _doRegionalRegexpReplace(Context context, Matcher patternMatcher, int searchStart, Position searchEndPosition, FindOptions findOptions) {
        int length;
        int extraAdvance;
        int offset = searchStart;
        int[] foundOffsets = new int[2];
        BasicEditorPane editor = FindDialog._getEditorPane(context);
        String replaceText = this.getReplaceText();
        boolean haveToCloseTransaction = false;
        do {
            int endOffset;
            if ((offset = this._doRegexpSearch(context, patternMatcher, offset, false, foundOffsets)) == -1) {
                if (haveToCloseTransaction) {
                    editor.endEdit();
                }
                return true;
            }
            if (searchEndPosition != null && (endOffset = foundOffsets[1]) > searchEndPosition.getOffset()) {
                if (haveToCloseTransaction) {
                    editor.endEdit();
                }
                return true;
            }
            boolean replaceDone = false;
            int replaceLength = 0;
            int matchLength = patternMatcher.end() - patternMatcher.start();
            if (findOptions.getScope() == 3) {
                replaceLength = this._replaceRegexpOccurrence(context, patternMatcher, null, foundOffsets, replaceText, false);
                replaceDone = true;
            } else {
                if (findOptions.getScope() == 1) {
                    this._replaceRegexpOccurrence(context, patternMatcher, replaceDescriptor, foundOffsets, replaceText, true);
                    return false;
                }
                if (findOptions.getScope() == 2) {
                    this._setCaretPosition(context, foundOffsets[0], foundOffsets[1], false);
                    int result = this._showReplaceDialog();
                    if (result == 0) {
                        replaceLength = this._replaceRegexpOccurrence(context, patternMatcher, replaceDescriptor, foundOffsets, replaceText, true);
                        replaceDone = true;
                    } else {
                        if (result == 2) {
                            ++this.hitSkipCount;
                            return false;
                        }
                        if (result == 3) {
                            findOptions.setScope(3);
                            editor.beginEdit(replaceAllDescriptor);
                            haveToCloseTransaction = true;
                            replaceLength = this._replaceRegexpOccurrence(context, patternMatcher, null, foundOffsets, replaceText, false);
                            replaceDone = true;
                        } else if (result == 1) {
                            ++this.hitSkipCount;
                            replaceDone = false;
                        }
                    }
                }
            }
            String patternText = this.getSearchText();
            int n = extraAdvance = patternText.endsWith("$") ? 1 : 0;
            if (replaceDone) {
                offset += replaceLength + extraAdvance;
                continue;
            }
            offset += matchLength + extraAdvance;
        } while (extraAdvance != 1 || offset <= (length = editor.getDocument().getLength()));
        return true;
    }

    private void _setCaretPosition(Context context, int startOffset, int endOffset, boolean isEdit) {
        NavigationManager mgr = NavigationManager.getNavigationManager();
        OffsetNavigationPoint point = new OffsetNavigationPoint(context, startOffset, endOffset - startOffset);
        try {
            if (mgr != null) {
                mgr.navigateTo((NavigationPoint)point, isEdit);
            } else {
                point.navigate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _replaceOccurrence(Context context, EditDescriptor descriptor, int[] foundOffsets, String replaceText, boolean positionCaretAfter) {
        BasicEditorPane editor = FindDialog._getEditorPane(context);
        int replaceStart = Math.min(foundOffsets[0], foundOffsets[1]);
        int replaceEnd = Math.max(foundOffsets[0], foundOffsets[1]);
        int replaceLength = replaceEnd - replaceStart;
        if (descriptor != null) {
            editor.beginEdit(descriptor);
        }
        try {
            Document document = editor.getDocument();
            document.remove(replaceStart, replaceLength);
            document.insertString(replaceStart, replaceText, null);
            boolean replacePerformed = true;
            ++this.hitReplaceCount;
            if (positionCaretAfter) {
                int start = replaceStart;
                int end = replaceStart + replaceText.length();
                this._setCaretPosition(context, start, end, true);
            }
        }
        catch (BadLocationException e) {
        }
        finally {
            if (descriptor != null) {
                editor.endEdit();
            }
        }
    }

    private int _replaceRegexpOccurrence(Context context, Matcher patternMatcher, EditDescriptor descriptor, int[] foundOffsets, String replaceText, boolean positionCaretAfter) {
        BasicEditorPane editor = FindDialog._getEditorPane(context);
        BasicDocument document = (BasicDocument)editor.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        int numParens = patternMatcher.groupCount() + 1;
        String[] matches = new String[numParens];
        for (int i = 0; i < numParens; ++i) {
            int parenStart = patternMatcher.start(i);
            int parenLength = patternMatcher.end(i) - parenStart;
            matches[i] = textBuffer.getString(parenStart, parenLength);
        }
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        int length = replaceText.length();
        while (offset < length) {
            int index = replaceText.indexOf(92, offset);
            if (index == -1) {
                buffer.append(replaceText.substring(offset));
                break;
            }
            buffer.append(replaceText.substring(offset, index));
            offset = index;
            int indexDigit = index + 1;
            if (indexDigit < length) {
                int c = replaceText.charAt(indexDigit);
                switch (c) {
                    case 38: {
                        c = 48;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        int digit = c - 48;
                        if (digit >= numParens) break;
                        buffer.append(matches[digit]);
                        break;
                    }
                    case 92: {
                        buffer.append('\\');
                        break;
                    }
                    case 110: 
                    case 114: {
                        buffer.append('\n');
                        break;
                    }
                    case 116: {
                        buffer.append('\t');
                        break;
                    }
                    default: {
                        buffer.append(replaceText.substring(offset, offset + 2));
                    }
                }
                offset += 2;
                continue;
            }
            buffer.append(replaceText.substring(offset, offset + 1));
            ++offset;
        }
        String substituteText = buffer.toString();
        this._replaceOccurrence(context, descriptor, foundOffsets, substituteText, positionCaretAfter);
        return substituteText.length();
    }

    private int _getReplaceStartOffset(BasicEditorPane editor, boolean forceForward) {
        if (this._hasSelection(editor)) {
            BasicDocument document = (BasicDocument)editor.getDocument();
            int length = document.getLength();
            if (this.getOptionSearchForward() || forceForward) {
                int newStart = Math.min(editor.getSelectionStart(), length);
                return newStart;
            }
            int newStart = Math.max(editor.getSelectionEnd(), 0);
            return newStart;
        }
        return editor.getCaretPosition();
    }

    private int _getFindStartOffset(BasicEditorPane editor) {
        if (this._hasSelection(editor)) {
            BasicDocument document = (BasicDocument)editor.getDocument();
            int length = document.getLength();
            if (this.getOptionSearchForward()) {
                int newStart = Math.min(editor.getSelectionStart() + 1, length);
                return newStart;
            }
            int newStart = Math.max(editor.getSelectionEnd() - 1, 0);
            return newStart;
        }
        return editor.getCaretPosition();
    }

    static String getInitialText(BasicEditorPane editor) {
        if (NO_INITIAL_TEXT) {
            return null;
        }
        String s = null;
        try {
            int start = editor.getSelectionStart();
            int end = editor.getSelectionEnd();
            if (start == end) {
                int nLine = editor.getLineFromOffset(start);
                int nLineStart = editor.getLineStartOffset(nLine);
                int nLineEnd = editor.getLineEndOffset(nLine);
                int nLineLength = nLineEnd - nLineStart;
                if (nLineStart < nLineEnd) {
                    char c;
                    Document doc = editor.getDocument();
                    String line = doc.getText(nLineStart, nLineEnd - nLineStart);
                    for (start = end = start - nLineStart; start > 0 && (Character.isJavaIdentifierPart(c = line.charAt(start - 1)) || Character.isJavaIdentifierStart(c)); --start) {
                    }
                    while (end < nLineLength && (Character.isJavaIdentifierPart(c = line.charAt(end)) || Character.isJavaIdentifierStart(c))) {
                        ++end;
                    }
                    if (start != end) {
                        s = line.substring(start, end);
                    }
                }
            } else {
                int nLineEnd;
                int nLineStart = editor.getLineFromOffset(start);
                if (nLineStart == (nLineEnd = editor.getLineFromOffset(end))) {
                    Document doc = editor.getDocument();
                    s = doc.getText(start, end - start);
                }
            }
        }
        catch (BadLocationException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return s;
    }

    private boolean _hasSelection(BasicEditorPane editor) {
        return editor.getSelectionStart() != editor.getSelectionEnd();
    }

    public boolean canPerformFind(int findType, FindOptions findOptions) {
        switch (findType) {
            case 1: 
            case 5: 
            case 6: {
                return true;
            }
            case 4: {
                if (findOptions.getRegexpSearch()) {
                    return false;
                }
            }
            case 2: {
                if (findOptions.getRegexpSearch() && this.searchPattern == null) {
                    return false;
                }
                String localSearchText = this.getSearchText();
                return localSearchText != null && localSearchText.length() > 0;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void performCancelHighlighting(BasicEditorPane editor) {
        FindHighlightPlugin findPlugin = (FindHighlightPlugin)editor.getProperty("*find_plugin*");
        if (findPlugin != null) {
            findPlugin.clearFindHighlighting();
        }
    }

    public boolean canCancelHighlighting(BasicEditorPane editor) {
        FindHighlightPlugin findPlugin = (FindHighlightPlugin)editor.getProperty("*find_plugin*");
        if (findPlugin != null) {
            return findPlugin.hasFindHighlighting();
        }
        return false;
    }

    public boolean getOptionSearchForward() {
        return this.optionSearchForward;
    }

    public void setOptionSearchForward(boolean searchForward) {
        this.optionSearchForward = searchForward;
    }

    public boolean getOptionSelectedText() {
        return this.optionSelectedText;
    }

    public void setOptionSelectedText(boolean selectedText) {
        this.optionSelectedText = selectedText;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
        this.searchPattern = null;
    }

    public String getReplaceText() {
        return this._replaceText;
    }

    public void setReplaceText(String replaceText) {
        this._replaceText = replaceText;
    }

    public boolean isOptionReplace() {
        return this.optionReplace;
    }

    public void setOptionReplace(boolean replace) {
        this.optionReplace = replace;
    }

    private boolean showDialog(BasicEditorPane editor, Context context, String initialText, int findType, FindOptions findOptions) {
        boolean result;
        String findText = FindArb.getString(2);
        JLabel findLabel = new JLabel(findText);
        if (initialText == null && (initialText = this.getSearchText()) == null) {
            initialText = "";
        }
        List<String> historyList = findOptions.getSearchHistory();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(historyList.toArray());
        this.findComboBox = new CappedComboBox(model, 300);
        if (!historyList.contains(initialText)) {
            model.insertElementAt(initialText, 0);
        }
        this.findComboBox.setSelectedItem(initialText);
        this.findComboBox.setEditable(true);
        this.findComboBox.getEditor().selectAll();
        Component findComboBoxEditor = this.findComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)findLabel, (Component)findComboBoxEditor, (String)findText);
        ((JTextComponent)findComboBoxEditor).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindDialog.this.validateOK(e.getDocument().getLength() > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindDialog.this.validateOK(e.getDocument().getLength() > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindDialog.this.validateOK(e.getDocument().getLength() > 0);
            }
        });
        String replaceText = FindArb.getString(3);
        final JCheckBox replaceCheckBox = new JCheckBox("", this.isOptionReplace());
        ResourceUtils.resButton((AbstractButton)replaceCheckBox, (String)replaceText);
        replaceCheckBox.setSelected(findType == 3);
        String replaceFieldText = StringUtils.stripMnemonic((String)replaceText);
        if (!editor.isEditable() && !this.isNodeVersioned(context)) {
            replaceCheckBox.setSelected(false);
            replaceCheckBox.setEnabled(false);
        }
        List<String> replaceHistory = findOptions.getReplaceHistory();
        final CappedComboBox replaceComboBox = new CappedComboBox(replaceHistory.toArray(), 300);
        replaceComboBox.setEditable(true);
        replaceComboBox.setSelectedItem(this.getReplaceText());
        replaceComboBox.getEditor().selectAll();
        replaceComboBox.getAccessibleContext().setAccessibleName(replaceFieldText);
        ((JTextComponent)replaceComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindDialog.this.validateOK(((JTextComponent)FindDialog.this.findComboBox.getEditor().getEditorComponent()).getDocument().getLength() > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindDialog.this.validateOK(((JTextComponent)FindDialog.this.findComboBox.getEditor().getEditorComponent()).getDocument().getLength() > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindDialog.this.validateOK(((JTextComponent)FindDialog.this.findComboBox.getEditor().getEditorComponent()).getDocument().getLength() > 0);
            }
        });
        JPanel findPanel = new JPanel(new GridBagLayout());
        Insets fieldInsets = new Insets(3, 3, 3, 3);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, 0, 0);
        findPanel.add((Component)findLabel, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0);
        findPanel.add((Component)this.findComboBox, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, 0, 0);
        findPanel.add((Component)replaceCheckBox, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0);
        findPanel.add((Component)replaceComboBox, constraints);
        String matchCaseText = FindArb.getString(4);
        JCheckBox caseCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)caseCheckBox, (String)matchCaseText);
        caseCheckBox.setSelected(findOptions.getMatchCase());
        String wholeWordText = FindArb.getString(5);
        final JCheckBox wordCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)wordCheckBox, (String)wholeWordText);
        wordCheckBox.setSelected(findOptions.getWholeWordOnly());
        String fromStartText = FindArb.getString(6);
        final JCheckBox startCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)startCheckBox, (String)fromStartText);
        startCheckBox.setSelected(findOptions.getSearchFromBeginning());
        String highlightText = FindArb.getString(7);
        final JCheckBox highlightCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)highlightCheckBox, (String)highlightText);
        highlightCheckBox.setSelected(findOptions.getHighlightOccurrences());
        String wrapText = FindArb.getString(8);
        final JCheckBox wrapCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)wrapCheckBox, (String)wrapText);
        wrapCheckBox.setSelected(findOptions.getWrapAround());
        String regexpText = FindArb.getString(9);
        final JCheckBox regexpCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)regexpCheckBox, (String)regexpText);
        regexpCheckBox.setSelected(findOptions.getRegexpSearch());
        String selectedText = FindArb.getString(10);
        final JCheckBox selectedCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)selectedCheckBox, (String)selectedText);
        selectedCheckBox.setSelected(this.getOptionSelectedText());
        boolean hasSelection = editor.hasSelection();
        if (!hasSelection) {
            selectedCheckBox.setEnabled(false);
            selectedCheckBox.setSelected(false);
        }
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        String optionsText = FindArb.getString(20);
        TitledBorder optionsBorder = BorderFactory.createTitledBorder(optionsText);
        optionsPanel.setBorder(optionsBorder);
        Insets contentsInsets = new Insets(0, 8, 0, 0);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        optionsPanel.add((Component)caseCheckBox, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        optionsPanel.add((Component)startCheckBox, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        optionsPanel.add((Component)highlightCheckBox, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        optionsPanel.add((Component)wrapCheckBox, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        optionsPanel.add((Component)wordCheckBox, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        optionsPanel.add((Component)regexpCheckBox, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        optionsPanel.add((Component)selectedCheckBox, constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 1, contentsInsets, 0, 0);
        optionsPanel.add(Box.createVerticalGlue(), constraints);
        String forwardText = FindArb.getString(17);
        final JRadioButton forwardRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)forwardRadio, (String)forwardText);
        String backwardText = FindArb.getString(18);
        final JRadioButton backwardRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)backwardRadio, (String)backwardText);
        ButtonGroup directionGroup = new ButtonGroup();
        directionGroup.add(forwardRadio);
        directionGroup.add(backwardRadio);
        JRadioButton selectedRadio = this.getOptionSearchForward() ? forwardRadio : backwardRadio;
        selectedRadio.setSelected(true);
        JPanel directionPanel = new JPanel(new GridBagLayout());
        String directionText = FindArb.getString(19);
        TitledBorder directionBorder = BorderFactory.createTitledBorder(directionText);
        directionPanel.setBorder(directionBorder);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        directionPanel.add((Component)forwardRadio, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        directionPanel.add((Component)backwardRadio, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, contentsInsets, 0, 0);
        directionPanel.add(Box.createVerticalGlue(), constraints);
        String singleText = FindArb.getString(22);
        final JRadioButton singleRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)singleRadio, (String)singleText);
        String promptedText = FindArb.getString(24);
        final JRadioButton promptedRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)promptedRadio, (String)promptedText);
        String globalText = FindArb.getString(23);
        final JRadioButton globalRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)globalRadio, (String)globalText);
        ButtonGroup scopeGroup = new ButtonGroup();
        scopeGroup.add(singleRadio);
        scopeGroup.add(promptedRadio);
        scopeGroup.add(globalRadio);
        selectedRadio = findOptions.getScope() == 3 ? globalRadio : (findOptions.getScope() == 2 ? promptedRadio : singleRadio);
        selectedRadio.setSelected(true);
        JPanel scopePanel = new JPanel(new GridBagLayout());
        String scopeText = FindArb.getString(21);
        TitledBorder scopeBorder = BorderFactory.createTitledBorder(scopeText);
        scopePanel.setBorder(scopeBorder);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        scopePanel.add((Component)singleRadio, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        scopePanel.add((Component)promptedRadio, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, contentsInsets, 0, 0);
        scopePanel.add((Component)globalRadio, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, contentsInsets, 0, 0);
        scopePanel.add(Box.createVerticalGlue(), constraints);
        ItemListener tracker = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean replaceActive = replaceCheckBox.isSelected() && replaceCheckBox.isEnabled();
                replaceComboBox.setEnabled(replaceActive);
                singleRadio.setEnabled(replaceActive);
                promptedRadio.setEnabled(replaceActive);
                globalRadio.setEnabled(replaceActive);
                boolean regexpActive = regexpCheckBox.isSelected() && regexpCheckBox.isEnabled();
                highlightCheckBox.setEnabled(!regexpActive);
                wordCheckBox.setEnabled(!regexpActive);
                boolean selectedActive = selectedCheckBox.isSelected() && selectedCheckBox.isEnabled();
                startCheckBox.setEnabled(!selectedActive);
                boolean startActive = startCheckBox.isSelected() && startCheckBox.isEnabled();
                boolean enableForwardBackward = !regexpActive && !selectedActive && !startActive;
                forwardRadio.setEnabled(enableForwardBackward);
                backwardRadio.setEnabled(enableForwardBackward);
                boolean enableWrap = !selectedActive && !startActive;
                wrapCheckBox.setEnabled(enableWrap);
            }
        };
        replaceCheckBox.addItemListener(tracker);
        regexpCheckBox.addItemListener(tracker);
        selectedCheckBox.addItemListener(tracker);
        startCheckBox.addItemListener(tracker);
        tracker.itemStateChanged(null);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        Insets mainInsets = new Insets(2, 2, 2, 2);
        constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, mainInsets, 0, 0);
        mainPanel.add((Component)findPanel, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 2, 0.5, 1.0, 17, 1, mainInsets, 0, 0);
        mainPanel.add((Component)optionsPanel, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 0.5, 0.5, 17, 1, mainInsets, 0, 0);
        mainPanel.add((Component)directionPanel, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.5, 0.5, 17, 1, mainInsets, 0, 0);
        mainPanel.add((Component)scopePanel, constraints);
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic((JComponent)mainPanel, "f1_idedfindreplacetext_html");
        }
        if (result = this.runDialog(mainPanel, findComboBoxEditor, findType)) {
            this.setSearchText((String)this.findComboBox.getEditor().getItem());
            this.setReplaceText((String)replaceComboBox.getEditor().getItem());
            findOptions.setMatchCase(caseCheckBox.isSelected());
            findOptions.setWholeWordOnly(wordCheckBox.isSelected());
            findOptions.setSearchFromBeginning(startCheckBox.isSelected());
            this.setOptionSearchForward(forwardRadio.isSelected());
            findOptions.setHighlightOccurrences(highlightCheckBox.isSelected());
            findOptions.setWrapAround(wrapCheckBox.isSelected());
            if (hasSelection) {
                this.setOptionSelectedText(selectedCheckBox.isSelected());
            }
            this.setOptionReplace(replaceCheckBox.isSelected());
            findOptions.setRegexpSearch(regexpCheckBox.isSelected());
            if (globalRadio.isSelected()) {
                findOptions.setScope(3);
            } else if (promptedRadio.isSelected()) {
                findOptions.setScope(2);
            } else {
                findOptions.setScope(1);
            }
            String text = this.getSearchText();
            if (text != null && text.length() > 0) {
                findOptions.updateSearchHistory(text);
            }
            if ((text = this.getReplaceText()) != null && text.length() > 0) {
                findOptions.updateReplaceHistory(text);
            }
            if (findOptions.getRegexpSearch()) {
                try {
                    int matchFlags = 8;
                    if (!findOptions.getMatchCase()) {
                        matchFlags |= 0x42;
                    }
                    this.searchPattern = Pattern.compile(this.getSearchText(), matchFlags);
                }
                catch (PatternSyntaxException e) {
                    this.searchPattern = null;
                    this.showInvalidRegexpDialog((Component)editor, e.getPattern(), e.getDescription());
                    return false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runDialog(JComponent content, Component defaultComp, int findType) {
        boolean canOK;
        String title = findType == 3 ? FindArb.getString(1) : FindArb.getString(0);
        this.dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)content, (Component)defaultComp, (String)title);
        String searchText = (String)this.findComboBox.getEditor().getItem();
        boolean bl = canOK = searchText != null && searchText.length() > 0;
        if (this.dialog != null) {
            this.dialog.setOKButtonEnabled(canOK);
        }
        try {
            boolean bl2 = this.dialog.runDialog();
            return bl2;
        }
        finally {
            this.dialog.dispose();
        }
    }

    private void validateOK(boolean canOK) {
        if (this.dialog != null) {
            this.dialog.setOKButtonEnabled(canOK);
        }
    }

    private void showErrorDialog(Component parent) {
        String notFoundText = FindArb.getString(13);
        String errorTitle = FindArb.getString(11);
        MessageDialog.information((Component)parent, (Object)notFoundText, (String)errorTitle, (String)"f1_idedfindreplacenotfound_html");
    }

    private void showInvalidRegexpDialog(Component parent, String regexpText, String regexpErrorText) {
        String invalidRegexpText = FindArb.format(16, regexpText, regexpErrorText);
        String errorTitle = FindArb.getString(12);
        MessageDialog.error((Component)parent, (Object)invalidRegexpText, (String)errorTitle, (String)"f1_idedfindreplaceinvalidregexp_html");
    }

    private int _showReplaceDialog() {
        if (this.replaceDialog == null) {
            this.replaceDialog = new ReplaceOccurenceDialog();
        }
        return this.replaceDialog.runDialog();
    }

    static {
        String editName = FindArb.getString(55);
        replaceDescriptor = new EditDescriptor(editName);
        editName = FindArb.getString(56);
        replaceAllDescriptor = new EditDescriptor(editName);
        String property = System.getProperty("find.disable.autofill");
        NO_INITIAL_TEXT = "true".equalsIgnoreCase(property);
        if (NO_INITIAL_TEXT) {
            // empty if block
        }
    }

    private static class FindHighlightAdaptor
    implements NavigableHighlighter {
        private FindHighlightAdaptor() {
        }

        @Override
        public boolean hasHighlights(BasicEditorPane basicEditorPane) {
            if (basicEditorPane == null) {
                return false;
            }
            FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(basicEditorPane);
            return findHighlightPlugin.hasFindHighlighting();
        }

        @Override
        public boolean getHighlightAfter(BasicEditorPane basicEditorPane, int position, int[] range) {
            if (basicEditorPane == null) {
                return false;
            }
            FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(basicEditorPane);
            return findHighlightPlugin.getFirstHighlightAfter(position, range);
        }

        @Override
        public boolean getHighlightBefore(BasicEditorPane basicEditorPane, int position, int[] range) {
            if (basicEditorPane == null) {
                return false;
            }
            FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(basicEditorPane);
            return findHighlightPlugin.getFirstHighlightBefore(position, range);
        }

        @Override
        public void clearHighlights(BasicEditorPane basicEditorPane) {
            if (basicEditorPane == null) {
                return;
            }
            FindHighlightPlugin findHighlightPlugin = FindController.getFindHighlightPlugin(basicEditorPane);
            findHighlightPlugin.clearFindHighlighting();
        }
    }

    private static final class SubCharSequence
    implements CharSequence {
        private CharSequence _sequence;
        private int _start;
        private int _length;

        private SubCharSequence(CharSequence charSequence, int start, int end) {
            this._sequence = charSequence;
            this._start = start;
            this._length = end - this._start;
        }

        @Override
        public int length() {
            return this._length;
        }

        @Override
        public char charAt(int index) {
            if (index < 0 || index >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this._sequence.charAt(this._start + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start < 0 || end < 0 || start > end || end >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return new SubCharSequence(this, start, end);
        }

        @Override
        public String toString() {
            int count = this.length();
            StringBuffer buffer = new StringBuffer(count);
            for (int i = 0; i < count; ++i) {
                buffer.append(this.charAt(0));
            }
            return buffer.toString();
        }
    }

    private static final class BufferCharSequence
    implements CharSequence {
        private ReadTextBuffer _buffer;

        private BufferCharSequence(ReadTextBuffer buffer) {
            this._buffer = buffer;
        }

        @Override
        public int length() {
            return this._buffer.getLength();
        }

        @Override
        public char charAt(int index) {
            if (index < 0 || index >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this._buffer.getChar(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start < 0 || end < 0 || start > end || end >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return new SubCharSequence(this, start, end);
        }

        @Override
        public String toString() {
            return this._buffer.getString(0, this.length());
        }
    }

    private static final class CappedComboBox
    extends JComboBox {
        private int maxWidth;

        private CappedComboBox(ComboBoxModel model, int maxWidth) {
            super(model);
            this.maxWidth = maxWidth;
        }

        private CappedComboBox(Object[] items, int maxWidth) {
            super(items);
            this.maxWidth = maxWidth;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension prefSize = new Dimension();
            Dimension defaultPrefSize = super.getPreferredSize();
            prefSize.height = defaultPrefSize.height;
            prefSize.width = Math.min(this.maxWidth, defaultPrefSize.width);
            return prefSize;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension maxSize = new Dimension();
            Dimension defaultMaxSize = super.getMaximumSize();
            maxSize.height = defaultMaxSize.height;
            maxSize.width = Math.min(this.maxWidth, defaultMaxSize.width);
            return maxSize;
        }
    }

    private class ReplaceOccurenceDialog
    extends WindowAdapter
    implements ActionListener {
        JDialog dialog;
        int resultCode = -1;
        JLabel message = new JLabel();
        JPanel buttonPanel = new JPanel();
        JButton btnYes = new JButton();
        JButton btnNo = new JButton();
        JButton btnCancel = new JButton();
        JButton btnGlobal = new JButton();
        private static final String _KEY_YES = "YES";
        private static final String _KEY_NO = "NO";
        private static final String _KEY_CANCEL = "CANCEL";
        private static final String _KEY_GLOBAL = "GLOBAL";

        ReplaceOccurenceDialog() {
            String text = FindArb.getString(27);
            this.btnYes.setText(StringUtils.stripMnemonic((String)text));
            this.btnYes.setActionCommand(_KEY_YES);
            this.btnYes.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
            text = FindArb.getString(28);
            this.btnNo.setText(StringUtils.stripMnemonic((String)text));
            this.btnNo.setActionCommand(_KEY_NO);
            this.btnNo.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
            text = FindArb.getString(29);
            this.btnCancel.setText(StringUtils.stripMnemonic((String)text));
            this.btnCancel.setActionCommand(_KEY_CANCEL);
            this.btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
            text = FindArb.getString(30);
            this.btnGlobal.setText(StringUtils.stripMnemonic((String)text));
            this.btnGlobal.setActionCommand(_KEY_GLOBAL);
            this.btnGlobal.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
            text = FindArb.getString(25);
            JLabel message = new JLabel(StringUtils.stripMnemonic((String)text));
            Insets defaultInsets = new Insets(2, 2, 2, 2);
            JPanel panel_dialog = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 17, 0, defaultInsets, 0, 0);
            panel_dialog.add((Component)message, constraints);
            constraints = new GridBagConstraints(0, 1, 1, 1, 0.25, 0.0, 17, 0, defaultInsets, 0, 0);
            panel_dialog.add((Component)this.btnYes, constraints);
            constraints = new GridBagConstraints(1, 1, 1, 1, 0.25, 0.0, 17, 0, defaultInsets, 0, 0);
            panel_dialog.add((Component)this.btnNo, constraints);
            constraints = new GridBagConstraints(2, 1, 1, 1, 0.25, 0.0, 17, 0, defaultInsets, 0, 0);
            panel_dialog.add((Component)this.btnGlobal, constraints);
            constraints = new GridBagConstraints(3, 1, 1, 1, 0.25, 0.0, 17, 0, defaultInsets, 0, 0);
            panel_dialog.add((Component)this.btnCancel, constraints);
            String title = FindArb.getString(26);
            this.dialog = new JDialog((Frame)Ide.getMainWindow(), title, true);
            this.dialog.getContentPane().add((Component)panel_dialog, "Center");
            this.btnYes.addActionListener(this);
            this.btnNo.addActionListener(this);
            this.btnGlobal.addActionListener(this);
            this.btnCancel.addActionListener(this);
            this.dialog.getRootPane().registerKeyboardAction(this, _KEY_CANCEL, KeyStroke.getKeyStroke(27, 0), 1);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.getRootPane().setDefaultButton(this.btnYes);
            this.dialog.addWindowListener(this);
            this.dialog.pack();
            this.dialog.setResizable(false);
            WindowUtils.centerWindow((Window)this.dialog, (Component)Ide.getMainWindow());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int runDialog() {
            try {
                this.dialog.setVisible(true);
            }
            finally {
                this.dialog.dispose();
            }
            return this.resultCode;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.resultCode = 2;
            this.dialog.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            this.resultCode = cmd == _KEY_YES ? 0 : (cmd == _KEY_NO ? 1 : (cmd == _KEY_CANCEL ? 2 : (cmd == _KEY_GLOBAL ? 3 : -1)));
            this.dialog.setVisible(false);
        }
    }
}

