/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.lang.ref.WeakReference;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

final class NodeObserver
implements Observer {
    WeakReference updaterReference;
    private Subject nodeSubject;

    NodeObserver(Subject nodeSubject, NodeUpdater nodeUpdater) {
        nodeSubject.attach((Observer)this);
        this.nodeSubject = nodeSubject;
        this.updaterReference = new WeakReference<NodeUpdater>(nodeUpdater);
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID = change.getMessageID();
        if (messageID != UpdateMessage.CHILD_REMOVED && messageID != UpdateMessage.CHILD_ADDED && messageID != UpdateMessage.PROPERTY_SET && messageID != UpdateMessage.OBJECT_RENAMED && messageID != UpdateMessage.CHILD_RENAMED && messageID != UpdateMessage.OBJECT_OPENED && messageID != UpdateMessage.ATTRIBUTE_CHANGED) {
            if (messageID == UpdateMessage.OBJECT_CLOSED) {
                this.initiateCleanup();
            } else {
                this.cancelTimer();
            }
        }
    }

    synchronized void cancelTimer() {
        if (this.updaterReference != null && this.updaterReference.get() != null) {
            NodeUpdater updater = (NodeUpdater)this.updaterReference.get();
            updater.stopTimer();
        }
    }

    synchronized void respondCleanup() {
        if (this.nodeSubject != null) {
            this.nodeSubject.detach((Observer)this);
            this.nodeSubject = null;
        }
        if (this.updaterReference != null) {
            this.updaterReference.clear();
            this.updaterReference = null;
        }
    }

    synchronized void initiateCleanup() {
        if (this.updaterReference != null && this.updaterReference.get() != null) {
            NodeUpdater updater = (NodeUpdater)this.updaterReference.get();
            updater.requestCleanup();
        }
    }
}

