/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.options.PrintingOptions;
import oracle.ide.config.Preferences;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.PageableFactory;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.print.EditorPageable;
import oracle.javatools.editor.print.PrintOptions;

public class EditorPageableFactory
implements PageableFactory {
    public Pageable create(Object object, PageFormat pageFormat) {
        return this.create(null, object, pageFormat);
    }

    public Pageable create(Context context, Object object, PageFormat pageFormat) {
        TextNode textNode = (TextNode)object;
        String fileType = CodeEditor.TYPE_PLAIN;
        String filename = "";
        if (object instanceof Node) {
            Node node = (Node)object;
            filename = URLFileSystem.getPlatformPathName((URL)node.getURL());
            fileType = CodeEditor.getTypeForNode(textNode);
            if (fileType == null || fileType.length() == 0) {
                fileType = filename;
            }
        }
        TextBuffer originalBuffer = textNode.acquireTextBuffer();
        int length = originalBuffer.getLength();
        char[] textData = originalBuffer.getChars(0, length);
        TextBuffer copyBuffer = TextBufferFactory.createTextBuffer();
        copyBuffer.append(textData);
        BasicDocument printDocument = new BasicDocument(fileType, copyBuffer);
        PrintingOptions printingOptions = PrintingOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        PrintingOptions ourCopy = (PrintingOptions)((Object)printingOptions.copyTo(null));
        EditorPageable pageable = new EditorPageable(filename, printDocument, (PrintOptions)ourCopy, pageFormat);
        return pageable;
    }
}

