/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.editor.plugins.EditorPlugin;

final class CodeEditorHook
extends HashStructureHook {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "ceditor");
    private Collection<EditorPluginReference> pluginRefCollection;

    CodeEditorHook() {
    }

    public static CodeEditorHook get() {
        return (CodeEditorHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    Collection<EditorPlugin> editorPlugins(String filetype) {
        ArrayList<EditorPlugin> plugins = new ArrayList<EditorPlugin>();
        for (EditorPluginReference ref : this.providers()) {
            EditorPlugin plugin = ref.getEditorPlugin();
            if ((filetype == null || !ref.fileTypeList.contains(filetype)) && !ref.fileTypeList.isEmpty()) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    private Collection<EditorPluginReference> providers() {
        if (this.pluginRefCollection == null) {
            List plugins = this.getHashStructure().getAsList("plugin");
            if (plugins == null) {
                return Collections.emptyList();
            }
            ArrayList<EditorPluginReference> result = new ArrayList<EditorPluginReference>(plugins.size());
            for (Object o : plugins) {
                MetaClass clazz = null;
                try {
                    HashStructure hsProvider = (HashStructure)o;
                    clazz = LazyClassAdapter.getInstance((HashStructure)hsProvider).getMetaClass("class");
                    ArrayList<String> fileTypeList = new ArrayList<String>();
                    List fileTypeObjectList = hsProvider.getAsList("filetype");
                    if (fileTypeObjectList != null) {
                        for (Object fileType : fileTypeObjectList) {
                            String typeString = ((HashStructure)fileType).getString("#text");
                            fileTypeList.add(typeString);
                        }
                    }
                    result.add(new EditorPluginReference((MetaClass<EditorPlugin>)clazz, fileTypeList));
                }
                catch (Exception e) {
                    Logger.getLogger("IDE").log(Level.SEVERE, "CodeEditorHook: Cannot create plugin " + (clazz == null ? "" : clazz.getClassName()));
                }
            }
            this.pluginRefCollection = result;
            this.dispose();
        }
        return this.pluginRefCollection;
    }

    private static final class EditorPluginReference {
        private final MetaClass<EditorPlugin> editorPluginClass;
        private final List<String> fileTypeList;

        public EditorPluginReference(MetaClass<EditorPlugin> editorPluginClass, List<String> fileTypeList) {
            this.fileTypeList = fileTypeList;
            this.editorPluginClass = editorPluginClass;
        }

        public synchronized EditorPlugin getEditorPlugin() {
            EditorPlugin editorPlugin = null;
            try {
                editorPlugin = (EditorPlugin)this.editorPluginClass.newInstance();
            }
            catch (Exception e) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create ceditor EditorPlugin provider from class " + this.editorPluginClass.getClassName(), e);
            }
            return editorPlugin;
        }
    }
}

