/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.util.Log;

public class CodeEditorGutter
extends LineGutterPlugin {
    public static final String COLUMN_NAME_LIGHTBULB = "lightbulb";
    public static final String COLUMN_NAME_BREAKPOINT = "breakpoint";
    public static final String COLUMN_NAME_WATCHPOINT = "watchpoint";
    public static final String COLUMN_NAME_IP = "ip";
    public static final int MARK_ORDER_BREAKPOINT = 0;
    public static final int MARK_ORDER_WATCHPOINT_ZERO = 1000;
    public static final int MARK_ORDER_BOOKMARK = 2000;
    public static final int MARK_ORDER_PROFILER = 2500;
    public static final int MARK_ORDER_TODO = 5000;
    public static final int MARK_ORDER_IMPLEMENTS = 3000;
    public static final int MARK_ORDER_OVERRIDES = 4000;
    public static final int MARK_ORDER_LIGHTBULB = 6000;
    public static final int MARK_ORDER_EXECUTION = 7000;
    public static final int MARK_OPTION_CLICK_DROPS_MENU = 65536;
    private static final String GUTTER_MARK = "CodeEditorContext.GUTTER_MARK";
    private static final String LINE_NUMBER = "CodeEditorContext.LINE_NUMBER";
    private static final String DROPPING_DOWN = "CodeEditorContext.DROPPING_DOWN";
    private static ContextMenu _contextMenu;
    private static GutterMark _lastDroppedContextMenuMark;
    private static final int UNARMED = 0;
    private static final int ARMING = 1;
    private static final int ARMED = 2;
    private static int _contextMenuDeselectionState;
    private CodeEditor _codeEditor;
    private final GutterView _gutterView;
    private static final Log LOG;
    private static final int TW = 2;
    protected static Polygon _triangle;

    public static ContextMenu getGutterContextMenu() {
        if (_contextMenu == null) {
            _contextMenu = new ContextMenu(new MnemonicSolver());
            _contextMenu.addContextMenuListener(new ContextMenuListener(){

                public void menuWillShow(ContextMenu contextMenu) {
                }

                public void menuWillHide(ContextMenu contextMenu) {
                    LOG.trace("hiding at {0}, state {1}", System.currentTimeMillis(), (Object)_contextMenuDeselectionState);
                    _contextMenuDeselectionState = 1;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LOG.trace("initial event sequence guard at {0}, state {1}", System.currentTimeMillis(), (Object)_contextMenuDeselectionState);
                            switch (_contextMenuDeselectionState) {
                                case 2: {
                                    break;
                                }
                                default: {
                                    _contextMenuDeselectionState = 0;
                                }
                            }
                        }
                    });
                }

                public boolean handleDefaultAction(Context context) {
                    return false;
                }
            });
        }
        return _contextMenu;
    }

    public void mousePressed(MouseEvent event) {
        LOG.trace("mouse pressed at {0}, state {1}", event.getWhen(), (Object)_contextMenuDeselectionState);
        switch (_contextMenuDeselectionState) {
            case 1: {
                _contextMenuDeselectionState = 2;
                break;
            }
            default: {
                _contextMenuDeselectionState = 0;
            }
        }
        super.mousePressed(event);
    }

    public void mouseReleased(MouseEvent event) {
        LOG.trace("mouse released at {0}, state {1}", event.getWhen(), (Object)_contextMenuDeselectionState);
        super.mouseReleased(event);
    }

    public void mouseClicked(MouseEvent event) {
        LOG.trace("mouse clicked at {0}, state {1}", event.getWhen(), (Object)_contextMenuDeselectionState);
        _contextMenuDeselectionState = 0;
        super.mouseClicked(event);
    }

    public static CodeEditorGutter getGutterFor(GutterColumn column) {
        Gutter gutter = column.getGutter();
        return (CodeEditorGutter)gutter;
    }

    public static CodeEditorGutter getGutterFor(GutterMark mark) {
        Gutter gutter = mark.getGutter();
        return (CodeEditorGutter)gutter;
    }

    public static GutterMark getMarkForContext(Context context) {
        if (context == null) {
            return null;
        }
        return (GutterMark)context.getProperty(GUTTER_MARK);
    }

    public static boolean isMarkDroppingDown(Context context) {
        if (context == null) {
            return false;
        }
        return Boolean.TRUE.equals(context.getProperty(DROPPING_DOWN));
    }

    public static int getLineForContext(Context context) {
        if (context == null) {
            return -1;
        }
        Integer line = (Integer)context.getProperty(LINE_NUMBER);
        if (line == null) {
            return -1;
        }
        return line;
    }

    CodeEditorGutter(CodeEditor codeEditor) {
        this._codeEditor = codeEditor;
        this._gutterView = new GutterView();
    }

    public Context getContext() {
        return this._gutterView.getContext();
    }

    public CodeEditor getCodeEditor() {
        return this._codeEditor;
    }

    public View getCodeEditorGutterView() {
        return this._gutterView;
    }

    protected LineGutterPlugin.Column createGutterColumnImpl(String columnName, GutterColumnListener listener) {
        return new CEColumn(columnName, listener);
    }

    public void mouseDragged(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            return;
        }
        super.mouseDragged(event);
    }

    protected void processMousePressed(MouseEvent event, int line, GutterMark mark) {
        if (SwingUtilities.isRightMouseButton(event)) {
            this.showGutterContextMenu(event, line, mark);
        } else {
            super.processMousePressed(event, line, mark);
        }
    }

    protected void showGutterContextMenu(MouseEvent event, int line, GutterMark mark) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            _lastDroppedContextMenuMark = null;
            _contextMenuDeselectionState = 0;
            contextMenu.show(this.getContext(event, line, mark, false));
        }
    }

    public void showMarkDropdownMenu(MouseEvent event, GutterMark mark, int line) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            long when = event.getWhen();
            LOG.trace("showing mark {0}, last mark {1}, when {2}, state {3}", (Object)mark, (Object)_lastDroppedContextMenuMark, (Object)when, (Object)_contextMenuDeselectionState);
            if (_contextMenuDeselectionState == 2 && mark == _lastDroppedContextMenuMark) {
                return;
            }
            Rectangle markRect = this.getRolloverRectFor(mark);
            MouseEvent eventToUse = event;
            if (markRect != null) {
                int adjustedX = markRect.x;
                int adjustedY = markRect.y + markRect.height + 1;
                eventToUse = new MouseEvent((Component)event.getSource(), event.getID(), when, event.getModifiers(), adjustedX, adjustedY, event.getClickCount(), event.isPopupTrigger(), event.getButton());
            }
            Rectangle visibleRect = this.getVisibleRect();
            if (eventToUse.getY() > visibleRect.y && eventToUse.getY() < visibleRect.y + visibleRect.height) {
                _lastDroppedContextMenuMark = mark;
                _contextMenuDeselectionState = 0;
                contextMenu.show(this.getContext(eventToUse, line, mark, true));
            }
        }
    }

    private Context getContext(EventObject event, int line, GutterMark mark, boolean droppingDown) {
        Context context = this._gutterView.getContext(event);
        int count = this._codeEditor.getLineCount();
        boolean validLine = line > 0 && line <= count;
        Integer lineInt = validLine ? new Integer(line) : null;
        context.setProperty(LINE_NUMBER, (Object)lineInt);
        context.setProperty(GUTTER_MARK, (Object)mark);
        context.setProperty(DROPPING_DOWN, (Object)droppingDown);
        return context;
    }

    protected Rectangle paintRollover(Graphics graphics, GutterMark mark, int iconX, int columnWidth, int rowY) {
        Rectangle bounds = super.paintRollover(graphics, mark, iconX, columnWidth, rowY);
        CEColumn column = (CEColumn)mark.getGutterColumn();
        if (bounds != null && column.isOptionSet(mark, 65536)) {
            int triangleX = bounds.x + bounds.width - 4 - 2;
            int triangleY = bounds.y + 2;
            Color oldColor = graphics.getColor();
            graphics.translate(triangleX, triangleY);
            graphics.setColor(this.getForeground());
            graphics.fillPolygon(_triangle);
            graphics.drawPolygon(_triangle);
            graphics.translate(-triangleX, -triangleY);
            graphics.setColor(oldColor);
        }
        return bounds;
    }

    public String toString() {
        return "gutter " + this._codeEditor.getContext().getNode().getShortLabel();
    }

    private ContextMenu getContextMenu() {
        return this._gutterView.getContextMenu();
    }

    static {
        _lastDroppedContextMenuMark = null;
        _contextMenuDeselectionState = 0;
        LOG = new Log("gutter");
        _triangle = new Polygon(new int[]{0, 2, 4}, new int[]{0, 2, 0}, 3);
    }

    public final class GutterView
    extends View {
        private GutterView() {
            this.setOwner((View)CodeEditorGutter.this._codeEditor);
        }

        public Controller getController() {
            return CodeEditorGutter.this._codeEditor.getController();
        }

        public boolean isVisible() {
            return CodeEditorGutter.this._codeEditor.isVisible();
        }

        public Component getGUI() {
            return CodeEditorGutter.this;
        }

        public Context getContext(EventObject event) {
            Context editorContext = CodeEditorGutter.this._codeEditor.getContext();
            Context ourContext = new Context(editorContext);
            Node element = ourContext.getNode();
            ourContext.setSelection(new Element[]{element});
            ourContext.setElement((Element)element);
            ourContext.setView((View)CodeEditorGutter.this._gutterView);
            ourContext.setEvent(event);
            return ourContext;
        }

        public ContextMenu getContextMenu() {
            return CodeEditorGutter.getGutterContextMenu();
        }

        protected String newId() {
            return CodeEditorGutter.this._codeEditor.getId();
        }

        public HelpInfo getHelpInfo() {
            return CodeEditorGutter.this._codeEditor.getHelpInfo();
        }
    }

    protected class CEColumn
    extends LineGutterPlugin.Column {
        protected CEColumn(String columnName, GutterColumnListener columnListener) {
            super((LineGutterPlugin)CodeEditorGutter.this, columnName, columnListener);
        }

        protected boolean isOptionSet(GutterMark gutterMark, int optionFlag) {
            LineGutterPlugin.Column.Mark mark = (LineGutterPlugin.Column.Mark)gutterMark;
            return mark.isOptionSet(optionFlag);
        }

        protected void fireMarkClicked(MouseEvent event, GutterMark gutterMark, int line) {
            if (this.isOptionSet(gutterMark, 65536)) {
                CodeEditorGutter.this.showMarkDropdownMenu(event, gutterMark, line);
            } else {
                super.fireMarkClicked(event, gutterMark, line);
            }
        }
    }
}

