/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.ceditor.options.CaretOptions;
import oracle.ide.ceditor.options.CaretOptionsPanel;
import oracle.ide.ceditor.options.CompletionOptionsPanel;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.DisplayOptionsPanel;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.ceditor.options.EditorOptionsPanel;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.ceditor.options.FontSizeOptionsPanel;
import oracle.ide.ceditor.options.GutterOptionsPanel;
import oracle.ide.ceditor.options.InsightOptions;
import oracle.ide.ceditor.options.InsightOptionsPanel;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.PrintingHTMLOptions;
import oracle.ide.ceditor.options.PrintingHTMLOptionsPanel;
import oracle.ide.ceditor.options.PrintingOptions;
import oracle.ide.ceditor.options.PrintingOptionsPanel;
import oracle.ide.ceditor.options.SyntaxColorsOptions;
import oracle.ide.ceditor.options.SyntaxColorsOptionsPanel;
import oracle.ide.ceditor.options.UndoOptions;
import oracle.ide.ceditor.options.UndoOptionsPanel;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.IdeProperties;
import oracle.ide.model.TextNode;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.panels.Navigable;
import oracle.ide.util.MenuSpec;
import oracle.ideimpl.panels.SearchableNavigable;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.util.Copyable;

public class CodeEditorAddin
extends EditorAddin {
    private static final String CODE_EDITOR_ADDIN_PREFIX = "CodeEditor";
    private SearchableNavigable editorNavigable;
    private MenuSpec menuSpec;

    static String getExtensionID() {
        return AddinManager.getAddinManager().getExtensionIDForAddin(CodeEditorAddin.class);
    }

    public Navigable getEditorNavigable() {
        if (this.editorNavigable == null) {
            this.registerNavigables();
        }
        return this.editorNavigable;
    }

    private void registerKeystrokes() {
        EditorFactory.initialize();
    }

    private void registerNavigables() {
        if (this.editorNavigable == null) {
            Preferences prefs = Preferences.getPreferences();
            IdeSettings ideSettings = Ide.getSettings();
            ideSettings.putLegacyData("EditorOptions", (Copyable)EditorOptions.getInstance((PropertyStorage)prefs));
            ideSettings.putLegacyData("CaretOptions", (Copyable)CaretOptions.getInstance((PropertyStorage)prefs));
            ideSettings.putLegacyData("DisplayOptions", (Copyable)DisplayOptions.getInstance((PropertyStorage)prefs));
            ideSettings.putLegacyData("FontSizeOptions", (Copyable)FontSizeOptions.getInstance((PropertyStorage)prefs));
            ideSettings.putLegacyData("SyntaxColorsOptions", (Copyable)SyntaxColorsOptions.getInstance((PropertyStorage)prefs));
            ideSettings.putLegacyData("PrintingOptions", (Copyable)PrintingOptions.getInstance((PropertyStorage)prefs));
            ideSettings.putLegacyData("PrintingHTMLOptions", (Copyable)PrintingHTMLOptions.getInstance((PropertyStorage)prefs));
            ideSettings.putLegacyData("InsightOptions", (Copyable)InsightOptions.getInstance((PropertyStorage)prefs));
            ideSettings.putLegacyData("UndoOptions", (Copyable)UndoOptions.getInstance((PropertyStorage)prefs));
            String editorName = OptionsArb.getString(0);
            this.editorNavigable = new SearchableNavigable(editorName, EditorOptionsPanel.class);
            this.editorNavigable.setSearchTags(OptionsArb.getString(1));
            IdeSettings.registerUI((Navigable)this.editorNavigable);
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)prefs);
            EditorOptionsPanel.applyOptions(editorOptions);
            String caretName = OptionsArb.getString(137);
            SearchableNavigable caretNavigable = new SearchableNavigable(caretName, CaretOptionsPanel.class);
            caretNavigable.setSearchTags(OptionsArb.getString(138));
            this.editorNavigable.addChildNavigable((Navigable)caretNavigable);
            CaretOptions caretOptions = CaretOptions.getInstance((PropertyStorage)prefs);
            CaretOptionsPanel.applyOptions(caretOptions);
            String displayName = OptionsArb.getString(16);
            SearchableNavigable displayNavigable = new SearchableNavigable(displayName, DisplayOptionsPanel.class);
            displayNavigable.setSearchTags(OptionsArb.getString(17));
            this.editorNavigable.addChildNavigable((Navigable)displayNavigable);
            DisplayOptions displayOptions = DisplayOptions.getInstance((PropertyStorage)prefs);
            DisplayOptionsPanel.applyOptions(displayOptions);
            String gutterName = OptionsArb.getString(34);
            SearchableNavigable gutterNavigable = new SearchableNavigable(gutterName, GutterOptionsPanel.class);
            gutterNavigable.setSearchTags(OptionsArb.getString(35));
            this.editorNavigable.addChildNavigable((Navigable)gutterNavigable);
            GutterOptionsPanel.applyOptions(displayOptions);
            String fontSizeName = OptionsArb.getString(60);
            SearchableNavigable fontSizeNavigable = new SearchableNavigable(fontSizeName, FontSizeOptionsPanel.class);
            fontSizeNavigable.setSearchTags(OptionsArb.getString(61));
            this.editorNavigable.addChildNavigable((Navigable)fontSizeNavigable);
            FontSizeOptions fontSizeOptions = FontSizeOptions.getInstance((PropertyStorage)prefs);
            FontSizeOptionsPanel.applyOptions(fontSizeOptions);
            SearchableNavigable syntaxHighlightNavigable = new SearchableNavigable(OptionsArb.getString(93), SyntaxColorsOptionsPanel.class);
            syntaxHighlightNavigable.setSearchTags(OptionsArb.getString(136));
            this.editorNavigable.addChildNavigable((Navigable)syntaxHighlightNavigable);
            SyntaxColorsOptions syntaxHighlightOptions = SyntaxColorsOptions.getInstance((PropertyStorage)prefs);
            SyntaxColorsOptionsPanel.applyOptions(syntaxHighlightOptions);
            String insightName = OptionsArb.getString(44);
            SearchableNavigable insightNavigable = new SearchableNavigable(insightName, InsightOptionsPanel.class);
            insightNavigable.setSearchTags(OptionsArb.getString(45));
            this.editorNavigable.addChildNavigable((Navigable)insightNavigable);
            InsightOptions insightOptions = InsightOptions.getInstance((PropertyStorage)prefs);
            InsightOptionsPanel.applyOptions(insightOptions);
            String completionName = OptionsArb.getString(52);
            SearchableNavigable completionNavigable = new SearchableNavigable(completionName, CompletionOptionsPanel.class);
            completionNavigable.setSearchTags(OptionsArb.getString(53));
            insightNavigable.addChildNavigable((Navigable)completionNavigable);
            CompletionOptionsPanel.applyOptions(insightOptions);
            String printingName = OptionsArb.getString(167);
            SearchableNavigable printingNavigable = new SearchableNavigable(printingName, PrintingOptionsPanel.class);
            printingNavigable.setSearchTags(OptionsArb.getString(168));
            this.editorNavigable.addChildNavigable((Navigable)printingNavigable);
            PrintingOptions printingOptions = PrintingOptions.getInstance((PropertyStorage)prefs);
            PrintingOptionsPanel.applyOptions(printingOptions);
            String printingHTMLName = OptionsArb.getString(179);
            SearchableNavigable printingHTMLNavigable = new SearchableNavigable(printingHTMLName, PrintingHTMLOptionsPanel.class);
            printingHTMLNavigable.setSearchTags(OptionsArb.getString(180));
            this.editorNavigable.addChildNavigable((Navigable)printingHTMLNavigable);
            PrintingHTMLOptions printingHTMLOptions = PrintingHTMLOptions.getInstance((PropertyStorage)prefs);
            PrintingHTMLOptionsPanel.applyOptions(printingHTMLOptions);
            String undoName = OptionsArb.getString(72);
            SearchableNavigable undoNavigable = new SearchableNavigable(undoName, UndoOptionsPanel.class);
            undoNavigable.setSearchTags(OptionsArb.getString(73));
            this.editorNavigable.addChildNavigable((Navigable)undoNavigable);
            UndoOptions undoOptions = UndoOptions.getInstance((PropertyStorage)prefs);
            UndoOptionsPanel.applyOptions(undoOptions);
        }
    }

    public void initialize() {
        EditorManager editorMgr = EditorManager.getEditorManager();
        Class[] types = new Class[]{TextNode.class};
        editorMgr.register((EditorAddin)this, types);
        CodeEditorController.getDefaultController();
        NavigationManager navMgr = NavigationManager.getNavigationManager();
        if (navMgr != null) {
            navMgr.registerEditorNavigationPoint(CodeNavigationPoint.class, CodeEditor.class);
        }
        this.registerNavigables();
        this.registerKeystrokes();
        AddinManager.getAddinManager().initAddinLoadset(CODE_EDITOR_ADDIN_PREFIX);
        IdeProperties properties = Ide.getIdeProperties();
        EditorProperties editorProperties = EditorProperties.getProperties();
        String keyRelease = properties.getProperty("ceditor.ConsumeKeyRelease", "true");
        try {
            boolean shouldEatKR = keyRelease.equals("true");
            editorProperties.putBooleanProperty("consume-key-release", shouldEatKR);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        String checkFragListAlloc = properties.getProperty("ceditor.CheckFragListAllocation", "false");
        boolean check = Boolean.valueOf(checkFragListAlloc);
        editorProperties.putBooleanProperty("check-fraglist-recycling", check);
        editorProperties.putBooleanProperty("toggle-comments-advance", true);
        String checkSameWidthFaces = System.getProperty("ceditor.CheckSameWidthFaces", "true");
        boolean checkFaces = Boolean.valueOf(checkSameWidthFaces);
        editorProperties.putBooleanProperty("check-same-width-faces", checkFaces);
        BraceMatchingPlugin.class.getName();
        FindHighlightPlugin.class.getName();
        LineHighlightPlugin.class.getName();
        ExitCommand.addShutdownHook((ShutdownHook)new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                BraceMatchingPlugin.shutdown();
            }
        });
    }

    public boolean isDefault() {
        return true;
    }

    public Class getEditorClass() {
        return CodeEditor.class;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this.menuSpec == null) {
            String name = CEditorArb.getString(0);
            Integer mnemonic = CEditorArb.getInteger(1);
            this.menuSpec = new MenuSpec(name, mnemonic, CEditorArb.getInstance(), 2);
        }
        return this.menuSpec;
    }
}

