/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.xml;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElement;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.DuplexIterator;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.ArrayIterator;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlModelAdapter
extends TextFileModelAdapter {
    private XmlContext xmlContext;
    private int activeCount;
    private final int[] offsets = new int[2];
    private static final Log LOG = new Log("xmladapter");

    XmlModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter packag, XMLSourceNode node, URL url) {
        super(factory, type, workspace, project, packag, (Node)node, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acquireReadLock(WriteLockRequestListener listener) {
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext(this.getIdeContext());
        xmlContext.getModel().acquireReadLock();
        boolean waiting = listener != null && this.getLock().addWriteLockRequestListener(listener);
        XmlModelAdapter xmlModelAdapter = this;
        synchronized (xmlModelAdapter) {
            if (this.activeCount++ == 0) {
                this.xmlContext = xmlContext;
            }
        }
        return waiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseReadLock(WriteLockRequestListener listener) {
        XmlModel xmlModel = this.xmlContext.getModel();
        XmlModelAdapter xmlModelAdapter = this;
        synchronized (xmlModelAdapter) {
            if (--this.activeCount == 0) {
                this.xmlContext = null;
            }
        }
        if (listener != null) {
            this.getLock().removeWriteLockRequestListener(listener);
        }
        xmlModel.releaseReadLock();
    }

    public Object getRootImplementation() {
        this.verifyReadTransaction();
        assert (this.xmlContext != null) : "no read transaction active on " + (Object)((Object)this);
        return this.getXmlModel().getDocument();
    }

    public synchronized XmlModel getXmlModel() {
        this.verifyReadTransaction();
        assert (this.xmlContext != null) : "no read transaction active on " + (Object)((Object)this);
        return this.xmlContext.getModel();
    }

    public Location[] getElementLocations(oracle.ide.model.Element element) {
        LOG.trace("getting element location for {0}", (Object)element);
        this.verifyReadTransaction();
        assert (this.xmlContext != null) : "no read transaction active on " + (Object)((Object)this);
        if (element instanceof XMLSourceNode) {
            XMLSourceNode node = (XMLSourceNode)element;
            if (node.getURL().equals(this.getUrl())) {
                return new Location[]{this.getLocation()};
            }
        } else if (element instanceof XmlSelectionElement) {
            Location[] locations;
            org.w3c.dom.Node[] nodes = this.getXmlModel().getSelection().getSelectedNodesArray();
            if (nodes.length > 0) {
                locations = new Location[nodes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    locations[i] = this.getLocation(nodes[i]);
                }
            } else {
                locations = new Location[]{this.getLocation()};
            }
            return locations;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation(Object construct) {
        LOG.trace("getting location of {0}", construct);
        this.verifyReadTransaction();
        assert (this.xmlContext != null) : "no read transaction active on " + (Object)((Object)this);
        if (construct instanceof org.w3c.dom.Node) {
            org.w3c.dom.Node node = (org.w3c.dom.Node)construct;
            DomModel model = this.getXmlModel().getDomModel();
            Document root = model.getDocument();
            if (root == node || root == node.getOwnerDocument()) {
                int[] nArray = this.offsets;
                synchronized (this.offsets) {
                    model.getTextOffsets(node, this.offsets);
                    int start = this.offsets[0];
                    int end = this.offsets[1];
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return this.getLocation(start, end - start);
                }
            }
        }
        return null;
    }

    public Iterator getContainedConstructs(Object construct) {
        LOG.trace("getting contained constructs of {0}", construct);
        this.verifyReadTransaction();
        assert (this.xmlContext != null) : "no read transaction active on " + (Object)((Object)this);
        org.w3c.dom.Node node = (org.w3c.dom.Node)construct;
        NamedNodeMap attributes = node.getAttributes();
        int attributeCount = attributes != null ? attributes.getLength() : 0;
        switch (attributeCount) {
            case 0: {
                return new ChildIterator(node);
            }
            case 1: {
                Attr attribute = (Attr)attributes.item(0);
                if (!this.getXmlModel().getDomModel().isUnspecifiedAttribute(attribute)) {
                    return new DuplexIterator((Iterator)new ArrayIterator((Object[])new org.w3c.dom.Node[]{attribute}), (Iterator)new ChildIterator(node));
                }
                LOG.trace("discarding attribute {0}", (Object)attribute);
                return new ChildIterator(node);
            }
        }
        Object[] sortables = new Sortable[attributeCount];
        int count = 0;
        DomModel model = this.getXmlModel().getDomModel();
        int[] offsets = new int[2];
        for (int i = 0; i < attributeCount; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            model.getTextOffsets((org.w3c.dom.Node)attribute, offsets);
            int offset = offsets[0];
            if (offset >= 0) {
                sortables[count++] = new Sortable(attribute, offset);
                continue;
            }
            LOG.trace("discarding attribute {0}", (Object)attribute);
        }
        Arrays.sort(sortables, 0, count);
        Object[] nodes = new org.w3c.dom.Node[count];
        for (int i = 0; i < count; ++i) {
            nodes[i] = ((Sortable)sortables[i]).attribute;
        }
        return new DuplexIterator((Iterator)new ArrayIterator(nodes), (Iterator)new ChildIterator(node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object construct, Location location) {
        assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + (Object)((Object)this) + " - " + location;
        assert (this == location.getModel());
        this.verifyReadTransaction();
        if (construct instanceof Document) {
            return true;
        }
        assert (construct instanceof org.w3c.dom.Node);
        DomModel model = this.getXmlModel().getDomModel();
        int[] nArray = this.offsets;
        synchronized (this.offsets) {
            model.getTextOffsets((org.w3c.dom.Node)construct, this.offsets);
            int start = this.offsets[0];
            int end = this.offsets[1];
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return start <= location.getOffset() && end >= location.getEndOffset();
        }
    }

    public Location getFocusLocation(Object construct, Location location) {
        LOG.trace("getting focus location of {0}", construct);
        assert (location != null);
        assert (location.equals((Object)this.getLocation(construct)));
        this.verifyReadTransaction();
        if (construct instanceof Element) {
            int offset;
            ModelAdapter model = location.getModel();
            TextBuffer buffer = this.getTextBuffer();
            for (offset = location.getOffset() + 1; offset < buffer.getLength() && Character.isWhitespace(buffer.getChar(offset)); ++offset) {
            }
            Element element = (Element)construct;
            String name = element.getTagName();
            int length = name.length();
            return model.getLocation(offset, length);
        }
        return super.getFocusLocation(construct, location);
    }

    public Object label(Object construct) {
        if (construct instanceof Document) {
            return URLFileSystem.getFileName((URL)this.getUrl());
        }
        return this.getXmlModel().getXmlMetadataResolver().getMediumDisplayName((org.w3c.dom.Node)construct);
    }

    public Object summary(Object construct) {
        if (construct instanceof Document) {
            return URLFileSystem.getPlatformPathName((URL)this.getUrl());
        }
        return this.getXmlModel().getXmlMetadataResolver().getLongDisplayName((org.w3c.dom.Node)construct);
    }

    public Icon icon(Object construct) {
        if (construct instanceof Document) {
            return this.getNode().getIcon();
        }
        return this.getXmlModel().getXmlMetadataResolver().getSmallIcon((org.w3c.dom.Node)construct);
    }

    private static class ChildIterator
    implements Iterator<org.w3c.dom.Node> {
        private org.w3c.dom.Node next;

        public ChildIterator(org.w3c.dom.Node node) {
            this.next = node.getFirstChild();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public org.w3c.dom.Node next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            org.w3c.dom.Node result = this.next;
            this.next = this.next.getNextSibling();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Sortable
    implements Comparable {
        Attr attribute;
        int offset;

        public Sortable(Attr attribute, int offset) {
            this.attribute = attribute;
            this.offset = offset;
        }

        public int compareTo(Object object) {
            this.offset = ((Sortable)object).offset;
            return this.offset;
        }
    }
}

