/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.xml;

import java.util.Collections;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.message.XmlModelMessageLog;
import oracle.bali.xml.share.PropertyChange;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.jdeveloper.audit.model.AuditEditorAdapter;
import oracle.jdeveloper.audit.model.AuditEditorListener;

public class XmlEditorAdapter
extends AuditEditorAdapter
implements XmlModelListener {
    private volatile AuditEditorListener listener;
    private XmlContext xmlContext;

    public void attach(CodeEditor editor, AuditEditorListener listener) {
        this.listener = listener;
        Context context = editor.getContext();
        this.xmlContext = JDevXmlContext.getXmlContext(context);
        if (this.xmlContext != null) {
            this.xmlContext.getModel().addModelListener((XmlModelListener)this);
        }
    }

    public void listenerAttached(XmlModelEvent event) {
    }

    public void invalidate(XmlModelEvent event) {
        AuditEditorListener listener = this.listener;
        if (this.isEventRelevant(event) && listener != null) {
            listener.modelStale();
        }
    }

    public void modelChanged(XmlModelEvent event) {
        AuditEditorListener listener = this.listener;
        if (this.isEventRelevant(event) && listener != null) {
            listener.modelCurrent(Collections.EMPTY_MAP);
        }
    }

    public void noChange(XmlModelEvent event) {
    }

    public void listenerDetached(XmlModelEvent event) {
    }

    public void ensureCurrent() {
        this.listener.modelStale();
        this.listener.modelCurrent(Collections.EMPTY_MAP);
    }

    public void detach(CodeEditor editor, AuditEditorListener listener) {
        if (this.xmlContext != null) {
            this.xmlContext.getModel().removeModelListener((XmlModelListener)this);
        }
        this.xmlContext = null;
        this.listener = null;
    }

    private boolean isEventRelevant(XmlModelEvent event) {
        PropertyChange change = event.getIssueListPropertyChange();
        return event.isDomTreeChanged() || change != null && change.getNewValue() instanceof XmlModelMessageLog;
    }
}

