/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.xml;

import oracle.bali.xml.grammar.QualifiedName;
import oracle.jdeveloper.audit.extension.Required;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.xml.XmlTransformAdapter;
import oracle.jdeveloper.audit.xml.XmlTransformContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AddAttributeTransform
extends Transform {
    private QualifiedName name;
    private String value;

    public AddAttributeTransform() {
        super((TransformAdapter)new XmlTransformAdapter());
    }

    public QualifiedName getName() {
        return this.name;
    }

    @Required
    public void setName(QualifiedName name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isApplicable(XmlTransformContext context, Element construct) {
        return !construct.hasAttributeNS(this.name.getNamespace(), this.name.getName());
    }

    public boolean isApplicable(XmlTransformContext context, Attr construct) {
        return this.isApplicable(context, (Element)construct.getParentNode());
    }

    public void apply(XmlTransformContext context, Element construct) {
        construct.setAttributeNS(this.name.getNamespace(), this.name.getName(), this.value != null ? this.value : "");
        Attr attribute = construct.getAttributeNodeNS(this.name.getNamespace(), this.name.getName());
        context.setSelection(attribute, Integer.MAX_VALUE, 1);
    }

    public void apply(XmlTransformContext context, Attr construct) {
        this.apply(context, (Element)construct.getParentNode());
    }
}

