/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent;

import java.awt.Component;
import java.util.Iterator;
import java.util.Set;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.xmlComponent.AbstractXmlPanelWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelWrapper;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.ide.view.View;
import org.w3c.dom.Node;

public class XmlPanelGui
extends XmlGui
implements JDevViewHostedGui,
ComponentXmlGui<Component> {
    private View _view;
    private XmlPanelWrapper _panelWrapper;

    public XmlPanelGui(XmlView view) {
        super(view);
    }

    public Component getComponent() {
        return this._panelWrapper.getPanel();
    }

    public XmlPanelWrapper getPanelWrapper() {
        return this._panelWrapper;
    }

    public XmlPanelGui setPanelWrapper(XmlPanelWrapper panelWrapper) {
        this._panelWrapper = panelWrapper;
        return this;
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        Node changeRoot;
        Set removed;
        super.handleModelChangeEvent(event);
        if (event.getReadOnlyPropertyChange() != null) {
            this.handleReadOnlyPropertyChange();
        }
        if (!this.isShown()) {
            return;
        }
        if (event.isSelectionChanged()) {
            Set selectionsAdded = event.getSelectionsAdded();
            for (Node selectedNode : selectionsAdded) {
                this.handleSelectionChanged(selectedNode);
            }
        }
        if (!event.isDomTreeChanged()) {
            return;
        }
        if (event.isDomDocumentChanged()) {
            this.handleDomDocumentChanged();
            return;
        }
        if (((AbstractXmlPanelWrapper)this.getPanelWrapper()).getUpdating()) {
            return;
        }
        NodeChangeDetails details = event.getNodeChangeDetails();
        if (details != null && details != NodeChangeDetails.NO_DETAILS_AVAILABLE && (removed = details.getRemovedNodes()).size() > 0) {
            Iterator iter = removed.iterator();
            Node deletedNode = null;
            while (iter.hasNext()) {
                deletedNode = (Node)iter.next();
                this.handleDeletedNode(deletedNode);
            }
        }
        if ((changeRoot = event.getChangeRoot()) != null) {
            this.handleChangeRoot(changeRoot);
        }
    }

    protected void handleDeletedNode(Node deletedNode) {
        this.getPanelWrapper().getXmlComponentWrapperMap().updateDeletedNode(deletedNode);
    }

    protected void handleSelectionChanged(Node selectedNode) {
        this.getPanelWrapper().getXmlComponentWrapperMap().requestFocus(selectedNode);
    }

    protected void handleDomDocumentChanged() {
        this.getPanelWrapper().invalidateXmlComponents();
        this.getPanelWrapper().updateXmlComponentsFromModel();
    }

    protected void handleReadOnlyPropertyChange() {
        this.getPanelWrapper().dispose();
        this.getPanelWrapper().createXmlComponents();
        this.getPanelWrapper().updateXmlComponentsFromModel();
    }

    protected void handleChangeRoot(Node changeRoot) {
        this.getPanelWrapper().getXmlComponentWrapperMap().updateNodeOrDescendant(changeRoot);
    }

    @Override
    public void setOwningJDevView(View view) {
        this._view = view;
    }

    @Override
    public View getOwningJDevView() {
        return this._view;
    }
}

