/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorFactoryDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.base.xmlComponent.XmlWrappedComponent;
import oracle.bali.xml.gui.jdev.xmlComponent.AbstractXmlPanelWrapper;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelGui;
import oracle.bali.xml.gui.swing.xmlComponent.XmlCheckBoxEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTextComponentEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlWrappedComponentImpl;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import org.w3c.dom.Node;

public class XmlComponentWrapperImpl
implements XmlComponentWrapper,
PropertyChangeListener {
    private boolean _addFocusTracker = true;
    private String _errorMessage;
    private Component _defaultWrappedComponent;
    private XmlWrappedComponentImpl _xmlWrappedComponent;
    private final SafeListenerManager _childXmlComponentListeners = new SafeListenerManager();
    private XmlComponentWrapper _parentXmlComponentWrapper;
    private XmlComponentModel _xmlComponentModel;
    private XmlComponentPropertyEditor _xmlComponentPropertyEditor;
    private boolean _isEditable;
    private AbstractXmlPanelWrapper _xmlPanelWrapper;
    private Component _childHeaderComponent;

    public static XmlComponentWrapperImpl create(XmlKey xmlKey, XmlPanelGui xmlGui, AbstractXmlPanelWrapper xmlPanelWrapper, XmlKey xmlPanelRootXmlKey) {
        return new XmlComponentWrapperImpl(new JTextField(), xmlKey, xmlGui, xmlPanelWrapper, xmlPanelRootXmlKey);
    }

    protected XmlComponentWrapperImpl(JComponent jComponent, XmlKey xmlKey, XmlPanelGui xmlGui, AbstractXmlPanelWrapper xmlPanelWrapper, XmlKey xmlPanelRootXmlKey) {
        this._defaultWrappedComponent = jComponent;
        this._xmlComponentModel = XmlComponentModel.createXmlComponentModel((XmlKey)xmlKey, (XmlKey)xmlPanelRootXmlKey, (XmlGui)xmlGui);
        this._isEditable = true;
        this._xmlPanelWrapper = xmlPanelWrapper;
        this._xmlWrappedComponent = new XmlWrappedComponentImpl((XmlComponentWrapper)this, this._defaultWrappedComponent);
    }

    public String getXmlComponentValue() {
        return ((PropertyEditor)this.getPropertyEditor()).getAsText();
    }

    public XmlComponentWrapper setXmlComponentValue(String value) {
        ((PropertyEditor)this.getPropertyEditor()).setAsText(value);
        return this;
    }

    public XmlComponentWrapper setParent(XmlComponentWrapper parentXmlComponentWrapper) {
        this._parentXmlComponentWrapper = parentXmlComponentWrapper;
        this._parentXmlComponentWrapper.addChildXmlComponentListener((XmlComponentWrapper)this);
        return this;
    }

    public XmlKey getNavigationXmlKey() {
        return this.getXmlComponentModel().getNavigationXmlKey();
    }

    public XmlComponentWrapper setNavigationXmlKey(XmlKey xmlKey) {
        this.getXmlComponentModel().setNavigationXmlKey(xmlKey);
        return this;
    }

    public XmlComponentPropertyEditor getPropertyEditor() {
        if (this._xmlComponentPropertyEditor != null) {
            return this._xmlComponentPropertyEditor;
        }
        String currValue = this._xmlComponentModel.getModelValue();
        if (currValue != null && (currValue.indexOf("${") > -1 || currValue.indexOf("#{") > -1)) {
            this._xmlComponentPropertyEditor = new XmlTextComponentEditor();
            this._xmlComponentPropertyEditor.setXmlComponentWrapper((XmlComponentWrapper)this);
            ((PropertyEditor)this._xmlComponentPropertyEditor).addPropertyChangeListener(this);
            return this._xmlComponentPropertyEditor;
        }
        PropertyEditor metadataPropertyEditor = this.getXmlComponentModel().getPropertyEditor();
        if (metadataPropertyEditor == null) {
            this._xmlComponentPropertyEditor = new XmlTextComponentEditor();
            this._xmlComponentPropertyEditor.setXmlComponentWrapper((XmlComponentWrapper)this);
            ((PropertyEditor)this._xmlComponentPropertyEditor).addPropertyChangeListener(this);
        } else if (metadataPropertyEditor instanceof XmlComponentPropertyEditor) {
            this._xmlComponentPropertyEditor = (XmlComponentPropertyEditor)metadataPropertyEditor;
            this._xmlComponentPropertyEditor.setXmlComponentWrapper((XmlComponentWrapper)this);
            ((PropertyEditor)this._xmlComponentPropertyEditor).addPropertyChangeListener(this);
        } else if (metadataPropertyEditor instanceof PropertyEditorFactory2) {
            metadataPropertyEditor.addPropertyChangeListener(this);
            this._xmlComponentPropertyEditor = new AbstractXmlPropertyEditorFactoryDecorator((PropertyEditorFactory2)metadataPropertyEditor){};
            this._xmlComponentPropertyEditor.setXmlComponentWrapper((XmlComponentWrapper)this);
            if (this._xmlComponentPropertyEditor.getXmlComponent() == null) {
                ((PropertyEditor)this._xmlComponentPropertyEditor).removePropertyChangeListener(this);
                this._xmlComponentPropertyEditor = new XmlTextComponentEditor();
                this._xmlComponentPropertyEditor.setXmlComponentWrapper((XmlComponentWrapper)this);
                ((PropertyEditor)this._xmlComponentPropertyEditor).addPropertyChangeListener(this);
            }
        } else if (metadataPropertyEditor instanceof PropertyEditor) {
            metadataPropertyEditor.addPropertyChangeListener(this);
            JavaBeansPropertyEditorAdapter pef2 = new JavaBeansPropertyEditorAdapter(metadataPropertyEditor);
            this._xmlComponentPropertyEditor = new AbstractXmlPropertyEditorFactoryDecorator((PropertyEditorFactory2)pef2){};
            this._xmlComponentPropertyEditor.setXmlComponentWrapper((XmlComponentWrapper)this);
        } else {
            this._xmlComponentPropertyEditor = new XmlTextComponentEditor();
            this._xmlComponentPropertyEditor.setXmlComponentWrapper((XmlComponentWrapper)this);
            ((PropertyEditor)this._xmlComponentPropertyEditor).addPropertyChangeListener(this);
        }
        return this._xmlComponentPropertyEditor;
    }

    public XmlComponentWrapper setPropertyEditor(XmlComponentPropertyEditor propertyEditor) {
        this._xmlComponentPropertyEditor = propertyEditor;
        return this;
    }

    public XmlWrappedComponent getXmlWrappedComponent() {
        return this._xmlWrappedComponent;
    }

    public void dispose() {
        if (this._xmlWrappedComponent != null) {
            this._xmlWrappedComponent.dispose();
            this._xmlWrappedComponent = null;
        }
        if (this._xmlComponentPropertyEditor != null) {
            this._xmlComponentPropertyEditor.dispose();
            this._xmlComponentPropertyEditor = null;
        }
    }

    public boolean addFocusTracker() {
        return this._addFocusTracker;
    }

    public XmlComponentWrapper setAddFocusTracker(boolean addFocusTracker) {
        this._addFocusTracker = addFocusTracker;
        return this;
    }

    public XmlComponentModel getXmlComponentModel() {
        return this._xmlComponentModel;
    }

    public XmlComponentWrapper setXmlComponentModel(XmlComponentModel xmlComponentModel) {
        this._xmlComponentModel = xmlComponentModel;
        return this;
    }

    public void invalidateXmlComponent() {
        this.getXmlComponentModel().invalidateNode();
        this.getXmlComponentModel().setStartNode(null);
    }

    public void updateXmlComponentFromModel() {
        this._xmlComponentModel.invalidateNode();
        String currentValue = this._xmlComponentModel.getModelValue();
        if (currentValue != null) {
            this.setXmlComponentValue(currentValue);
        } else {
            this.setXmlComponentValue("");
        }
        this.enableXmlComponent();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getPropertyEditor() instanceof XmlComponentPropertyEditor) {
            this.getPropertyEditor().getXmlComponent();
        }
    }

    public void updateModelFromXmlComponent() {
        if (!this._xmlPanelWrapper.getDeferCommit()) {
            this._xmlPanelWrapper.beginUpdate();
            this.updateModel();
            this._xmlPanelWrapper.endUpdate();
        }
    }

    private void updateModel() {
        XmlComponentPropertyEditor xmlPropertyEditor = this._xmlComponentPropertyEditor;
        if (!xmlPropertyEditor.updatePropertyValue()) {
            return;
        }
        try {
            xmlPropertyEditor.updatePropertyValueFromXmlComponent();
        }
        catch (Exception ex) {
            this._xmlWrappedComponent.showExceptionErrorMessage(ex);
            return;
        }
        String xmlComponentValue = this.getXmlComponentValue();
        String modelValue = this.getXmlComponentModel().getModelValue();
        if (xmlComponentValue != null && xmlComponentValue.equals(modelValue)) {
            return;
        }
        if (xmlComponentValue.length() == 0 && this.getXmlComponentModel().isRequired().booleanValue()) {
            this._xmlWrappedComponent.highlightRequiredValue();
            return;
        }
        if (!this.isXmlComponentValueValid(xmlComponentValue)) {
            return;
        }
        if (modelValue == null && (xmlComponentValue == null || xmlComponentValue.length() == 0 || this.getPropertyEditor() instanceof XmlCheckBoxEditor && xmlComponentValue.compareTo("false") == 0)) {
            return;
        }
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        this.getXmlComponentModel().updateModelValue(xmlComponentValue);
        Boolean result = (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                XmlComponentWrapperImpl.this.highlightErrorOrWarning();
                return true;
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
        waitCursor.hide();
    }

    public boolean isXmlComponentValueValid(final String xmlComponentValue) {
        this._errorMessage = null;
        boolean validXmlComponentValue = (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                Node node = XmlComponentWrapperImpl.this.getXmlComponentModel().getNode();
                if (node == null) {
                    node = XmlComponentWrapperImpl.this.getXmlComponentModel().getPrecreatedNode();
                }
                if (xmlComponentValue != null && xmlComponentValue.length() > 0 && xmlComponentValue.indexOf("${") == -1 && xmlComponentValue.indexOf("#{") == -1) {
                    try {
                        XmlComponentWrapperImpl.this.getXmlComponentModel().getXmlMetadataResolver().validateValue(XmlComponentWrapperImpl.this.getXmlComponentModel().getXmlKey(), node, (Object)xmlComponentValue);
                    }
                    catch (Exception ex) {
                        XmlComponentWrapperImpl.this._errorMessage = ex.getLocalizedMessage();
                        return false;
                    }
                }
                return true;
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
        this._xmlWrappedComponent.highlightInvalidXmlComponentValue(validXmlComponentValue, this._errorMessage, xmlComponentValue);
        return validXmlComponentValue;
    }

    public void highlightErrorOrWarning() {
        XmlComponentModel xmlComponentModel = this.getXmlComponentModel();
        xmlComponentModel.checkForErrorsAndWarnings();
        this._xmlWrappedComponent.highlightErrorOrWarning();
    }

    public void addChildXmlComponentListener(XmlComponentWrapper relatedComponent) {
        this._childXmlComponentListeners.addListener((Object)relatedComponent);
    }

    public void removeChildXmlComponentListener(XmlComponentWrapper relatedComponent) {
        this._childXmlComponentListeners.removeListener((Object)relatedComponent);
    }

    public void updateChildXmlComponents() {
        for (XmlComponentWrapper childXmlComponent : this._childXmlComponentListeners) {
            childXmlComponent.updateXmlComponentFromModel();
            childXmlComponent.highlightErrorOrWarning();
            childXmlComponent.updateChildXmlComponents();
        }
    }

    public XmlComponentWrapper getParent() {
        return this._parentXmlComponentWrapper;
    }

    public boolean isEditable() {
        return this._isEditable;
    }

    public XmlComponentWrapper setIsEditable(boolean isEditable) {
        this._isEditable = isEditable;
        return this;
    }

    public Component getChildHeaderComponent() {
        return this._childHeaderComponent;
    }

    public XmlComponentWrapper setChildHeaderComponent(Component childHeaderComponent) {
        this._childHeaderComponent = childHeaderComponent;
        return this;
    }

    private void enableXmlComponent() {
        boolean enabled;
        if (!this.isEditable() || this.getXmlComponentModel().isViewReadOnly()) {
            enabled = false;
        } else {
            boolean bl = enabled = !this.getXmlComponentModel().isReadOnly();
        }
        if (enabled && this.getParent() != null && this.getParent().getXmlComponentModel().getSelectedIndex() == -1) {
            enabled = false;
        }
        if (this.getPropertyEditor() instanceof XmlComponentPropertyEditor) {
            this.getPropertyEditor().setEnabled(enabled);
        }
    }
}

