/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.shaping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ExtensionHook;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bali.xml.gui.jdev.shaping.XmlShapingAliasMap;
import oracle.bali.xml.metadata.AggregateMetadataProvider;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFromDOM;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataProvider;
import oracle.javatools.util.MultiMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class XmlShapingHook
extends ExtensionHook {
    private final ElementVisitorFactory _genericVisitorFactory = new ElementVisitorFactory(){

        public ElementVisitor getVisitor(ElementName name) {
            return XmlShapingHook.this._genericVisitor;
        }
    };
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/shaping/xml", "xml-language-shaping");
    private static final String _KEY_PARENT_ELEMENT = "parentElement";
    private static final String _XML_SHAPING_NAMESPACE = "http://xmlns.oracle.com/ide/shaping/xml";
    private static final String _METADATA_NAMESPACE = "http://xmlns.oracle.com/bali/xml/metadata";
    private static final Logger _LOGGER = Logger.getLogger(XmlShapingHook.class.getName());
    private final ElementVisitor _genericVisitor = new GenericVisitor();
    private DocumentBuilder _documentBuilder;
    private Document _document;
    private Element _rootElement;
    private String _fileType;
    private String _targetNamespace;
    private final MultiMap<String, Document> _fileTypeMap = new MultiMap();
    private final Map<String, MetadataProvider> _shapingMetadataProviderMap = new HashMap<String, MetadataProvider>();
    private final XmlShapingAliasMap _shapingAliasMap = new XmlShapingAliasMap();

    public XmlShapingHook() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            this._documentBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Parser configuration error", e);
        }
    }

    public void start(ElementStartContext context) {
        if (this._documentBuilder == null) {
            return;
        }
        this._document = this._documentBuilder.newDocument();
        this._rootElement = null;
        this._fileType = null;
        this._targetNamespace = null;
        this._fileType = context.getAttributeValue("fileType");
        context.registerVisitorFactory(this._genericVisitorFactory);
        context.getScopeData().put(_KEY_PARENT_ELEMENT, this._document.getDocumentElement());
    }

    public void end(ElementEndContext context) {
        if (this._document != null) {
            this._fileTypeMap.add((Object)this._fileType, (Object)this._document.getDocumentElement().getOwnerDocument());
        }
    }

    public MetadataProvider createXmlShapingMetadataProvider(Collection<String> shapingIdList, MetadataProvider baseMetadataProvider) {
        if (shapingIdList == null) {
            throw new IllegalArgumentException("shapingIdList must not be null");
        }
        if (baseMetadataProvider == null) {
            throw new IllegalArgumentException("baseMetadataProvider must not be null");
        }
        ArrayList<MetadataProvider> shapingMetadataProviderList = new ArrayList<MetadataProvider>();
        for (String fileType : shapingIdList) {
            MetadataProvider shapingMetadataProvider = this._shapingMetadataProviderMap.get(fileType);
            if (shapingMetadataProvider == null) {
                shapingMetadataProvider = this._createShapingMetadataProvider(fileType);
            }
            if (shapingMetadataProvider == null) continue;
            shapingMetadataProviderList.add(shapingMetadataProvider);
        }
        if (shapingMetadataProviderList.isEmpty()) {
            return baseMetadataProvider;
        }
        shapingMetadataProviderList.add(baseMetadataProvider);
        return AggregateMetadataProvider.create(shapingMetadataProviderList);
    }

    private StandaloneMetadataProvider _createShapingMetadataProvider(String fileType) {
        StandaloneMetadataProvider standaloneShapingMetadataProvider = null;
        Collection docList = this._fileTypeMap.get((Object)fileType);
        if (docList != null) {
            StandaloneMetadataFileRegistry xmlShapingRegistry = new StandaloneMetadataFileRegistry();
            for (Document doc : docList) {
                try {
                    OracleStandaloneMetadataFromDOM xmlLanguageShapingMetadata = new OracleStandaloneMetadataFromDOM(doc);
                    xmlShapingRegistry.addStandaloneMetadataFile((StandaloneMetadataFile)xmlLanguageShapingMetadata);
                }
                catch (StandaloneMetadataFileException e) {
                    if (_LOGGER.isLoggable(Level.WARNING)) {
                        LogRecord lr = new LogRecord(Level.WARNING, "StandaloneMetadataFileException for XmlShapingHook for fileType {0}");
                        lr.setParameters(new Object[]{fileType});
                        lr.setThrown(e);
                        _LOGGER.log(lr);
                    }
                    return null;
                }
            }
            standaloneShapingMetadataProvider = new StandaloneMetadataProvider(xmlShapingRegistry);
            this._shapingMetadataProviderMap.put(fileType, (MetadataProvider)standaloneShapingMetadataProvider);
            this._fileTypeMap.remove((Object)fileType);
        }
        return standaloneShapingMetadataProvider;
    }

    private final class GenericVisitor
    extends ElementVisitor {
        private GenericVisitor() {
        }

        public void start(ElementStartContext context) {
            Element newElement = this._createElement(XmlShapingHook.this._document, context.getElementName());
            this._setAttributeValues(context, newElement);
            if (XmlShapingHook.this._rootElement == null) {
                XmlShapingHook.this._rootElement = newElement;
                XmlShapingHook.this._targetNamespace = context.getAttributeValue("targetNamespace");
                XmlShapingHook.this._document.appendChild(XmlShapingHook.this._rootElement);
            } else {
                Element parentElement = this._getParentElement((ElementContext)context);
                parentElement.appendChild(newElement);
            }
            context.getScopeData().put(XmlShapingHook._KEY_PARENT_ELEMENT, newElement);
        }

        public void end(ElementEndContext context) {
            String text = context.getText();
            if (text != null) {
                Text textNode = XmlShapingHook.this._document.createTextNode(text);
                this._getParentElement((ElementContext)context).appendChild(textNode);
            }
        }

        private Element _getParentElement(ElementContext context) {
            return (Element)context.getScopeData().get(XmlShapingHook._KEY_PARENT_ELEMENT);
        }

        private Element _createElement(Document doc, ElementName elementName) {
            String localElementName = elementName.getLocalName();
            String localNamespace = elementName.getNamespaceURI();
            String actualName = XmlShapingHook.this._shapingAliasMap.elementNameAlias(localElementName);
            if (XmlShapingHook._XML_SHAPING_NAMESPACE.equals(localNamespace)) {
                localNamespace = XmlShapingHook._METADATA_NAMESPACE;
            }
            return doc.createElementNS(localNamespace, actualName);
        }

        private void _setAttributeValues(ElementStartContext context, Element newElement) {
            String localElementName = context.getElementName().getLocalName();
            for (String attributeName : context.getAttributeNames()) {
                String attributeValue = context.getAttributeValue(attributeName);
                String actualAttributeName = attributeName;
                if ("name".equals(attributeName)) {
                    if ("element".equals(localElementName)) {
                        actualAttributeName = "elementName";
                    } else if ("attribute".equals(localElementName)) {
                        actualAttributeName = "attributeName";
                    }
                } else if ("targetNamespace".equals(attributeName) && "xml-language".equals(localElementName)) {
                    actualAttributeName = "namespace";
                }
                newElement.setAttributeNS(null, actualAttributeName, attributeValue);
            }
        }
    }
}

