/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.bali.xml.addin.palette.XMLPaletteItemHandler;
import oracle.bali.xml.addin.palette.XMLPaletteManager;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.gui.jdev.palette.XmlPalettePage;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.metadata.XmlMetadataResolverEvent;
import oracle.bali.xml.model.metadata.XmlMetadataResolverListener;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.util.NameToStringUtils;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.palette2.PaletteEvent;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteListener;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.view.View;

class XmlPalettePages
extends PalettePages
implements PaletteListener {
    private final Map<String, XmlPalettePage> _pages = new LinkedHashMap<String, XmlPalettePage>();
    private final Collection<PalettePage> _pagesCollection = Collections.unmodifiableCollection(this._pages.values());
    private final Set<PalettePagesListener> _listeners = new CopyOnWriteArraySet<PalettePagesListener>();
    private final JDevPaletteGui _gui;
    private static final Logger _LOGGER = Logger.getLogger(XmlPalettePages.class.getName());
    private Context _context;
    private String _preferredPageName;
    private boolean _openByDefault;
    private float _categoryPageRank = -1.0f;

    public XmlPalettePages(JDevPaletteGui gui) {
        this._gui = gui;
        this._gui.getGuiContext().getModel().getXmlMetadataResolver().addMetadataResolverListener((XmlMetadataResolverListener)new MetadataListener());
        final HashSet added = new HashSet();
        final HashSet changed = new HashSet();
        new ReadOnlyTask(){

            protected Object runImpl(AbstractModel model) {
                XmlPalettePages.this._addItems(XmlPalettePages.this._gui.getGrammarResolver().getGrammars(), added, changed);
                XmlPalettePages.this._addMiscItems(added, changed);
                return null;
            }
        }.run((AbstractModel)this._gui.getView());
    }

    public void paletteOpened(PaletteEvent event) {
    }

    public void paletteClosed(PaletteEvent event) {
    }

    public void selectionChanged(PaletteEvent event) {
    }

    public void itemSelected(PaletteEvent event) {
        if (event.getAction().equals("PALETTE2_ITEM_DEFAULTCREATE") || event.getAction().equals("PALETTE2_ITEM_SELECTED")) {
            this.handleInsert(event);
        }
    }

    private void handleInsert(PaletteEvent event) {
        XMLPaletteItemHandler handler;
        Editor editor;
        XmlPaletteItem xmlPaletteItem;
        PaletteItem selectedPaletteItem;
        Object paletteItem = event.getSource();
        if (paletteItem instanceof XmlPaletteItem && (selectedPaletteItem = this.getItem("oracle.bali.xml.metadata.XmlKey_item", (xmlPaletteItem = (XmlPaletteItem)event.getSource()).getItemId())) != null && (editor = EditorManager.getEditorManager().getCurrentEditor()) != null && this._context != null && this._palettePageContextMatchesEditorContext(editor) && (handler = XMLPaletteManager.getItemHandler(editor.getClass())) != null) {
            handler.insertItem(this._context, xmlPaletteItem.getKey(), editor);
            PaletteManager.getPaletteManager().getPaletteWindow().unSelectSelectedItem();
            EditorManager.getEditorManager().activateCurrentEditorFrame();
        }
    }

    public void itemUnselected(PaletteEvent event) {
    }

    public void stickyModeActivated(PaletteEvent event) {
    }

    public void stickyModeDeactivated(PaletteEvent event) {
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public Collection<PalettePage> getPages() {
        return this._pagesCollection;
    }

    public void addPalettePagesListener(PalettePagesListener listener) {
        this._listeners.add(listener);
    }

    public void removePalettePagesListener(PalettePagesListener listener) {
        this._listeners.remove(listener);
    }

    public PaletteItem getItem(String providerId, String itemId) {
        if ("oracle.bali.xml.metadata.XmlKey_item".equals(providerId)) {
            XmlKey key;
            try {
                key = NameToStringUtils.parseXmlKeyWithPrefixMappings((CharSequence)itemId, (int[])new int[]{0});
            }
            catch (NameToStringUtils.ParseException e) {
                _LOGGER.log(Level.WARNING, "Exception parsing palette item string!", e);
                return null;
            }
            return this._findItem(key);
        }
        return null;
    }

    public PalettePage getPreferredPage() {
        String preferredPageName = this._gui.getPreferredPageName();
        if (preferredPageName != null) {
            return this._pages.get(preferredPageName);
        }
        this._preferredPageName = null;
        this.getPreferredPageRank();
        if (this._preferredPageName == null) {
            return null;
        }
        return this._pages.get(this._preferredPageName);
    }

    public float getPreferredPageRank() {
        float preferredPageRank = this._gui.getPreferredPageRank();
        if (preferredPageRank > -1.0f) {
            return preferredPageRank;
        }
        float highestPageRank = -1.0f;
        for (XmlPalettePage page : this._pages.values()) {
            float currPageRank = page.getPreferredPageRank();
            if (!(currPageRank > highestPageRank)) continue;
            highestPageRank = currPageRank;
            this._preferredPageName = page.getName();
        }
        return highestPageRank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _update(XmlMetadataResolverEvent e) {
        LinkedHashSet<Grammar> grammarsChanged;
        Set<Grammar> grammarsRemoved;
        Set<Grammar> grammarsAdded;
        if (e.hasGrammarChangeDetails()) {
            GrammarResolverEvent grammarEvent = e.getGrammarChangeDetails();
            grammarsAdded = grammarEvent.getGrammarsAdded();
            grammarsRemoved = grammarEvent.getGrammarsRemoved();
            grammarsChanged = grammarEvent.getGrammarsChanged();
        } else {
            GrammarResolver grammarResolver = this._gui.getGrammarResolver();
            Collection allGrammars = grammarResolver.getGrammars();
            grammarsAdded = Collections.emptySet();
            grammarsRemoved = Collections.emptySet();
            grammarsChanged = new LinkedHashSet<Grammar>(allGrammars);
        }
        Set<XmlPalettePage> addedPages = XmlPalettePages._createSet();
        Set<XmlPalettePage> removedPages = XmlPalettePages._createSet();
        Set<XmlPalettePage> changedPages = XmlPalettePages._createSet();
        XmlPalettePages xmlPalettePages = this;
        synchronized (xmlPalettePages) {
            this._removeItems(grammarsRemoved, changedPages);
            this._addItems(grammarsAdded, addedPages, changedPages);
            this._retainOnlyItems(grammarsChanged, addedPages, changedPages);
            this._trimEmptyContainers(changedPages, removedPages);
            changedPages.removeAll(removedPages);
            changedPages.removeAll(addedPages);
        }
        this._fireEvent(addedPages, removedPages, changedPages);
    }

    private static <T> Set<T> _createSet() {
        return new HashSet();
    }

    private Collection<XmlKey> _getCreatableKeys(Grammar grammar) {
        XmlKey nsKey = ImmutableXmlKey.createNamespaceKey((String)grammar.getTargetNamespace());
        return this._resolver().getCreateableChildrenXmlKeys(null, nsKey);
    }

    private void _fireEvent(final Set<XmlPalettePage> addedPages, final Set<XmlPalettePage> removedPages, final Set<XmlPalettePage> changedPages) {
        if (!(addedPages.isEmpty() && removedPages.isEmpty() && changedPages.isEmpty() || this._listeners.isEmpty())) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.runPalettePagesChanged(addedPages, removedPages, changedPages);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XmlPalettePages.this.runPalettePagesChanged(addedPages, removedPages, changedPages);
                    }
                });
            }
        }
    }

    private void runPalettePagesChanged(Set<XmlPalettePage> addedPages, Set<XmlPalettePage> removedPages, Set<XmlPalettePage> changedPages) {
        for (PalettePagesListener listener : this._listeners) {
            listener.palettePagesChanged(Collections.unmodifiableSet(addedPages), Collections.unmodifiableSet(removedPages), Collections.unmodifiableSet(changedPages));
        }
    }

    private XmlPalettePage _getOrCreatePage(String pageName, float preferredPageRank, Set<XmlPalettePage> addedPages) {
        XmlPalettePage page = this._pages.get(pageName);
        if (page == null) {
            page = new XmlPalettePage(this._gui, pageName, preferredPageRank);
            this._pages.put(pageName, page);
            addedPages.add(page);
        }
        return page;
    }

    private PaletteItem _findItem(XmlKey key) {
        for (XmlPalettePage page : this._pages.values()) {
            PaletteItem item = page.__findItem(key);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private XmlMetadataResolver _resolver() {
        return this._gui.getView().getXmlMetadataResolver();
    }

    private void _removeItems(Set<Grammar> grammars, Set<XmlPalettePage> changedPages) {
        HashSet<String> namespaces = new HashSet<String>(grammars.size());
        for (Grammar grammar : grammars) {
            namespaces.add(grammar.getTargetNamespace());
        }
        for (XmlPalettePage page : this._pages.values()) {
            boolean changed = page.__removeItems(namespaces);
            if (!changed) continue;
            changedPages.add(page);
        }
    }

    private void _addItems(Collection<Grammar> grammars, Set<XmlPalettePage> addedPages, Set<XmlPalettePage> changedPages) {
        for (Grammar grammar : grammars) {
            Collection<XmlKey> keys = this._getCreatableKeys(grammar);
            for (XmlKey key : keys) {
                this._addItem(key, addedPages, changedPages);
            }
        }
    }

    private void _addItem(XmlKey key, Set<XmlPalettePage> addedPages, Set<XmlPalettePage> changedPages) {
        String[] category;
        XmlPalettePage page;
        XmlPaletteItem item;
        if (this._resolver().isXmlKeyCreatableInPalette(key) && (item = (page = this._getOrCreatePage((category = this._getCategory(key))[0], this._categoryPageRank, addedPages)).__addItem(key, category[1], category[2], this._openByDefault)) != null) {
            changedPages.add(page);
        }
    }

    private String[] _getCategory(XmlKey key) {
        String firstLevel = "";
        String secondLevel = "";
        String thirdLevel = "";
        List catDefList = this._resolver().getCategoryDefinition(key);
        if (catDefList != null && !catDefList.isEmpty()) {
            Iterator iter = catDefList.iterator();
            CategoryDefinition catDef = (CategoryDefinition)iter.next();
            firstLevel = catDef.getDisplayName();
            this._categoryPageRank = catDef.getPreferredPageRank();
            if (iter.hasNext()) {
                CategoryDefinition catDefSecondLevel = (CategoryDefinition)iter.next();
                secondLevel = catDefSecondLevel.getDisplayName();
                this._openByDefault = catDefSecondLevel.getOpenByDefault();
            }
            if (iter.hasNext()) {
                thirdLevel = ((CategoryDefinition)iter.next()).getDisplayName();
            }
        } else {
            firstLevel = this._resolver().getGroup(key);
        }
        return new String[]{firstLevel, secondLevel, thirdLevel};
    }

    private void _retainOnlyItems(Set<Grammar> grammars, Set<XmlPalettePage> addedPages, Set<XmlPalettePage> changedPages) {
        HashMap<String, Collection<XmlKey>> m = new HashMap<String, Collection<XmlKey>>(grammars.size());
        for (Grammar grammar : grammars) {
            m.put(grammar.getTargetNamespace(), this._getCreatableKeys(grammar));
        }
        for (Map.Entry entry : m.entrySet()) {
            for (XmlKey key : (Collection)entry.getValue()) {
                String[] category = this._getCategory(key);
                XmlPalettePage page = this._getOrCreatePage(category[0], this._categoryPageRank, addedPages);
                page.__addItem(key, category[1], category[2], this._openByDefault);
            }
        }
        for (XmlPalettePage xmlPalettePage : this._pages.values()) {
            boolean changed = xmlPalettePage.__retainOnlyByGrammar(m);
            if (!changed) continue;
            changedPages.add(xmlPalettePage);
        }
    }

    private void _trimEmptyContainers(Set<XmlPalettePage> candidatePages, Set<XmlPalettePage> removedPages) {
        for (XmlPalettePage page : candidatePages) {
            page.__trimEmptyContainers();
            if (!page.getGroups().isEmpty()) continue;
            this._pages.remove(page.getName());
            removedPages.add(page);
        }
    }

    private void _addMiscItems(Set<XmlPalettePage> added, Set<XmlPalettePage> changed) {
        this._addItem((XmlKey)GlobalNodeTypeKey.TEXT_KEY, added, changed);
        this._addItem((XmlKey)GlobalNodeTypeKey.CDATA_SECTION_KEY, added, changed);
        this._addItem((XmlKey)GlobalNodeTypeKey.COMMENT_KEY, added, changed);
        this._addItem((XmlKey)GlobalNodeTypeKey.PROCESSING_INSTRUCTION_KEY, added, changed);
    }

    private boolean _palettePageContextMatchesEditorContext(Editor editor) {
        Context context = editor.getContext();
        if (context == null) {
            return false;
        }
        Workspace workspace = context.getWorkspace();
        if (workspace == null) {
            return false;
        }
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        Node node = context.getNode();
        if (node == null) {
            return false;
        }
        View view = context.getView();
        if (view == null) {
            return false;
        }
        boolean matches = workspace.equals((Object)this._context.getWorkspace()) && project.equals((Object)this._context.getProject()) && node.equals(this._context.getNode()) && view.equals(this._context.getView());
        return matches;
    }

    private class MetadataListener
    implements XmlMetadataResolverListener {
        private MetadataListener() {
        }

        public void metadataResolverChanged(final XmlMetadataResolverEvent e) {
            new ReadOnlyTask(){

                protected Object runImpl(AbstractModel model) {
                    XmlPalettePages.this._update(e);
                    return null;
                }
            }.run((AbstractModel)XmlPalettePages.this._gui.getView());
        }
    }
}

