/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteGroup;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.metadata.XmlKey;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;

class XmlPalettePage
extends PalettePage {
    private final JDevPaletteGui _gui;
    private final String _name;
    private final Map<String, XmlPaletteGroup> _groups = new TreeMap<String, XmlPaletteGroup>(String.CASE_INSENSITIVE_ORDER);
    private final Collection<PaletteGroup> _groupsCollection = Collections.unmodifiableCollection(this._groups.values());
    private final float _preferredPageRank;

    XmlPalettePage(JDevPaletteGui gui, String name, float preferredPageRank) {
        this._gui = gui;
        this._name = name;
        this._preferredPageRank = preferredPageRank;
    }

    public Collection<PaletteGroup> getGroups() {
        return this._groupsCollection;
    }

    public String getName() {
        return this._name;
    }

    public float getPreferredPageRank() {
        return this._preferredPageRank;
    }

    public String getDescription() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public Object getData(Object key) {
        return null;
    }

    void __addGroup(XmlPaletteGroup group) {
        this._groups.put(group.getName(), group);
    }

    XmlPaletteItem __addItem(XmlKey key, String groupText, String sectionText, boolean openByDefault) {
        XmlPaletteGroup group = this._groups.get(groupText);
        if (group == null) {
            group = new XmlPaletteGroup(groupText, openByDefault);
            this._groups.put(groupText, group);
        }
        return group.__addItem(this._gui, key, sectionText);
    }

    boolean __removeItems(Set<String> namespaces) {
        boolean changed = false;
        for (XmlPaletteGroup group : this._groups.values()) {
            boolean curChanged = group.__removeItems(namespaces);
            if (!curChanged) continue;
            changed = true;
        }
        return changed;
    }

    void __trimEmptyContainers() {
        Iterator<XmlPaletteGroup> itor = this._groups.values().iterator();
        while (itor.hasNext()) {
            XmlPaletteGroup group = itor.next();
            group.__trimEmptyContainers();
            if (!group.getSections().isEmpty()) continue;
            itor.remove();
        }
    }

    boolean __retainOnlyByGrammar(Map<String, Collection<XmlKey>> m) {
        boolean changed = false;
        for (XmlPaletteGroup group : this._groups.values()) {
            boolean c = group.__retainOnlyByGrammar(m);
            changed |= c;
        }
        return changed;
    }

    public String toString() {
        return "{" + this._name + "; " + this._groups + "}";
    }

    PaletteItem __findItem(XmlKey key) {
        for (XmlPaletteGroup group : this._groups.values()) {
            PaletteItem item = group.__findItem(key);
            if (item == null) continue;
            return item;
        }
        return null;
    }
}

