/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteSection;
import oracle.bali.xml.metadata.XmlKey;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

class XmlPaletteGroup
extends PaletteGroup {
    private final String _name;
    private final boolean _openByDefault;
    private final Map<String, XmlPaletteSection> _sections = new TreeMap<String, XmlPaletteSection>(String.CASE_INSENSITIVE_ORDER);
    private final Collection<PaletteSection> _sectionsCollection = Collections.unmodifiableCollection(this._sections.values());

    XmlPaletteGroup(String name, boolean openByDefault) {
        this._name = name;
        this._openByDefault = openByDefault;
    }

    public Collection<PaletteSection> getSections() {
        return this._sectionsCollection;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public Object getData(Object key) {
        Editor editor;
        if ("showForTypes".equalsIgnoreCase((String)key) && this._openByDefault && (editor = EditorManager.getEditorManager().getCurrentEditor()) != null) {
            Context context = editor.getContext();
            if (context == null) {
                return null;
            }
            Node node = context.getNode();
            if (node == null) {
                return null;
            }
            String fileType = XmlPaletteGroup._getSuffix(node.getURL());
            if (fileType == null) {
                return null;
            }
            return Collections.singletonList(fileType);
        }
        return null;
    }

    public boolean isVisible(Context context) {
        return true;
    }

    public String toString() {
        return "{" + this._name + "; " + this._sections + "}";
    }

    void __addSection(XmlPaletteSection section) {
        this._sections.put(section.getName(), section);
    }

    XmlPaletteItem __addItem(JDevPaletteGui gui, XmlKey key, String sectionText) {
        XmlPaletteSection section = this._sections.get(sectionText);
        if (section == null) {
            section = new XmlPaletteSection(sectionText);
            this._sections.put(sectionText, section);
        }
        return section.__addItem(gui, key);
    }

    boolean __removeItems(Set<String> namespaces) {
        boolean changed = false;
        for (XmlPaletteSection section : this._sections.values()) {
            boolean curChanged = section.__removeItems(namespaces);
            if (!curChanged) continue;
            changed = true;
        }
        return changed;
    }

    void __trimEmptyContainers() {
        Iterator<XmlPaletteSection> itor = this._sections.values().iterator();
        while (itor.hasNext()) {
            XmlPaletteSection section = itor.next();
            if (!section.getItems().isEmpty()) continue;
            itor.remove();
        }
    }

    boolean __retainOnlyByGrammar(Map<String, Collection<XmlKey>> m) {
        boolean changed = false;
        for (XmlPaletteSection section : this._sections.values()) {
            boolean c = section.__retainOnlyByGrammar(m);
            changed |= c;
        }
        return changed;
    }

    PaletteItem __findItem(XmlKey key) {
        for (XmlPaletteSection section : this._sections.values()) {
            PaletteItem item = section.__findItem(key);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private static String _getSuffix(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        int period = suffix.lastIndexOf(".");
        if (period != -1) {
            return suffix.substring(period + 1);
        }
        return "";
    }
}

