/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.bali.xml.addin.palette.XMLPaletteItemHandler;
import oracle.bali.xml.addin.palette.XMLPaletteManager;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.Editor;
import org.w3c.dom.Node;

public class VisualEditorItemHandler
implements XMLPaletteItemHandler {
    private static final XMLPaletteItemHandler _sInstance = new VisualEditorItemHandler();

    public static XMLPaletteItemHandler getInstance() {
        return _sInstance;
    }

    public static void registerItemHandler(Class editorClass) {
        XMLPaletteManager.registerItemHandler(VisualEditorItemHandler.getInstance(), editorClass);
    }

    @Override
    public boolean insertItem(Context ideContext, XmlKey key, Editor editor) {
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext(ideContext);
        if (xmlContext != null) {
            XmlView activeView = xmlContext.getActiveView();
            if (activeView == null) {
                String title = xmlContext.getTranslatedString("NoActiveView");
                String messageFormat = xmlContext.getTranslatedString("CannotInsertActiveView");
                String message = FastMessageFormat.formatMessage((String)messageFormat, (String)key.getLocalName());
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
                return false;
            }
            XmlModel xmlModel = xmlContext.getModel();
            DomPosition insertionPosition = this.getInsertionPosition(ideContext, editor, (XmlContext)xmlContext, xmlModel, activeView, key);
            return this.doInsertion(activeView, key, insertionPosition);
        }
        return false;
    }

    public boolean doInsertion(XmlView activeView, XmlKey key, DomPosition insertionPosition) {
        boolean isValid = this._validateInsertionPosition(activeView, key, insertionPosition);
        if (!isValid) {
            return false;
        }
        Node insertedNode = null;
        try {
            insertedNode = activeView.insertXmlKey(key, insertionPosition);
        }
        catch (XmlCommitException e) {
            insertedNode = null;
            activeView.getLogger().log(Level.FINER, "VisualEditorItemHandler insert failed", e);
            String title = activeView.getTranslatedString("ErrorDuringInsertionTitle");
            String messageFormat = activeView.getTranslatedString("ErrorDuringInsertion");
            String message = FastMessageFormat.formatMessage((String)messageFormat, (String)key.getLocalName());
            activeView.getContext().showErrorMessage(message, title, (Throwable)e);
        }
        return insertedNode != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DomPosition getInsertionPosition(Context ideContext, Editor editor, XmlContext xmlContext, XmlModel xmlModel, XmlView activeView, XmlKey xmlKey) {
        DomPosition insertionPosition = null;
        if (activeView != null) {
            activeView.acquireReadLock();
            try {
                insertionPosition = activeView.getSelection().getCursorLocation();
            }
            finally {
                activeView.releaseReadLock();
            }
        }
        return insertionPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _validateInsertionPosition(XmlView activeView, XmlKey key, DomPosition insertionPosition) {
        if (insertionPosition == null) {
            String title = activeView.getTranslatedString("NoInsertionPosition");
            String messageFormat = activeView.getTranslatedString("CannotInsertNoPos");
            String message = FastMessageFormat.formatMessage((String)messageFormat, (String)key.getLocalName());
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
            return false;
        }
        activeView.acquireReadLock();
        boolean isValid = true;
        try {
            List<XmlKey> keyList = Collections.singletonList(key);
            isValid = activeView.getXmlMetadataResolver().isValidInsertion(insertionPosition, keyList);
        }
        finally {
            activeView.releaseReadLock();
        }
        if (!isValid) {
            String title = activeView.getTranslatedString("PALETTE.INVALID_INSERTION");
            String messageFormat = activeView.getTranslatedString("CannotInsertInvalidPos");
            String message = FastMessageFormat.formatMessage((String)messageFormat, (String)key.getLocalName());
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
            return false;
        }
        return true;
    }

    protected VisualEditorItemHandler() {
    }
}

