/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.base.palette.BasePaletteGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.gui.jdev.palette.XmlPalettePages;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette2.PaletteListener;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PaletteWindow;

public class JDevPaletteGui
extends BasePaletteGui {
    public static final String NULL_NAMESPACE_TYPE = "Absent Namespace Pages";
    public static final String MISC_NODE_NAMESPACE = "Misc Xml Nodes";
    public static final String INDICATOR_FIXED_ATTR = ":xmlef__fixedAttribute:";
    public static final String INDICATOR_PSEUDO_KEY = ":xmlef__pseudoXmlKey:";
    public static final String INDICATOR_COMMENT = ":xmlef_comment";
    public static final String INDICATOR_CDATA = ":xmlef_cdata";
    public static final String INDICATOR_TEXT = ":xmlef_text";
    public static final String INDICATOR_PROCESSING_INSTRUCTION = ":xmlef_processing_instruction";
    private static final Map _sGrammarMap = new WeakHashMap();
    private PalettePages _palettePages;
    private final Map<XmlKey, Reference<XmlPaletteItem>> _cachedItems = new HashMap<XmlKey, Reference<XmlPaletteItem>>();

    public JDevPaletteGui(XmlView view) {
        super(view);
    }

    public void activate() {
    }

    public void dispose() {
        if (this._palettePages != null) {
            PaletteWindow pWindow;
            PaletteManager paletteManager = PaletteManager.getPaletteManager();
            if (paletteManager != null && (pWindow = paletteManager.getPaletteWindow()) != null) {
                pWindow.removePaletteListener((PaletteListener)((XmlPalettePages)this._palettePages));
            }
            this._palettePages = null;
        }
        super.dispose();
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        super.handleModelChangeEvent(event);
    }

    protected final JDevXmlContext getJDevXmlContext() {
        return (JDevXmlContext)this.getGuiContext();
    }

    protected final GrammarResolver getGrammarResolver() {
        return this.getGuiContext().getGrammarResolver();
    }

    protected Map getGrammarCache(Grammar g) {
        return (Map)_sGrammarMap.get(g);
    }

    protected void putGrammarCache(Grammar g, Map pageCache) {
        _sGrammarMap.put(g, pageCache);
    }

    protected boolean acceptGrammar(Grammar grammar) {
        return grammar != null;
    }

    protected boolean acceptNodeType(String nodeType, String nodeTypes) {
        return nodeTypes != null && nodeType != null && nodeTypes.indexOf(nodeType) != -1;
    }

    protected boolean acceptPage(boolean acceptNodeType, boolean acceptGrammar) {
        return acceptNodeType && acceptGrammar;
    }

    protected String getNodeType(XMLSourceNode node) {
        String suffix = URLFileSystem.getSuffix((URL)node.getURL());
        int dotIndex = suffix.lastIndexOf(".");
        if (dotIndex != -1) {
            suffix = suffix.substring(dotIndex + 1);
        }
        return suffix;
    }

    protected String getNodeTypes(Grammar grammar) {
        return this._getNodeType();
    }

    public String getPreferredPageName() {
        return null;
    }

    public float getPreferredPageRank() {
        return -1.0f;
    }

    PalettePages __getPalettePages() {
        if (this._palettePages == null) {
            PaletteWindow pWindow;
            this._palettePages = new XmlPalettePages(this);
            PaletteManager paletteManager = PaletteManager.getPaletteManager();
            if (paletteManager != null && (pWindow = paletteManager.getPaletteWindow()) != null) {
                pWindow.addPaletteListener((PaletteListener)((XmlPalettePages)this._palettePages));
            }
        }
        return this._palettePages;
    }

    XmlPaletteItem __createPaletteItem(XmlKey key) {
        XmlPaletteItem item = null;
        Reference<XmlPaletteItem> cachedRef = this._cachedItems.get(key);
        if (cachedRef != null) {
            item = cachedRef.get();
        }
        if (item == null) {
            item = new XmlPaletteItem(this, key);
            this._cachedItems.put(key, new SoftReference<XmlPaletteItem>(item));
        }
        return item;
    }

    private String _getNodeType() {
        XMLSourceNode node = this.getJDevXmlContext().getIdeDocument();
        return this.getNodeType(node);
    }
}

