/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.util.HashMap;
import javax.swing.SwingUtilities;
import oracle.bali.xml.gui.jdev.inspector.XmlInspectable;
import oracle.bali.xml.gui.jdev.inspector.XmlInspectorUtils;
import oracle.ide.Context;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.InspectableFactory;
import oracle.ide.view.View;
import oracle.ide.view.ViewAdapter;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

public final class XmlInspectableFactory
implements InspectableFactory {
    private HashMap _viewsToInspectables = new HashMap();

    public Inspectable getInspectable(Context context) {
        final View view = context.getView();
        if (view != null && XmlInspectorUtils.isSupportedContext(view.getContext())) {
            if (this._viewsToInspectables.get(view) == null) {
                this._viewsToInspectables.put(view, new XmlInspectable());
                view.addViewListener((ViewListener)new ViewAdapter(){

                    public void viewClosed(ViewEvent ve) {
                        XmlInspectable xi = (XmlInspectable)((Object)XmlInspectableFactory.this._viewsToInspectables.remove(view));
                        if (xi != null) {
                            xi.dispose();
                        }
                    }
                });
                view.addViewSelectionListener(new ViewSelectionListener(){

                    public void viewSelectionChanged(ViewSelectionEvent vse) {
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                XmlInspectable xi;
                                if (!view.isVisible() && (xi = (XmlInspectable)((Object)XmlInspectableFactory.this._viewsToInspectables.remove(view))) != null) {
                                    xi.dispose();
                                }
                            }
                        };
                        if (SwingUtilities.isEventDispatchThread()) {
                            r.run();
                        } else {
                            SwingUtilities.invokeLater(r);
                        }
                    }
                });
            }
            Inspectable i = (Inspectable)this._viewsToInspectables.get(view);
            i.setContext(context);
            return i;
        }
        if (this._viewsToInspectables.get(view) != null) {
            XmlInspectable xi = (XmlInspectable)((Object)this._viewsToInspectables.remove(view));
            xi.dispose();
        }
        return null;
    }
}

