/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.net.URL;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.gui.base.inspector.PropertyModelUtils;
import oracle.bali.xml.gui.base.inspector.XmlMultiObjectModel;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModel;
import oracle.bali.xml.gui.jdev.resource.JDevBundle;
import oracle.bali.xml.gui.jdev.undo.TransactionMediator;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.share.TransactionToken;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;

public class XmlIdeMultiObjectModel
extends XmlMultiObjectModel {
    private static final String _UNDO_LABEL = JDevBundle.get("INSPECTOR.UNDO_LABEL");

    public XmlIdeMultiObjectModel(PropertyModel primaryPropertyModel) {
        super(primaryPropertyModel);
    }

    public void setSecondaryModelValue(PropertyModel pm, Object data, int rowIndex, int columnIndex) {
        if (!(pm instanceof XmlPropertyModel)) {
            throw new IllegalStateException("Secondary model is not of type TransactedPropertyModel");
        }
        TransactionMediator tm = TransactionMediator.getInstance();
        TransactionToken tt = tm.createToken();
        tt.setNameIfUnset(_UNDO_LABEL);
        tt.setOwnerIfUnset((Object)this);
        ((XmlPropertyModel)pm).setTransactionToken(tt);
        pm.setValueAt(data, rowIndex, columnIndex);
        this._addDummyEdit(tt, tm);
        tt.dispatch((Object)this, true);
    }

    private void _addDummyEdit(TransactionToken tt, TransactionMediator tm) {
        try {
            XmlContext context = PropertyModelUtils.getInspectorGui((PropertyModel)this.getPrimaryPropertyModel(), (int)0).getView().getContext();
            Node n = NodeFactory.findOrCreate((URL)context.getURL());
            tm.addEdit(tt, n, new DummyUndoEdit());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class DummyUndoEdit
    implements UndoableEdit {
        private DummyUndoEdit() {
        }

        @Override
        public void undo() throws CannotUndoException {
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void redo() throws CannotRedoException {
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public void die() {
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            return true;
        }

        @Override
        public boolean replaceEdit(UndoableEdit anEdit) {
            return true;
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return _UNDO_LABEL;
        }

        @Override
        public String getUndoPresentationName() {
            return _UNDO_LABEL;
        }

        @Override
        public String getRedoPresentationName() {
            return _UNDO_LABEL;
        }
    }
}

