/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyModelUtils;
import oracle.bali.xml.gui.base.inspector.XmlPropertyModel;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.FormLayoutFactory;
import oracle.ide.inspector.layout.PropertyFormLayout;
import oracle.ide.inspector.layout.PropertyFormLayoutAssembly;
import oracle.ide.inspector.layout.PropertyFormLayoutFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class XmlFormLayoutFactory
implements FormLayoutFactory {
    private static final Logger _LOGGER = Logger.getLogger(XmlFormLayoutFactory.class.getName());
    private static final boolean _USE_CACHE = !"true".equals(System.getProperty("xmlef.pi.layout.cache.disabled"));
    private static Map<URI, Element> _sFormLayouts = new ConcurrentHashMap<URI, Element>(64);
    private static Element _NULL_PROPERTY_FORM_LAYOUT = new PropertyFormLayout(){

        public MetaClass getPropertyModelClass() {
            throw new UnsupportedOperationException("null object");
        }

        public List<Element> getChildren() {
            throw new UnsupportedOperationException("null object");
        }
    };

    public PropertyFormLayout createPropertyFormLayout(PropertyModel propertyModel) {
        if (!PropertyModelUtils.isSupportedRootModel((PropertyModel)propertyModel)) {
            return null;
        }
        ArrayList<Element> layouts = new ArrayList<Element>();
        SelectionModel sm = PropertyModelUtils.getSelectionModel((PropertyModel)propertyModel);
        if (sm != null) {
            int c = sm.getSelectedItemCount();
            for (int i = 0; i < c; ++i) {
                PropertyModel pm = (PropertyModel)sm.getSelectedItem(i);
                if (!this._isLayoutProvided(pm)) continue;
                BaseInspectorGui gui = null;
                XmlKey targetKey = null;
                Integer row = this._getRow(pm);
                if (row != null) {
                    gui = PropertyModelUtils.getInspectorGui((PropertyModel)pm, (int)row);
                    targetKey = PropertyModelUtils.getInspectableXmlKey((PropertyModel)pm, (int)row);
                }
                if (gui == null || targetKey == null) continue;
                layouts.addAll(this._getPropertyFormLayout(propertyModel, gui, targetKey));
            }
        }
        if (layouts.size() == 0) {
            return null;
        }
        return new PropertyFormLayoutAssembly(layouts);
    }

    private Integer _getRow(PropertyModel pm) {
        Integer i = null;
        Enumeration e = pm.getPropertyIDs();
        if (e.hasMoreElements()) {
            i = pm.getPropertyIndex(e.nextElement());
        }
        return i;
    }

    private List<Element> _getPropertyFormLayout(final PropertyModel propertyModel, BaseInspectorGui gui, final XmlKey xmlKey) {
        final Node node = PropertyModelUtils.getAncestorNode((PropertyModel)propertyModel, (int)0);
        List uris = (List)new ReadOnlyTask<List<URI>>(){

            protected List<URI> runImpl(AbstractModel model) {
                return model.getXmlMetadataResolver().getPropertyFormLayout(propertyModel, xmlKey, node);
            }
        }.run((AbstractModel)gui.getView());
        if (uris == null || uris.isEmpty()) {
            return Collections.emptyList();
        }
        boolean requiresParsing = false;
        ArrayList<Element> parsedPfls = new ArrayList<Element>(5);
        if (_USE_CACHE) {
            for (URI uri : uris) {
                Element cached = _sFormLayouts.get(uri);
                if (cached == _NULL_PROPERTY_FORM_LAYOUT) continue;
                if (cached != null) {
                    parsedPfls.add(cached);
                    continue;
                }
                requiresParsing = true;
                break;
            }
            if (!requiresParsing) {
                return parsedPfls;
            }
        }
        ArrayList<Element> pfls = new ArrayList<Element>(5);
        for (URI uri : uris) {
            PropertyFormLayout pfl = this._parsePropertyFormLayout(gui, node, xmlKey, uri);
            if (pfl == null) {
                _sFormLayouts.put(uri, _NULL_PROPERTY_FORM_LAYOUT);
                continue;
            }
            pfls.add((Element)pfl);
            _sFormLayouts.put(uri, (Element)pfl);
        }
        return pfls;
    }

    private PropertyFormLayout _parsePropertyFormLayout(BaseInspectorGui gui, Node node, XmlKey key, URI uri) {
        try {
            URL url = uri.isAbsolute() ? uri.toURL() : this.getClass().getResource(uri.toString());
            if (url == null) {
                return null;
            }
            String bundleClassName = gui.getView().getXmlMetadataResolver().getBundleNameForLayoutFile(node, key, uri);
            List pfl = PropertyFormLayoutFactory.getExternalPropertyFormLayouts((XMLReader)this._createFilteredXmlReader(), (InputSource)new InputSource(url.toString()), (String)"oracle.ide.xmlef", (String)bundleClassName);
            if (pfl.size() == 1) {
                return (PropertyFormLayout)pfl.get(0);
            }
            throw new IOException("# of layouts returned from PropertyFormLayoutFactory.getExternalPropertyFormLayouts != 1; is" + pfl.size());
        }
        catch (Exception e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Error parsing PI form layout for {0}; uri={1}");
            lr.setParameters(new Object[]{key, uri});
            lr.setThrown(e);
            _LOGGER.log(lr);
            return null;
        }
    }

    private XMLReader _createFilteredXmlReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        SAXParser sp = spf.newSAXParser();
        XMLReader xmlReader = sp.getXMLReader();
        xmlReader = new FormLayoutConfigFilter(xmlReader);
        return xmlReader;
    }

    private boolean _isLayoutProvided(PropertyModel pm) {
        if (pm instanceof XmlPropertyModel) {
            return ((XmlPropertyModel)pm).isFormLayoutPromoted();
        }
        return false;
    }

    private class FormLayoutConfigFilter
    extends XMLFilterImpl {
        public FormLayoutConfigFilter(XMLReader parent) {
            super(parent);
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            String ns = "http://xmlns.oracle.com/ide/extension";
            String hookName = "property-inspector-hook";
            String pflName = "property-form-layouts";
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", "CDATA", ns);
            this.startElement(ns, hookName, hookName, attrs);
            attrs.clear();
            this.startElement(ns, pflName, pflName, attrs);
            super.parse(input);
            this.endElement(ns, pflName, pflName);
            this.endElement(ns, hookName, hookName);
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
            this.parse(new InputSource(systemId));
        }
    }
}

