/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.indexing;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentHandler;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.indexing.ContextualIndexingFactory;
import oracle.bali.xml.indexing.IndexingFactory;
import oracle.bali.xml.indexing.IndexingProvider;
import oracle.bali.xml.indexing.XmlIndexingContext;
import oracle.ide.Context;
import oracle.ide.index.DataCollector;
import oracle.ide.index.Indexer;
import oracle.ide.index.IndexingContext;
import oracle.ide.model.Node;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.ModelUtil;

public class XMLIndexer
implements Indexer {
    protected static final int IDENTIFIER_ARRAY_SIZE = 256;
    protected static final boolean[] IDENTIFIER_PART = new boolean[256];
    protected static final boolean[] IDENTIFIER_START = new boolean[256];
    private static final Logger _LOGGER;

    public void startIndexing(IndexingContext context) {
    }

    public void endIndexing(IndexingContext context) {
    }

    public void index(IndexingContext context, DataCollector data) {
        XMLSourceNode xmlNode = null;
        Node node = context.getNode();
        if (!(node instanceof XMLSourceNode)) {
            return;
        }
        xmlNode = (XMLSourceNode)node;
        data.add("xml.all", 0, 0, 0, 0);
        TextBuffer buffer = context.getTextBuffer();
        XmlIndexerDocumentHandler handler = new XmlIndexerDocumentHandler(xmlNode, xmlNode.createIndexingProvider(), data);
        Context ideContext = Context.newIdeContext((Node)xmlNode);
        ideContext.setProject(context.getProject());
        DocumentScannerFactory docScannerFactory = xmlNode.getDocumentScannerFactory(ideContext, null);
        docScannerFactory.setIndexingTextBuffer(buffer);
        docScannerFactory.createDocumentScanner().scanDocument((ReadTextBuffer)buffer, (DocumentHandler)handler, new LocatorManager(buffer.getLineMap()));
    }

    static {
        for (char i = '\u0000'; i < '\u0100'; i = (char)(i + '\u0001')) {
            XMLIndexer.IDENTIFIER_PART[i] = Character.isJavaIdentifierPart(i);
            XMLIndexer.IDENTIFIER_START[i] = Character.isJavaIdentifierStart(i);
        }
        _LOGGER = Logger.getLogger(XMLIndexer.class.getName());
    }

    private static class KeywordEntry {
        private String _key;
        private int _hash;
        private int _start;
        private int _end;

        public KeywordEntry(String key, int hash, int start, int end) {
            this._key = key;
            this._hash = hash;
            this._start = start;
            this._end = end;
        }

        public String getKey() {
            return this._key;
        }

        public int getHash() {
            return this._hash;
        }

        public int getStart() {
            return this._start;
        }

        public int getEnd() {
            return this._end;
        }
    }

    private class XmlIndexerIndexingContext
    extends XmlIndexingContext {
        private URL _url;

        private XmlIndexerIndexingContext() {
        }

        public void setNodeUrl(URL url) {
            this._url = url;
        }

        public URL getNodeUrl() {
            return this._url;
        }
    }

    private class XmlIndexerDocumentHandler
    implements DocumentHandler {
        private XMLSourceNode _xmlNode;
        private IndexingProvider _provider;
        private DataCollector _data;
        private boolean _isRoot;
        private Stack<QualifiedName> _qnStack = new Stack();

        public XmlIndexerDocumentHandler(XMLSourceNode xmlNode, IndexingProvider provider, DataCollector data) {
            this._xmlNode = xmlNode;
            this._provider = provider;
            this._data = data;
            this._isRoot = true;
        }

        public void handleStartElement(ResolvedName name, AttributeDeclarations attributes, ElementLocator locator) {
            if (name != null && name.getLocalName() != null) {
                if (this._isRoot) {
                    if (ModelUtil.hasLength((String)name.getLocalName())) {
                        this._data.add("xml.root.element", name.getLocalName().hashCode(), 0, 0, 0);
                    }
                    if (ModelUtil.hasLength((String)name.getNamespace())) {
                        this._data.add("xml.root.namespace", name.getNamespace().hashCode(), 0, 0, 0);
                    }
                    this._isRoot = false;
                }
                QualifiedName elemQN = QualifiedName.getQualifiedName((String)name.getNamespace(), (String)name.getLocalName());
                this._qnStack.push(elemQN);
                if (attributes.getLength() > 0) {
                    this._handleAttributes(elemQN, attributes);
                }
            }
        }

        public void handleEmptyElement(ResolvedName name, AttributeDeclarations attributes, ElementLocator locator) {
            if (name != null && name.getLocalName() != null) {
                if (this._isRoot) {
                    if (ModelUtil.hasLength((String)name.getLocalName())) {
                        this._data.add("xml.root.element", name.getLocalName().hashCode(), 0, 0, 0);
                    }
                    if (ModelUtil.hasLength((String)name.getNamespace())) {
                        this._data.add("xml.root.namespace", name.getNamespace().hashCode(), 0, 0, 0);
                    }
                    this._isRoot = false;
                }
                QualifiedName elemQN = QualifiedName.getQualifiedName((String)name.getNamespace(), (String)name.getLocalName());
                if (attributes.getLength() > 0) {
                    this._handleAttributes(elemQN, attributes);
                }
            }
        }

        public void handleEndElement(ResolvedName name, SimpleLocator locator, boolean complete) {
            if (name != null && name.getLocalName() != null) {
                this._qnStack.pop();
            }
        }

        public void handleCDATASection(String characters, SimpleLocator locator) {
        }

        public void handleText(String characters, TextLocator locator) {
            if (!this._qnStack.empty() && ModelUtil.hasLength((String)characters) && locator != null && locator.getLength() > 0) {
                List<KeywordEntry> keywords = this.getKeywordEntries(characters);
                for (KeywordEntry k : keywords) {
                    try {
                        int start = locator.getContentTextOffset(k.getStart());
                        int end = locator.getContentTextOffset(k.getEnd());
                        this._data.add(k.getKey(), k.getHash(), 0, start, end);
                    }
                    catch (Exception ex) {
                        _LOGGER.log(Level.WARNING, "Error getting text locator", ex);
                    }
                }
                QualifiedName elemQN = this._qnStack.peek();
                List factories = this._provider.getIndexingFactories(elemQN, null, characters);
                if (factories != null) {
                    for (IndexingFactory f : factories) {
                        try {
                            if (f instanceof ContextualIndexingFactory) {
                                XmlIndexerIndexingContext indexingContext = new XmlIndexerIndexingContext();
                                indexingContext.setNodeUrl(this._xmlNode.getURL());
                                ((ContextualIndexingFactory)f).setIndexingContext((XmlIndexingContext)indexingContext);
                            }
                            List entries = f.getIndexEntries(elemQN, null, characters);
                            for (IndexingFactory.IndexEntry e : entries) {
                                try {
                                    int start = locator.getContentTextOffset(e.getStart());
                                    int end = locator.getContentTextOffset(e.getEnd());
                                    this._data.add(e.getKey(), e.getValueHash(), 0, start, end);
                                }
                                catch (Exception ex) {
                                    _LOGGER.log(Level.WARNING, "Error getting text locator", ex);
                                }
                            }
                        }
                        catch (Exception e) {
                            _LOGGER.log(Level.WARNING, "Error creating Index entries for: " + elemQN.toString(), e);
                        }
                    }
                }
            }
        }

        public void handleProcessingInstruction(String target, String data, SimpleLocator locator) {
        }

        public void handleXMLDeclaration(String version, String encoding, String standalone, DeclarationLocator locator) {
        }

        public void handleDocumentType(ResolvedName name, String publicID, String systemID, SimpleLocator locator) {
            if (ModelUtil.hasLength((String)systemID)) {
                this._data.add("xml.system.id", systemID.hashCode(), 0, 0, 0);
            }
        }

        public void handleComment(String text, SimpleLocator locator) {
            if (ModelUtil.hasLength((String)text) && locator != null && locator.getLength() > 0) {
                try {
                    List<KeywordEntry> keywords = this.getKeywordEntries(text);
                    for (KeywordEntry k : keywords) {
                        try {
                            int start = locator.getStartOffset() + k.getStart();
                            int end = locator.getStartOffset() + k.getEnd();
                            this._data.add(k.getKey(), k.getHash(), 0, start, end);
                        }
                        catch (Exception ex) {
                            _LOGGER.log(Level.WARNING, "Error getting text locator", ex);
                        }
                    }
                    List entries = this._provider.getCommentIndexEntries(text);
                    for (IndexingFactory.IndexEntry e : entries) {
                        try {
                            int start = locator.getStartOffset() + e.getStart();
                            int end = locator.getStartOffset() + e.getEnd();
                            this._data.add(e.getKey(), e.getValueHash(), 0, start, end);
                        }
                        catch (Exception ex) {
                            _LOGGER.log(Level.WARNING, "Error getting text locator", ex);
                        }
                    }
                }
                catch (Exception e) {
                    _LOGGER.log(Level.WARNING, "Error creating Index entries for comment", e);
                }
            }
        }

        private void _handleAttributes(QualifiedName elemQN, AttributeDeclarations attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                QualifiedName attrQN;
                List factories;
                String value = attributes.getValue(i);
                if (!ModelUtil.hasLength((String)value)) continue;
                ResolvedName name = attributes.getResolvedName(i);
                AttributeLocator al = attributes.getLocator(i);
                TextLocator tl = al.getValueLocator();
                if (tl == null || tl.getLength() <= 0) continue;
                List<KeywordEntry> keywords = this.getKeywordEntries(value);
                for (KeywordEntry k : keywords) {
                    try {
                        int start = tl.getContentTextOffset(k.getStart());
                        int end = tl.getContentTextOffset(k.getEnd());
                        this._data.add(k.getKey(), k.getHash(), 0, start, end);
                    }
                    catch (Exception ex) {
                        _LOGGER.log(Level.WARNING, "Error getting text locator", ex);
                    }
                }
                if (name == null || name.getLocalName() == null || (factories = this._provider.getIndexingFactories(elemQN, attrQN = QualifiedName.getQualifiedName((String)name.getNamespace(), (String)name.getLocalName()), value)) == null) continue;
                for (IndexingFactory f : factories) {
                    if (f instanceof ContextualIndexingFactory) {
                        XmlIndexerIndexingContext indexingContext = new XmlIndexerIndexingContext();
                        indexingContext.setNodeUrl(this._xmlNode.getURL());
                        ((ContextualIndexingFactory)f).setIndexingContext((XmlIndexingContext)indexingContext);
                    }
                    try {
                        List entries = f.getIndexEntries(elemQN, attrQN, value);
                        for (IndexingFactory.IndexEntry e : entries) {
                            try {
                                int start = tl.getContentTextOffset(e.getStart());
                                int end = tl.getContentTextOffset(e.getEnd());
                                this._data.add(e.getKey(), e.getValueHash(), 0, start, end);
                            }
                            catch (Exception ex) {
                                _LOGGER.log(Level.WARNING, "Error getting text locator", ex);
                            }
                        }
                    }
                    catch (Exception e) {
                        _LOGGER.log(Level.WARNING, "Error creating Index entries for: " + attrQN.toString(), e);
                    }
                }
            }
        }

        private List<KeywordEntry> getKeywordEntries(String keywords) {
            ArrayList<KeywordEntry> keyEntries = new ArrayList<KeywordEntry>();
            int hash = 0;
            int start = -1;
            int end = -1;
            int len = keywords.length();
            int pos = 0;
            while (pos < len) {
                char c = keywords.charAt(pos);
                if (start == -1) {
                    if (c < '\u0100' && IDENTIFIER_START[c] || Character.isJavaIdentifierStart(c)) {
                        start = pos;
                        hash = this._data.hash(0, c);
                    }
                } else if (!(c < '\u0100' && IDENTIFIER_PART[c] || Character.isJavaIdentifierPart(c))) {
                    end = pos;
                } else {
                    hash = this._data.hash(hash, c);
                }
                ++pos;
                if (start == -1) continue;
                if (pos >= len && end == -1) {
                    end = len;
                }
                if (end == -1) continue;
                keyEntries.add(new KeywordEntry("keyword.contains", hash, start, end));
                start = -1;
                end = -1;
            }
            return keyEntries;
        }
    }
}

