/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.wizard;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.addin.wizard.XMLStringFormatter;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.bali.xml.metadata.DomNodeXmlKey;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.NonValidatingTransactionTask;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SchemaBasedXMLBuilder {
    private static final String _XML_NS = "xmlns";
    private static final String _XML_XSI = "xmlns:xsi";
    private static final String _XML_SCHEMA_LOC = "xsi:schemaLocation";
    private static final String _XML_NNS_SCHEMA_LOC = "xsi:noNamespaceSchemaLocation";
    private static final String _XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final String _XMLXSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final Logger _LOG = Logger.getLogger("oracle.bali.xml.addin.wizard.SchemaBasedXMLBuilder");
    private final Project _project;
    private final URL _filename;
    private final Grammar _grammar;
    private final ElementDef _root;
    private final MetadataProvider _metadataProvider;
    private final GrammarProvider _grammarProvider;
    private final GrammarResolver _grammarResolver;
    private XmlMetadataResolver _resolver;
    private Document _doc;
    private final int _depth;
    private final boolean _onlyReqElems;
    private final boolean _registeredSchema;
    private final Stack _namespaces = new Stack();
    private final String _encoding;

    public SchemaBasedXMLBuilder(Project project, URL filename, Grammar grammar, GrammarProvider grammarProvider, ElementDef root, int depth, boolean reqElems, boolean registeredSchema, String encoding) {
        this._project = project;
        this._filename = filename;
        this._grammar = grammar;
        this._root = root;
        this._depth = depth;
        this._onlyReqElems = reqElems;
        this._registeredSchema = registeredSchema;
        this._encoding = encoding;
        this._grammarProvider = grammarProvider;
        this._grammarResolver = new GrammarResolver(this._grammarProvider);
        this._metadataProvider = new GrammarMetadataProvider(this._grammarResolver);
    }

    public void build() {
        QualifiedName qn = this._root.getQualifiedName();
        final XmlModel model = this._getModelFromSource(qn);
        this._resolver = model.getXmlMetadataResolver();
        model.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, this._encoding, null));
        new FixedNameTransactionTask("Create Xml Document Root"){

            protected void performTask(AbstractModel ignoreParam) {
                SchemaBasedXMLBuilder.this._doc = model.getDocument();
                Element[] roots = SchemaBasedXMLBuilder.this._createDOMElement(SchemaBasedXMLBuilder.this._doc, SchemaBasedXMLBuilder.this._root, 10, 0, 0);
                Element e = roots[0];
                SchemaBasedXMLBuilder.this._setAttributeValues(e);
                if (!SchemaBasedXMLBuilder.this._registeredSchema) {
                    e.setAttributeNS(SchemaBasedXMLBuilder._XMLNS_NAMESPACE, SchemaBasedXMLBuilder._XML_XSI, SchemaBasedXMLBuilder._XMLXSI_NAMESPACE);
                    String targetNameSpace = SchemaBasedXMLBuilder.this._grammar.getTargetNamespace();
                    String relativeSchemaFilename = model.getContext().getRelativePathForURL(SchemaBasedXMLBuilder.this._grammar.getLocation());
                    if (targetNameSpace != null) {
                        String schemaLocation = targetNameSpace + " " + relativeSchemaFilename;
                        e.setAttributeNS(SchemaBasedXMLBuilder._XMLXSI_NAMESPACE, SchemaBasedXMLBuilder._XML_SCHEMA_LOC, schemaLocation);
                    } else {
                        e.setAttributeNS(SchemaBasedXMLBuilder._XMLXSI_NAMESPACE, SchemaBasedXMLBuilder._XML_NNS_SCHEMA_LOC, relativeSchemaFilename);
                    }
                }
                model.fixPrefixes((org.w3c.dom.Node)SchemaBasedXMLBuilder.this._doc, (org.w3c.dom.Node)e);
                SchemaBasedXMLBuilder.this._doc.appendChild(e);
            }

            protected Logger getLogger(AbstractModel model2) {
                return _LOG;
            }
        }.run((AbstractModel)model);
        new NonValidatingTransactionTask(){

            protected void performTask(AbstractModel ignoreParam) {
                SchemaBasedXMLBuilder.this._doc = model.getDocument();
                Element e = SchemaBasedXMLBuilder.this._doc.getDocumentElement();
                SchemaBasedXMLBuilder.this.handleElementDef(e, SchemaBasedXMLBuilder.this._root, 0, model);
            }

            protected String getTransactionNameWithoutModelAccess() {
                return "Create Xml Document Body";
            }

            protected Logger getLogger(AbstractModel model2) {
                return _LOG;
            }
        }.run((AbstractModel)model);
    }

    protected void handleElementDef(Element parent, ElementDef e, int depth, XmlModel model) {
        Type t;
        boolean namespaceChange = false;
        String oldNamespace = null;
        if (!this._namespaces.isEmpty()) {
            oldNamespace = (String)this._namespaces.peek();
        }
        String namespace = e.getQualifiedName().getNamespace();
        if (oldNamespace == null && namespace != null || namespace != null && !oldNamespace.equals(namespace)) {
            parent.setAttributeNS(_XMLNS_NAMESPACE, _XML_NS, namespace);
            this._namespaces.push(namespace);
            namespaceChange = true;
        }
        if ((t = e.getType()) instanceof ComplexType) {
            ComplexType cType = (ComplexType)t;
            ContentGroup cg = cType.getContentGroup();
            this.handleContentGroup(parent, e, cg, cg.getVariety(), depth, model);
        }
        if (namespaceChange) {
            this._namespaces.pop();
        }
    }

    protected void handleContentGroup(Element parent, ElementDef e, ContentGroup cg, int variety, int depth, XmlModel model) {
        if (depth >= this._depth) {
            return;
        }
        Collection components = cg.getComponents();
        Iterator compItor = components.iterator();
        int childCount = 0;
        while (compItor.hasNext()) {
            Element[] newElems;
            GrammarComponent component = (GrammarComponent)compItor.next();
            if (component instanceof ContentGroup) {
                ContentGroup subGroup = (ContentGroup)component;
                int subVariety = subGroup.getVariety();
                this.handleContentGroup(parent, e, subGroup, subVariety, depth, model);
                continue;
            }
            if (!(component instanceof ElementDef)) continue;
            ElementDef childDef = (ElementDef)component;
            if (!childDef.isAbstract() && (newElems = this._createDOMElement(parent, childDef, variety, childCount++, depth)) != null) {
                for (int i = 0; i < newElems.length; ++i) {
                    Element newElem = newElems[i];
                    this._setAttributeValues(newElem);
                    model.fixPrefixes((org.w3c.dom.Node)parent, (org.w3c.dom.Node)newElem);
                    parent.appendChild(newElem);
                    this.handleElementDef(newElem, childDef, depth + 1, model);
                }
            }
            SubstitutionGroup substGroup = childDef.getSubstitutionGroup();
            for (ElementDef subElem : substGroup.getElementDefs()) {
                Element[] newElems2 = this._createDOMElement(parent, subElem, 8, childCount++, depth);
                if (newElems2 == null) continue;
                for (int i = 0; i < newElems2.length; ++i) {
                    Element newElem = newElems2[i];
                    this._setAttributeValues(newElem);
                    model.fixPrefixes((org.w3c.dom.Node)parent, (org.w3c.dom.Node)newElem);
                    parent.appendChild(newElem);
                    this.handleElementDef(newElem, subElem, depth + 1, model);
                }
            }
        }
    }

    private void _setAttributeValues(Element e) {
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr newAttr = (Attr)attrs.item(i);
            XmlKey key = DomNodeXmlKey.createImmutableXmlKey((GrammarResolver)this._grammarResolver, (org.w3c.dom.Node)newAttr);
            String value = null;
            value = this._resolver != null ? this._resolver.getInitialValue(key) : (String)this._metadataProvider.getMetadataItem((Object)key, (Object)XmlMetadataConstants.ATTRIBUTE_INITIALVALUE);
            if (value == null) continue;
            newAttr.setNodeValue(value);
        }
    }

    private Element[] _createDOMElement(org.w3c.dom.Node parent, ElementDef e, int variety, int num, int depth) {
        int minOccurs = e.getMinOccurs();
        if (this._onlyReqElems && minOccurs <= 0) {
            return null;
        }
        QualifiedName qn = e.getQualifiedName();
        Element ref = this._doc.createElementNS(qn.getNamespace(), qn.getName());
        for (AttributeDef attr : e.getAttributeDefs()) {
            Set possibleValues;
            String value;
            if (!attr.isRequired()) continue;
            QualifiedName aQn = attr.getQualifiedName();
            Attr newAttr = this._doc.createAttributeNS(aQn.getNamespace(), aQn.getName());
            String defaultValue = attr.getFixedValue();
            String string = value = defaultValue != null ? defaultValue : attr.getDefaultValue();
            if (value == null && !(possibleValues = AttributeValueUtils.getAttributeValues((AttributeDef)attr)).isEmpty()) {
                value = (String)possibleValues.iterator().next();
            }
            if (value != null) {
                newAttr.setNodeValue(value);
            }
            ref.setAttributeNodeNS(newAttr);
        }
        Element[] ret = null;
        if (minOccurs <= 1) {
            ret = new Element[]{ref};
        } else {
            ret = new Element[minOccurs];
            for (int i = 0; i < minOccurs; ++i) {
                ret[i] = (Element)ref.cloneNode(true);
            }
        }
        if (variety == 8 && num > 0) {
            StringBuffer commentContents = new StringBuffer();
            for (int i = 0; i < ret.length; ++i) {
                XMLStringFormatter.processElement(ret[i], commentContents, depth + 1, true);
            }
            Comment com = this._doc.createComment(commentContents.toString());
            parent.appendChild(com);
            return null;
        }
        return ret;
    }

    private XmlModel _getModelFromSource(QualifiedName startingElement) {
        Node n = null;
        try {
            n = NodeFactory.findOrCreateUsingDefault((URL)this._filename, XMLSourceNode.class);
        }
        catch (InstantiationException e) {
            this._logException(e);
        }
        catch (IllegalAccessException e) {
            this._logException(e);
        }
        XMLSourceNode xmlNode = (XMLSourceNode)n;
        XmlModel model = xmlNode.getModel(this._project);
        return model;
    }

    private void _logException(Throwable t) {
        _LOG.log(Level.WARNING, t.getLocalizedMessage(), t);
    }
}

