/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.sort.Sort;
import oracle.bali.xml.addin.SchemaRegistryAddin;
import oracle.bali.xml.addin.XMLEditorAddin;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.addin.schema.AddSchemaPanel;
import oracle.bali.xml.addin.schema.MapSchema;
import oracle.bali.xml.addin.schema.SchemaLoader;
import oracle.bali.xml.addin.schema.SchemaMap;
import oracle.bali.xml.addin.schema.SchemaOptions;
import oracle.bali.xml.addin.schema.URLRenderer;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.controls.nicetable.NiceTable;

public final class SchemaOptionsPanel
extends DefaultTraversablePanel
implements ListSelectionListener,
ActionListener {
    private static final String _KEY_JDEV_LABEL = "SCHEMAADDIN.OPTIONS_JDEV_LABEL";
    private static final String _KEY_USER_LABEL = "SCHEMAADDIN.OPTIONS_USER_LABEL";
    private static final String _KEY_ADD = "SCHEMAADDIN.ADD_LABEL";
    private static final String _KEY_REMOVE = "SCHEMAADDIN.REMOVE_LABEL";
    private static final String _KEY_EDIT = "SCHEMAADDIN.EDIT_LABEL";
    private static final String _KEY_EXT = "SCHEMAADDIN.EXTENSION_HEADER";
    private static final String _KEY_LOCATION = "SCHEMAADDIN.LOCATION_HEADER";
    private static final String _KEY_UNLOAD = "SCHEMAADDIN.UNLOAD_LABEL";
    private static final String _KEY_ERROR_TITLE = "SCHEMAADDIN.ERROR_LOADING_TITLE";
    private static final String _KEY_INVALID_URL = "SCHEMAADDIN.INVALID_URL";
    private static final String _KEY_IOERROR = "SCHEMAADDIN.IOERROR";
    private static final String _KEY_ERROR_EDITING_TITLE = "SCHEMAADDIN.ERROR_EDITING_TITLE";
    private static final String _KEY_EDITERROR = "SCHEMAADDIN.EDITERROR";
    private static String _KEY_IGNORE = "SCHEMAADDIN.IGNORE_ERROR";
    private static String _KEY_EDIT_FILE = "SCHEMAADDIN.EDIT_FILE";
    private static final int _INDEX_URL = 0;
    private static final int _INDEX_EXT = 1;
    private static final String[] _columns = new String[]{SchemaOptionsPanel.getTranslatedString("SCHEMAADDIN.LOCATION_HEADER"), SchemaOptionsPanel.getTranslatedString("SCHEMAADDIN.EXTENSION_HEADER")};
    private JButton _removeButton;
    private JButton _editButton;
    private NiceTable _jdevTable;
    private NiceTable _userTable;
    private AddSchemaPanel _addPane;
    private SchemaMap _map;
    private boolean _dirty;
    private JScrollPane _jdevTableScrollPane;
    private TableComponentAdapter _jdevComponentListener;
    private TableColumnModelListener _jdevTableColumnModelListener;
    private JScrollPane _userTableScrollPane;
    private TableComponentAdapter _userComponentListener;
    private TableColumnModelListener _userTableColumnModelListener;
    private static int _jdevFileColumnWidth = -1;
    private static int _jdevExtColumnWidth = -1;
    private static int _userFileColumnWidth = -1;
    private static int _userExtColumnWidth = -1;

    public SchemaOptionsPanel() {
        this.setHelpID("f1_prefxmlschemas_html");
        this._init();
    }

    public static String getTranslatedString(String key) {
        return SchemaRegistryAddin.getTranslatedString(key);
    }

    public void onEntry(TraversableContext tc) {
        this._load(this._getOptions(tc));
        this._dirty = false;
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        SchemaOptions options = this._getOptions(tc);
        this._save(options);
        final SchemaMap schemaMap = options.getSchemas();
        if (this._dirty) {
            this._dirty = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (schemaMap != null) {
                        SchemaRegistryAddin.loadSchemasForOpenEditors(schemaMap);
                    }
                }
            });
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this._enableButtons();
    }

    private void _enableButtons() {
        boolean enabled = this._userTable.getSelectedRowCount() > 0 && this._userTable.getModel().getRowCount() > 0;
        this._removeButton.setEnabled(enabled);
        enabled = this._userTable.getSelectedRowCount() > 1 ? false : enabled;
        this._editButton.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        DefaultTableModel model = (DefaultTableModel)this._userTable.getModel();
        if ("ADD".equals(cmd)) {
            this._showAddDialog(model);
        } else if ("REMOVE".equals(cmd)) {
            int[] rows = this._userTable.getSelectedRows();
            if (rows != null) {
                Sort.qSort((int[])rows, (int)rows.length, (boolean)false);
                HashSet<String> affectedExtensions = new HashSet<String>();
                for (int i = 0; i < rows.length; ++i) {
                    int row = rows[i];
                    URL url = (URL)model.getValueAt(row, 0);
                    String ext = (String)model.getValueAt(row, 1);
                    affectedExtensions.add(ext);
                    this._map.remove(url, ext, true);
                    model.removeRow(row);
                }
                this._enableButtons();
                this._dirty = true;
                Iterator extIter = affectedExtensions.iterator();
                while (extIter.hasNext()) {
                    SchemaRegistryAddin.clearAndReloadOnDemand((String)extIter.next());
                }
            }
        } else if ("UNLOAD".equals(cmd)) {
            this._dirty = true;
            SchemaRegistryAddin.clearAndReloadOnDemand();
        } else if ("EDIT".equals(cmd)) {
            int row = this._userTable.getSelectedRow();
            this._showEditDialog(model, row);
        }
    }

    private void _load(SchemaOptions options) {
        TableColumnModel columnModel;
        this._map = options.getSchemas().copy();
        MapSchema[] schemas = this._map.getSchemas();
        int count = schemas == null ? 0 : schemas.length;
        DefaultTableModel userModel = new DefaultTableModel(_columns, 0){

            @Override
            public boolean isCellEditable(int row, int colum) {
                return false;
            }
        };
        DefaultTableModel jdevModel = new DefaultTableModel(_columns, 0){

            @Override
            public boolean isCellEditable(int row, int colum) {
                return false;
            }
        };
        Object[] data = new Object[2];
        for (int i = 0; i < count; ++i) {
            String ext = schemas[i].getExtension();
            data[0] = schemas[i].getURL();
            data[1] = ext;
            if (schemas[i].isUserDefined()) {
                userModel.addRow(data);
                continue;
            }
            jdevModel.addRow(data);
        }
        TableModelListener userModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (0 == e.getType() || -1 == e.getType()) {
                    ComponentListener[] listeners = SchemaOptionsPanel.this._userTableScrollPane.getComponentListeners();
                    boolean stillListening = false;
                    for (int i = 0; i < listeners.length; ++i) {
                        if (listeners[i] != SchemaOptionsPanel.this._userComponentListener) continue;
                        stillListening = true;
                    }
                    if (stillListening) {
                        SchemaOptionsPanel.this._userComponentListener.setColumnWidthsToFit(SchemaOptionsPanel.this._userTableScrollPane);
                    } else {
                        SchemaOptionsPanel._setMaxColumnWidths(SchemaOptionsPanel.this._userTable, SchemaOptionsPanel.this._userTableColumnModelListener);
                    }
                }
            }
        };
        userModel.addTableModelListener(userModelListener);
        this._userTableColumnModelListener = new AbstractTableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                TableColumnModel columnModel = (TableColumnModel)e.getSource();
                if (null != SchemaOptionsPanel.this._userComponentListener) {
                    SchemaOptionsPanel.this._userTableScrollPane.removeComponentListener(SchemaOptionsPanel.this._userComponentListener);
                    SchemaOptionsPanel._setMaxColumnWidths(SchemaOptionsPanel.this._userTable, SchemaOptionsPanel.this._userTableColumnModelListener);
                }
                _userFileColumnWidth = columnModel.getColumn(0).getWidth();
                _userExtColumnWidth = columnModel.getColumn(1).getWidth();
            }
        };
        this._userTable.getColumnModel().addColumnModelListener(this._userTableColumnModelListener);
        this._jdevTableColumnModelListener = new AbstractTableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                TableColumnModel columnModel = (TableColumnModel)e.getSource();
                if (null != SchemaOptionsPanel.this._jdevComponentListener) {
                    SchemaOptionsPanel.this._jdevTableScrollPane.removeComponentListener(SchemaOptionsPanel.this._jdevComponentListener);
                    SchemaOptionsPanel._setMaxColumnWidths(SchemaOptionsPanel.this._jdevTable, SchemaOptionsPanel.this._jdevTableColumnModelListener);
                }
                _jdevFileColumnWidth = columnModel.getColumn(0).getWidth();
                _jdevExtColumnWidth = columnModel.getColumn(1).getWidth();
            }
        };
        this._jdevTable.getColumnModel().addColumnModelListener(this._jdevTableColumnModelListener);
        this._initTable(this._userTable, userModel);
        this._initTable(this._jdevTable, jdevModel);
        if (_jdevFileColumnWidth >= 0) {
            columnModel = this._jdevTable.getColumnModel();
            columnModel.getColumn(0).setWidth(_jdevFileColumnWidth);
            columnModel.getColumn(0).setPreferredWidth(_jdevFileColumnWidth);
            columnModel.getColumn(1).setWidth(_jdevExtColumnWidth);
            columnModel.getColumn(1).setPreferredWidth(_jdevExtColumnWidth);
            SchemaOptionsPanel._setMaxColumnWidths(this._jdevTable, this._jdevTableColumnModelListener);
        } else {
            this._jdevComponentListener.setTableColumnModelListener(this._jdevTableColumnModelListener);
        }
        if (_userFileColumnWidth >= 0) {
            columnModel = this._userTable.getColumnModel();
            columnModel.getColumn(0).setWidth(_userFileColumnWidth);
            columnModel.getColumn(0).setPreferredWidth(_userFileColumnWidth);
            columnModel.getColumn(1).setWidth(_userExtColumnWidth);
            columnModel.getColumn(1).setPreferredWidth(_userExtColumnWidth);
            SchemaOptionsPanel._setMaxColumnWidths(this._userTable, this._userTableColumnModelListener);
        } else {
            this._userComponentListener.setTableColumnModelListener(this._userTableColumnModelListener);
        }
    }

    private void _initTable(NiceTable table, TableModel model) {
        table.setModel(model);
        table.getColumnModel().getColumn(0).setCellRenderer(new URLRenderer());
        KeyStroke key = KeyStroke.getKeyStroke(27, 0);
        for (InputMap iMap = table.getInputMap(1); iMap != null; iMap = iMap.getParent()) {
            iMap.remove(key);
        }
    }

    private static void _setMaxColumnWidths(NiceTable table, TableColumnModelListener listener) {
        JViewport viewPort = (JViewport)table.getParent();
        int tableWidth = viewPort.getWidth();
        int extWidth = SchemaOptionsPanel._getColumnSizeToFit(table, 1);
        int urlWidth = SchemaOptionsPanel._getColumnSizeToFit(table, 0);
        TableColumnModel colModel = table.getColumnModel();
        if (extWidth + urlWidth < tableWidth) {
            urlWidth = tableWidth - extWidth;
        }
        if (null != listener) {
            colModel.removeColumnModelListener(listener);
        }
        colModel.getColumn(1).setMaxWidth(extWidth);
        colModel.getColumn(0).setMaxWidth(urlWidth);
        if (null != listener) {
            colModel.addColumnModelListener(listener);
        }
    }

    private static int _getColumnSizeToFit(NiceTable table, int columnIndex) {
        int maxWidth = 5;
        TableColumn column = table.getTableHeader().getColumnModel().getColumn(columnIndex);
        TableCellRenderer headerRenderer = null;
        if (headerRenderer == null) {
            headerRenderer = column.getHeaderRenderer();
        }
        if (headerRenderer == null) {
            headerRenderer = column.getCellRenderer();
        }
        if (headerRenderer == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        if (headerRenderer != null) {
            maxWidth = headerRenderer.getTableCellRendererComponent((JTable)table, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
        }
        int n = table.getModel().getRowCount();
        TableCellRenderer headerCellRenderer = table.getDefaultRenderer(table.getModel().getColumnClass(columnIndex));
        maxWidth = Math.max(headerCellRenderer.getTableCellRendererComponent((JTable)table, (Object)SchemaOptionsPanel._columns[columnIndex], (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width, maxWidth);
        for (int j = 0; j < n; ++j) {
            Object value = table.getModel().getValueAt(j, columnIndex);
            TableCellRenderer cellRenderer = table.getCellRenderer(j, columnIndex);
            if (cellRenderer == null || value == null) continue;
            maxWidth = Math.max(cellRenderer.getTableCellRendererComponent((JTable)table, (Object)value, (boolean)false, (boolean)false, (int)j, (int)columnIndex).getPreferredSize().width, maxWidth);
        }
        return maxWidth;
    }

    private void _save(SchemaOptions options) throws TraversalException {
        options.setSchemas(this._map);
        this._map = null;
    }

    private void _init() {
        String jdevLabelString = SchemaOptionsPanel.getTranslatedString(_KEY_JDEV_LABEL);
        String userLabelString = SchemaOptionsPanel.getTranslatedString(_KEY_USER_LABEL);
        String addLabel = SchemaOptionsPanel.getTranslatedString(_KEY_ADD);
        String removeLabel = SchemaOptionsPanel.getTranslatedString(_KEY_REMOVE);
        String editLabel = SchemaOptionsPanel.getTranslatedString(_KEY_EDIT);
        String unloadLabel = SchemaOptionsPanel.getTranslatedString(_KEY_UNLOAD);
        SchemaOptionsPanel panel = this;
        ((Container)((Object)panel)).setLayout(new BorderLayout(3, 3));
        JLabel jdevLabel = new JLabel(StringUtils.stripMnemonic((String)jdevLabelString));
        jdevLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)jdevLabelString));
        NiceTable jdevTable = new NiceTable();
        jdevTable.setColumnSelectorAvailable(false);
        jdevTable.setResizeColumnOnDoubleClick(true);
        jdevTable.setShowToolTips(true);
        jdevTable.setPreferredScrollableViewportSize(new Dimension(jdevTable.getPreferredScrollableViewportSize().width, 100));
        jdevTable.getTableHeader().setReorderingAllowed(false);
        jdevTable.setCellSelectionEnabled(true);
        jdevTable.setAutoResizeMode(0);
        jdevLabel.setLabelFor((Component)jdevTable);
        JPanel jdevPanel = new JPanel(new BorderLayout(3, 3));
        jdevPanel.add("North", jdevLabel);
        this._jdevTableScrollPane = new JScrollPane((Component)jdevTable);
        if (_jdevFileColumnWidth < 0) {
            this._jdevComponentListener = new TableComponentAdapter();
            this._jdevTableScrollPane.addComponentListener(this._jdevComponentListener);
        }
        jdevPanel.add("Center", this._jdevTableScrollPane);
        ((Container)((Object)panel)).add("North", jdevPanel);
        JLabel userLabel = new JLabel(StringUtils.stripMnemonic((String)userLabelString));
        userLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)userLabelString));
        NiceTable userTable = new NiceTable();
        userTable.setColumnSelectorAvailable(false);
        userTable.setResizeColumnOnDoubleClick(true);
        userTable.setShowToolTips(true);
        userTable.setPreferredScrollableViewportSize(new Dimension(jdevTable.getPreferredScrollableViewportSize().width, 100));
        userTable.getTableHeader().setReorderingAllowed(false);
        userTable.setSelectionMode(2);
        userTable.setCellSelectionEnabled(true);
        userTable.setAutoResizeMode(0);
        userLabel.setLabelFor((Component)userTable);
        JPanel userPanel = new JPanel(new BorderLayout(3, 3));
        userPanel.add("North", userLabel);
        this._userTableScrollPane = new JScrollPane((Component)userTable);
        if (_userFileColumnWidth < 0) {
            this._userComponentListener = new TableComponentAdapter();
            this._userTableScrollPane.addComponentListener(this._userComponentListener);
        }
        userPanel.add("Center", this._userTableScrollPane);
        ((Container)((Object)panel)).add("Center", userPanel);
        JButton addButton = new JButton(StringUtils.stripMnemonic((String)addLabel));
        addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)addLabel));
        JButton removeButton = new JButton(StringUtils.stripMnemonic((String)removeLabel));
        removeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)removeLabel));
        removeButton.setEnabled(false);
        JButton editButton = new JButton(StringUtils.stripMnemonic((String)editLabel));
        editButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)editLabel));
        editButton.setEnabled(false);
        JButton unloadButton = new JButton(StringUtils.stripMnemonic((String)unloadLabel));
        unloadButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)unloadLabel));
        ButtonBar bar = new ButtonBar();
        bar.setOrientation(1);
        bar.add((Component)addButton);
        bar.add((Component)removeButton);
        bar.add((Component)editButton);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add("North", (Component)bar);
        userPanel.add("East", buttonsPanel);
        JPanel foo = new JPanel(new BorderLayout());
        foo.add("West", unloadButton);
        ((Container)((Object)panel)).add("South", foo);
        this._jdevTable = jdevTable;
        this._userTable = userTable;
        this._userTable.getSelectionModel().addListSelectionListener(this);
        this._removeButton = removeButton;
        this._editButton = editButton;
        editButton.setActionCommand("EDIT");
        editButton.addActionListener(this);
        removeButton.setActionCommand("REMOVE");
        removeButton.addActionListener(this);
        addButton.setActionCommand("ADD");
        addButton.addActionListener(this);
        unloadButton.setActionCommand("UNLOAD");
        unloadButton.addActionListener(this);
    }

    private SchemaOptions _getOptions(TraversableContext tc) {
        return (SchemaOptions)tc.find(SchemaOptions.KEY_SETTINGS);
    }

    private void _showEditDialog(DefaultTableModel model, int rowToEdit) {
        this._showCreatorEditorDialog(model, rowToEdit, true);
    }

    private void _showAddDialog(DefaultTableModel model) {
        this._showCreatorEditorDialog(model, -1, false);
    }

    private void _showCreatorEditorDialog(final DefaultTableModel model, final int rowToEdit, final boolean editing) {
        if (this._addPane == null) {
            this._addPane = new AddSchemaPanel();
        }
        if (editing) {
            String fileText = model.getValueAt(rowToEdit, 0).toString();
            String extText = (String)model.getValueAt(rowToEdit, 1);
            this._addPane.setURL(fileText);
            this._addPane.setExtention(extText);
        } else {
            this._addPane.setURL("");
            this._addPane.setExtention(".xml");
        }
        this._addPane.setEditing(editing);
        if (!this._addPane.showAddDialog((Component)((Object)this))) {
            return;
        }
        String extension = this._addPane.getExtension();
        if (extension == null || "".equals(extension)) {
            extension = ".xml";
        } else if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        URL url = this._addPane.getURL();
        if (null == url) {
            String errorTitle = editing ? SchemaOptionsPanel.getTranslatedString(_KEY_ERROR_EDITING_TITLE) : SchemaOptionsPanel.getTranslatedString(_KEY_ERROR_TITLE);
            JOptionPane.showMessageDialog((Component)((Object)this), SchemaOptionsPanel.getTranslatedString(_KEY_INVALID_URL), errorTitle, 0);
            this._showAddDialog(model);
            return;
        }
        if (url != null) {
            final int count = model.getRowCount();
            for (int i = 0; i < count; ++i) {
                URL temp = (URL)model.getValueAt(i, 0);
                String testExt = (String)model.getValueAt(i, 1);
                if (!SchemaMap.equals(temp, url) || !testExt.equals(extension)) continue;
                return;
            }
            final URL localURL = url;
            final String localExtension = extension;
            Runnable success = new Runnable(){

                @Override
                public void run() {
                    int currentRow;
                    if (editing) {
                        currentRow = rowToEdit;
                        URL url = (URL)model.getValueAt(currentRow, 0);
                        String ext = (String)model.getValueAt(currentRow, 1);
                        SchemaOptionsPanel.this._map.remove(url, ext, true);
                        SchemaRegistryAddin.clearAndReloadOnDemand(ext);
                    } else {
                        model.setRowCount(count + 1);
                        currentRow = count;
                    }
                    model.setValueAt(localURL, currentRow, 0);
                    model.setValueAt(localExtension, currentRow, 1);
                    if (XMLEditorAddin.getClass(localExtension) == null && Recognizer.getClassForExtension((String)localExtension) == null) {
                        XMLEditorAddin.register(XMLSourceNode.class, localExtension, null);
                    }
                    SchemaOptionsPanel.this._map.put(localURL, localExtension, true);
                    SchemaOptionsPanel.this._dirty = true;
                }
            };
            Runnable editFileRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Node node = NodeFactory.findOrCreate((URL)localURL);
                        EditorUtil.openExplicitDefaultEditorInFrame((Node)node);
                    }
                    catch (Exception iae) {
                        String text = SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_EDITERROR);
                        String title = editing ? SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_ERROR_EDITING_TITLE) : SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_ERROR_TITLE);
                        MessageFormat mf = new MessageFormat(text);
                        Object[] args = new Object[]{localURL};
                        String message = mf.format(args);
                        JOptionPane.showMessageDialog((Component)((Object)SchemaOptionsPanel.this), message, title, 0);
                    }
                }
            };
            Runnable ioError = new Runnable(){

                @Override
                public void run() {
                    try {
                        String text = SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_IOERROR);
                        String title = editing ? SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_ERROR_EDITING_TITLE) : SchemaOptionsPanel.getTranslatedString(SchemaOptionsPanel._KEY_ERROR_TITLE);
                        MessageFormat mf = new MessageFormat(text);
                        Object[] args = new Object[]{localURL};
                        String message = mf.format(args);
                        JOptionPane.showMessageDialog((Component)((Object)SchemaOptionsPanel.this), message, title, 0);
                        SchemaOptionsPanel.this._showAddDialog(model);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            SchemaLoader.validateSchema((Component)((Object)this), url, success, editFileRunnable, ioError, SchemaOptionsPanel.getTranslatedString(_KEY_IGNORE), SchemaOptionsPanel.getTranslatedString(_KEY_EDIT_FILE), editing ? SchemaOptionsPanel.getTranslatedString(_KEY_ERROR_EDITING_TITLE) : SchemaOptionsPanel.getTranslatedString(_KEY_ERROR_TITLE));
        }
    }

    private class TableComponentAdapter
    extends ComponentAdapter {
        private TableColumnModelListener _theListener;

        private TableComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.setColumnWidthsToFit((JScrollPane)e.getComponent());
        }

        public void setTableColumnModelListener(TableColumnModelListener theListener) {
            this._theListener = theListener;
        }

        public void setColumnWidthsToFit(JScrollPane scrollPane) {
            JViewport viewPort = scrollPane.getViewport();
            NiceTable theTable = (NiceTable)viewPort.getView();
            TableColumnModel columnModel = theTable.getColumnModel();
            columnModel.removeColumnModelListener(this._theListener);
            int width = SchemaOptionsPanel._getColumnSizeToFit(theTable, 1);
            int tableWidth = viewPort.getWidth();
            columnModel.getColumn(1).setWidth(width);
            columnModel.getColumn(1).setPreferredWidth(width);
            int urlWidth = tableWidth - width;
            columnModel.getColumn(0).setWidth(urlWidth);
            columnModel.getColumn(0).setPreferredWidth(urlWidth);
            columnModel.addColumnModelListener(this._theListener);
        }
    }

    private class AbstractTableColumnModelListener
    implements TableColumnModelListener {
        private AbstractTableColumnModelListener() {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

