/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import java.awt.Component;
import java.awt.Image;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.addin.CheckSyntaxController;
import oracle.bali.xml.addin.LocateInStructureController;
import oracle.bali.xml.addin.PrettyPrintController;
import oracle.bali.xml.addin.XMLEditorOptions;
import oracle.bali.xml.addin.XMLEditorOptionsPanel;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.addin.explorer.XmlCodeExplorer;
import oracle.bali.xml.addin.help.XMLHelpSupport;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.CodeEditorXmlController;
import oracle.bali.xml.gui.jdev.JDevInspectableViewTracker;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.XmlController;
import oracle.bali.xml.gui.jdev.XmlEditorController;
import oracle.bali.xml.gui.jdev.ceditor.JDevXmlCodeEditorGui;
import oracle.bali.xml.gui.jdev.ceditor.XmlViewSelectionHelperFactory;
import oracle.bali.xml.gui.jdev.datatransfer.FileListDataTransferPlugin;
import oracle.bali.xml.gui.jdev.datatransfer.Palette2ToXmlKeyPlugin;
import oracle.bali.xml.gui.jdev.explorer.XmlExplorerController;
import oracle.bali.xml.gui.jdev.inspector.XmlFormLayoutFactory;
import oracle.bali.xml.gui.jdev.inspector.XmlPropertyModelFactory;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElementRecognizer;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionURLStreamHandlerFactory;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.share.clipboard.AWTClipboardManager;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.ceditor.ViewSelectionHelperFactory;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpableProvider;
import oracle.ide.history.HistoryManager;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.inspector.NotObservableSubjectRegistry;
import oracle.ide.inspector.layout.FormLayoutFactory;
import oracle.ide.inspector.layout.PropertyFormLayoutFactory;
import oracle.ide.layout.Layout;
import oracle.ide.layout.PreferredLayoutEvent;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.ElementFactory;
import oracle.ide.model.ElementRecognizer;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TextNodeHistorian;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.Navigable;
import oracle.ide.util.AddinPolicyUtils;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.MenuSpec;
import oracle.ide.view.ActiveViewListener;
import oracle.javatools.datatransfer.DataTransferPluginRegistry;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.StringUtil;

public class XMLEditorAddin
extends EditorAddin
implements EditorPluginsFactory {
    public static final String IDE_XMLEF_EXTENSION_ID = "oracle.ide.xmlef";
    public static final float BOGUS_WEIGHT_TEXT_AUTO_INDENT = 1.0f;
    public static final float BOGUS_WEIGHT_TEXT_NODE_VALIDATE = 3.0f;
    public static final String XML_TECHNOLOGY_KEY = "XML";
    public static final int PASTE_SPECIAL_CMD_ID = Ide.findOrCreateCmdID((String)"paste_special");
    static final IdeAction PASTE_SPECIAL_ACTION;
    public static final float WEIGHT_EDIT_PASTE_SPECIAL;
    private static final ArrayList _registeredClasses;
    private static final ArrayList _registeredExtensions;
    private static final XMLHelpSupport _helpSupport;
    private static final String KEY_XML_EDITOR = "XMLEDITOR.NAME";
    private static final String _KEY_OPTIONS_NAME = "XMLADDIN.OPTIONS_NAME";
    private static final String _KEY_XML_FILTER = "XMLADDIN.XML_FILTER";
    private static final String _KEY_XML_SOURCE = "XMLADDIN.XML_DOCUMENT";
    private static final String _KEY_XML_STRUCTURE = "XMLADDIN.XML_STRUCTURE";
    private static final String _KEY_XML_EDITING = "XMLADDIN.XML_EDITING";
    private static final String _KEY_PASTE_SPECIAL = "XMLADDIN.PASTE_SPECIAL";
    private static final String _IMAGE = "icons/xmleditor.gif";
    public static final String NODE_ICON = "icons/node.gif";
    public static final String ATTR_ICON = "icons/attr.gif";
    private static Icon _sAttrIcon;
    private static Icon _sNodeIcon;
    private static ArrayList<Class[]> _toRegister;
    private static CheckSyntaxController _checkSyntaxController;
    private static PrettyPrintController _prettyPrintController;
    private static LocateInStructureController _locateInStructureController;
    private static final HelpInfo _HELP_INFO;
    private static final ClipboardActivationHandler _sClipboardHandler;
    private static Navigable _settingsNavigable;
    private static IconsArb _sIconArb;
    private static LayoutListener _layoutListener;
    private MenuSpec _menuSpec;

    public static void register(Class<? extends XMLSourceNode> xmlSourceNodeSubclass, String extension, EditorAddin addin) {
        XMLEditorAddin.register(xmlSourceNodeSubclass, extension, addin, true);
    }

    public static void register(Class<? extends XMLSourceNode> xmlSourceNodeSubclass, String extension, EditorAddin addin, boolean registerExtension) {
        XMLEditorAddin.register(xmlSourceNodeSubclass, extension, addin, registerExtension, null);
    }

    public static void register(Class<? extends XMLSourceNode> xmlSourceNodeSubclass, String extension, EditorAddin addin, boolean registerExtension, Class xmlLanguageCustomizer) {
        XMLEditorAddin.register(xmlSourceNodeSubclass, extension, addin, registerExtension, xmlLanguageCustomizer, true);
    }

    public static void register(Class<? extends XMLSourceNode> xmlSourceNodeSubclass, String extension, EditorAddin addin, boolean registerExtension, Class xmlLanguageCustomizer, boolean schemaValidation) {
        XMLEditorAddin.register(xmlSourceNodeSubclass, extension, addin, registerExtension, xmlLanguageCustomizer, schemaValidation, null);
    }

    public static void register(Class<? extends XMLSourceNode> xmlSourceNodeSubclass, String extension, EditorAddin addin, boolean registerExtension, Class xmlLanguageCustomizer, boolean schemaValidation, DocumentInfo info) {
        XMLEditorAddin.register(xmlSourceNodeSubclass, extension, addin, registerExtension, xmlLanguageCustomizer, schemaValidation, info, true, true);
    }

    public static void register(Class<? extends XMLSourceNode> xmlSourceNodeSubclass, String extension, EditorAddin addin, boolean registerExtension, Class xmlLanguageCustomizer, boolean schemaValidation, DocumentInfo info, boolean registerExplorer, boolean registerInspector) {
        XMLEditorAddin.register(xmlSourceNodeSubclass, extension, addin, registerExtension, xmlLanguageCustomizer, schemaValidation, info, registerExplorer, registerInspector, true);
    }

    public static void register(Class<? extends XMLSourceNode> xmlSourceNodeSubclass, String extension, EditorAddin addin, boolean registerExtension, Class xmlLanguageCustomizer, boolean schemaValidation, DocumentInfo info, boolean registerExplorer, boolean registerInspector, boolean registerLanguageModule) {
        HistoryManager mgr;
        ExplorerManager explorerMgr;
        EditorAddin xmlAddin;
        if (!XMLSourceNode.class.isAssignableFrom(xmlSourceNodeSubclass)) {
            throw new IllegalArgumentException(xmlSourceNodeSubclass + " must be a subclass of XMLSourceNode");
        }
        if (registerLanguageModule) {
            CodeEditor.registerNodeType(xmlSourceNodeSubclass, (String)CodeEditor.TYPE_XML);
            XMLLanguageModule.registerFileType((String)extension);
        }
        if (registerExtension) {
            if (extension.indexOf(".") == -1) {
                extension = "." + extension;
            }
            if (".xml".equals(extension)) {
                Assert.println((String)(xmlSourceNodeSubclass + " is trying to hijack the .xml extension"));
            } else {
                Recognizer.mapExtensionToClass((String)extension, xmlSourceNodeSubclass);
            }
            if (info != null) {
                Recognizer.registerDocumentInfo(xmlSourceNodeSubclass, (DocumentInfo)info);
            }
        }
        Class[] types = new Class[]{xmlSourceNodeSubclass};
        if (addin != null && !(addin instanceof XMLEditorAddin)) {
            EditorManager.getEditorManager().register(addin, types);
        }
        if ((xmlAddin = (EditorAddin)AddinManager.getAddinManager().getAddin(XMLEditorAddin.class)) == null) {
            if (_toRegister == null) {
                _toRegister = new ArrayList();
            }
            _toRegister.add(types);
        } else {
            EditorManager em = EditorManager.getEditorManager();
            if (em != null) {
                em.extend(xmlAddin, types);
            }
        }
        if (registerExplorer && (explorerMgr = ExplorerManager.getExplorerManager()) != null) {
            explorerMgr.register(xmlSourceNodeSubclass, XmlCodeExplorer.class, null, XMLEditorAddin.getTranslatedString(_KEY_XML_STRUCTURE), (ArrayResourceBundle)_sIconArb, 0);
        }
        boolean registeredBefore = _registeredClasses.contains(xmlSourceNodeSubclass);
        _registeredClasses.add(xmlSourceNodeSubclass);
        _registeredExtensions.add(extension);
        if (Ide.getIdeArgs().getCreateUI()) {
            if (!registeredBefore && xmlSourceNodeSubclass != XMLSourceNode.class) {
                CheckSyntaxController csc = XMLEditorAddin.getCheckSyntaxController();
                NavigatorManager mgr2 = NavigatorManager.getWorkspaceNavigatorManager();
                if (mgr2 != null) {
                    mgr2.addContextMenuListener((ContextMenuListener)csc, xmlSourceNodeSubclass);
                }
                if (schemaValidation) {
                    CheckSyntaxController.registerForSchemaValidation(xmlSourceNodeSubclass);
                }
                XMLEditorAddin._registerAutoIndent(xmlSourceNodeSubclass);
            }
            XMLEditorAddin.registerPreferredLayoutListener(xmlSourceNodeSubclass, CodeEditor.class);
        }
        if ((mgr = HistoryManager.getHistoryManager()) != null) {
            try {
                mgr.registerHistorian(TextNodeHistorian.class, xmlSourceNodeSubclass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void registerPreferredLayoutListener(Class xmlSourceNodeSubclass, Class editorClass) {
        EditorManager em = EditorManager.getEditorManager();
        if (em != null) {
            em.registerPreferredLayoutListener(xmlSourceNodeSubclass, editorClass, XMLEditorAddin.getTranslatedString(_KEY_XML_EDITING), (PreferredLayoutListener)_layoutListener);
        }
    }

    public static String getExtension(Class c) {
        int index = c == null ? -1 : _registeredClasses.indexOf(c);
        return index < 0 ? null : (String)_registeredExtensions.get(index);
    }

    public static String[] getExtensions() {
        return _registeredExtensions.toArray(new String[0]);
    }

    public static Class getClass(String ext) {
        int index = ext == null ? -1 : _registeredExtensions.indexOf(ext);
        return index < 0 ? null : (Class)_registeredClasses.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        HistoryManager mgr;
        try {
            AddinPolicyUtils.setWarnWhenCreatingThreads((boolean)false);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).finest("msg to init log framework");
        }
        finally {
            AddinPolicyUtils.setWarnWhenCreatingThreads((boolean)true);
        }
        Recognizer.mapExtensionToClass((String)".xml", XMLSourceNode.class);
        Recognizer.mapExtensionToClass((String)".xsl", XMLSourceNode.class);
        DocumentInfo info = new DocumentInfo(XMLEditorAddin.getTranslatedString(_KEY_XML_SOURCE), null);
        Recognizer.registerDocumentInfo(XMLSourceNode.class, (DocumentInfo)info);
        if (Ide.getIdeArgs().getCreateUI()) {
            AWTClipboardManager.getClipboardManager().setApplicationActive(false);
            Ide.getMainWindow().addIdeActivationListener((IdeActivationListener)_sClipboardHandler);
            Ide.addIdeListener((IdeListener)_sClipboardHandler);
            new XMLLanguageModule();
            Class[] types = new Class[]{XMLSourceNode.class};
            EditorManager.getEditorManager().register((EditorAddin)this, types);
            ExplorerManager explorerMgr = ExplorerManager.getExplorerManager();
            explorerMgr.register(XMLSourceNode.class, XmlCodeExplorer.class, null, XMLEditorAddin.getTranslatedString(_KEY_XML_STRUCTURE), (ArrayResourceBundle)_sIconArb, 0);
            URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)XmlSelectionURLStreamHandlerFactory.getInstance());
            ElementFactory.addRecognizer((ElementRecognizer)XmlSelectionElementRecognizer.getRecognizer());
            PropertyFormLayoutFactory.addFormLayoutFactory((FormLayoutFactory)new XmlFormLayoutFactory());
            InspectorFactory.getInstance().register(XmlPropertyModelFactory.getInstance());
            NotObservableSubjectRegistry.instance().registerNotObservableSubject(XMLSourceNode.class);
            CodeEditor.registerViewSelectionHelperFactory((ViewSelectionHelperFactory)new XmlViewSelectionHelperFactory());
            CodeEditor.registerFactory((EditorPluginsFactory)this);
            CodeEditor.registerNodeType(XMLSourceNode.class, (String)CodeEditor.TYPE_XML);
            _registeredClasses.add(XMLSourceNode.class);
            _registeredExtensions.add(".xml");
            NavigatorManager mgr2 = NavigatorManager.getWorkspaceNavigatorManager();
            if (mgr2 != null) {
                mgr2.addContextMenuListener((ContextMenuListener)XMLEditorAddin.getCheckSyntaxController(), XMLSourceNode.class);
            }
        }
        this._registerSettings();
        if (Ide.getIdeArgs().getCreateUI()) {
            EditorManager.getEditorManager().addEditorListener((EditorListener)new Listener());
            Ide.getMainWindow().addActiveViewListener((ActiveViewListener)JDevInspectableViewTracker.INSTANCE);
            String[] extensions = new String[]{".xml", ".xsd", ".xsl", ".xslt"};
            DefaultURLFilter xmlFilter = new DefaultURLFilter(XMLEditorAddin.getTranslatedString(_KEY_XML_FILTER), extensions);
            DialogUtil.addURLFilter((URLFilter)xmlFilter);
            CheckSyntaxController.registerForSchemaValidation(XMLSourceNode.class);
            XMLEditorAddin._registerAutoIndent(XMLSourceNode.class);
            ContextMenu menu = EditorManager.getEditorManager().getContextMenu();
            if (menu != null) {
                menu.addContextMenuListener((ContextMenuListener)XMLEditorAddin.getCheckSyntaxController());
                menu.addContextMenuListener((ContextMenuListener)XMLEditorAddin.getPrettyPrintController());
            }
            if (_toRegister != null) {
                for (Class[] classes : _toRegister) {
                    EditorManager.getEditorManager().extend((EditorAddin)this, classes);
                }
                _toRegister.clear();
                _toRegister = null;
            }
        }
        TechnologyRegistry.getInstance().registerTechnology(XML_TECHNOLOGY_KEY, XMLEditorAddin.getTranslatedString("XML_TECH"), XMLEditorAddin.getTranslatedString("XML_TECH_DESC"));
        if (Ide.getIdeArgs().getCreateUI()) {
            ContextMenu editorMenu = EditorManager.getEditorManager().getContextMenu();
            ContextMenu explorerMenu = ExplorerManager.getExplorerManager().getContextMenu();
            XmlController.registerXmlController(new XmlEditorController(XmlUsage.LAYOUT_EDITOR), editorMenu);
            XmlController.registerXmlController(new XmlExplorerController(XmlUsage.EXPLORER), explorerMenu);
            XmlController.registerXmlController(new XmlExplorerController(XmlUsage.XML_CODE_EXPLORER), explorerMenu);
            XmlController.registerXmlController(new CodeEditorXmlController(), editorMenu);
        }
        if ((mgr = HistoryManager.getHistoryManager()) != null) {
            try {
                mgr.registerHistorian(TextNodeHistorian.class, XMLSourceNode.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Ide.getIdeArgs().getCreateUI()) {
            DataTransferPluginRegistry.getGlobalInstance().registerFactory(TransferUtils.createReflectivePluginFactory(FileListDataTransferPlugin.class));
            DataTransferPluginRegistry.getGlobalInstance().registerFactory(TransferUtils.createReflectivePluginFactory(Palette2ToXmlKeyPlugin.class));
            Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)XMLEditorAddin.getPrettyPrintController());
            Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)XMLEditorAddin.getCheckSyntaxController());
            Menubar menubar = Ide.getMenubar();
            menubar.add((Component)menubar.createMenuItem((ToggleAction)PASTE_SPECIAL_ACTION, WEIGHT_EDIT_PASTE_SPECIAL), MenuManager.getJMenu((String)"Edit"), MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
            PASTE_SPECIAL_ACTION.addController(new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    return false;
                }

                public boolean update(IdeAction action, Context context) {
                    action.setEnabled(false);
                    return false;
                }
            });
            XMLEditorAddin.registerPreferredLayoutListener(XMLSourceNode.class, CodeEditor.class);
        }
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent e) {
                Ide.removeIdeListener((IdeListener)this);
            }

            public void mainWindowOpened(IdeEvent e) {
            }

            public void mainWindowClosing(IdeEvent e) {
            }
        });
    }

    public boolean isDefault() {
        return true;
    }

    public Class getEditorClass() {
        return CodeEditor.class;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this._menuSpec == null) {
            String translatedName = XMLEditorAddin.getTranslatedString(KEY_XML_EDITOR);
            String name = StringUtil.stripMnemonic((String)translatedName);
            int keyCode = StringUtils.getMnemonicKeyCode((String)translatedName);
            Integer mnemonic = new Integer(keyCode);
            Image i = ImageUtils.getImageResource(XMLEditorAddin.class, (String)_IMAGE);
            ImageIcon icon = new ImageIcon(i);
            this._menuSpec = new MenuSpec(name, mnemonic, (Icon)icon);
        }
        return this._menuSpec;
    }

    public List createPlugins(Context ideContext) {
        JDevXmlContext xmlContext;
        JDevXmlCodeEditorGui codeGui;
        Node o = ideContext.getNode();
        if (o != null && _registeredClasses.contains(o.getClass()) && (codeGui = XMLEditorAddin._getCodeEditorGui(xmlContext = this._getXmlContext(ideContext))) != null) {
            return codeGui.createEditorPlugins();
        }
        return Collections.EMPTY_LIST;
    }

    public static CheckSyntaxController getCheckSyntaxController() {
        if (_checkSyntaxController == null) {
            _checkSyntaxController = new CheckSyntaxController();
        }
        return _checkSyntaxController;
    }

    public static PrettyPrintController getPrettyPrintController() {
        if (_prettyPrintController == null) {
            _prettyPrintController = new PrettyPrintController();
        }
        return _prettyPrintController;
    }

    public static LocateInStructureController getLocateInStructureController() {
        if (_locateInStructureController == null) {
            _locateInStructureController = new LocateInStructureController();
        }
        return _locateInStructureController;
    }

    public static void setSettingsPanelNameForJ2EE() {
        _settingsNavigable.setShortLabel(XMLEditorAddin.getTranslatedString("XMLADDIN.OPTIONS_NAME_J2EE"));
    }

    public static String getTranslatedString(String key) {
        try {
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.xml.addin.resource.XMLAddinBundle", Locale.getDefault());
            return b.getString(key);
        }
        catch (Exception e) {
            return "???" + key + "???";
        }
    }

    private static void _registerAutoIndent(Class clazz) {
        XMLEditorAddin.getPrettyPrintController().registerForAutoIndent(clazz);
        NavigatorManager mgr = NavigatorManager.getWorkspaceNavigatorManager();
        if (mgr != null) {
            mgr.addContextMenuListener(XMLEditorAddin.getPrettyPrintController().getNavigatorContextMenuListener(), clazz);
        }
    }

    private void _registerSettings() {
        ClientSetting setting = ClientSetting.findOrCreate((String)IDE_XMLEF_EXTENSION_ID);
        XMLEditorOptions options = (XMLEditorOptions)setting.getData(XMLEditorOptions.KEY_SETTINGS);
        if (options == null) {
            options = new XMLEditorOptions();
            setting.putData(XMLEditorOptions.KEY_SETTINGS, (Copyable)options);
        }
        if (Ide.getIdeArgs().getCreateUI()) {
            EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.END_TAG", options.getEndTagCompletion());
            EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.REQUIRED_ATTRIBUTE_INSERTION", options.getRequiredAttributeInsertion());
            EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.SMART_INDENT", options.getSmartIndent());
            _settingsNavigable = new Navigable(XMLEditorAddin.getTranslatedString(_KEY_OPTIONS_NAME), XMLEditorOptionsPanel.class);
            CodeEditorAddin addin = (CodeEditorAddin)AddinManager.getAddinManager().getAddin(CodeEditorAddin.class);
            if (addin != null) {
                Navigable editorNavigable = addin.getEditorNavigable();
                editorNavigable.addChildNavigable(_settingsNavigable);
            } else {
                ClientSetting.registerUI((Navigable)_settingsNavigable);
            }
        }
    }

    private static JDevXmlCodeEditorGui _getCodeEditorGui(JDevXmlContext context) {
        XmlGui gui = XMLEditorAddin._getGui(context, XmlUsage.XML_CODE_EDITOR);
        if (gui instanceof JDevXmlCodeEditorGui) {
            return (JDevXmlCodeEditorGui)gui;
        }
        return null;
    }

    private static XmlGui _getGui(JDevXmlContext xmlContext, XmlUsage usage) {
        XmlGui gui = null;
        if (xmlContext != null) {
            gui = xmlContext.getGui(usage);
        }
        return gui;
    }

    private JDevXmlContext _getXmlContext(Context c) {
        if (c == null) {
            return null;
        }
        return JDevXmlContext.getXmlContext(c);
    }

    private void _updatePalette(Context c) {
    }

    public static Icon getIcon(String icon) {
        if (NODE_ICON.equals(icon)) {
            if (_sNodeIcon == null) {
                Image nodeImage = ImageUtils.getImageResource(XMLEditorAddin.class, (String)NODE_ICON);
                _sNodeIcon = new ImageIcon(nodeImage);
            }
            return _sNodeIcon;
        }
        if (ATTR_ICON.equals(icon)) {
            if (_sAttrIcon == null) {
                Image attrImage = ImageUtils.getImageResource(XMLEditorAddin.class, (String)ATTR_ICON);
                _sAttrIcon = new ImageIcon(attrImage);
            }
            return _sAttrIcon;
        }
        return null;
    }

    static {
        WEIGHT_EDIT_PASTE_SPECIAL = MenuConstants.increment((float)MenuConstants.WEIGHT_EDIT_PASTE);
        _HELP_INFO = new HelpInfo("f1_uixxmleditor_html");
        _sClipboardHandler = new ClipboardActivationHandler();
        _sIconArb = new IconsArb();
        _registeredClasses = new ArrayList(2);
        _registeredExtensions = new ArrayList(2);
        _helpSupport = new XMLHelpSupport();
        _layoutListener = new LayoutListener();
        PASTE_SPECIAL_ACTION = IdeAction.get((int)PASTE_SPECIAL_CMD_ID, null, (String)XMLEditorAddin.getTranslatedString(_KEY_PASTE_SPECIAL), null, (Integer)new Integer(83), null, null, (boolean)false);
    }

    private static class LayoutListener
    implements PreferredLayoutListener {
        private LayoutListener() {
        }

        public void onInitializeLayout(PreferredLayoutEvent e) {
            Layout layout = e.getLayout();
            layout.setProperty("Layout.ShowInspector", Boolean.TRUE.toString());
            layout.setProperty("Layout.ShowPalette2", Boolean.TRUE.toString());
        }

        public void onPreferredLayoutActivate(PreferredLayoutEvent e) {
        }
    }

    private static class IconsArb
    extends ArrayResourceBundle {
        private final Object[] _contents = new Object[]{"icons/node.gif"};

        private IconsArb() {
        }

        protected Object[] getContents() {
            return this._contents;
        }
    }

    private static class ClipboardActivationHandler
    extends IdeAdapter
    implements IdeActivationListener {
        private ClipboardActivationHandler() {
        }

        public void activated(IdeActivationEvent e) {
            AWTClipboardManager.getClipboardManager().setApplicationActive(true);
        }

        public void deactivated(IdeActivationEvent e) {
            AWTClipboardManager.getClipboardManager().setApplicationActive(false);
        }

        public void mainWindowOpened(IdeEvent e) {
            AWTClipboardManager.getClipboardManager().setApplicationActive(true);
        }

        public void mainWindowClosing(IdeEvent e) {
            AWTClipboardManager.getClipboardManager().setApplicationActive(false);
        }
    }

    private class Listener
    implements EditorListener {
        private Editor _lastEditor;

        private Listener() {
        }

        public void editorOpened(Editor editor) {
            Context c = editor.getContext();
            if (c == null) {
                return;
            }
            Node d = c.getNode();
            if (d != null && _registeredClasses.contains(d.getClass()) && editor instanceof CodeEditor) {
                CodeEditor ce = (CodeEditor)editor;
                ce.setHelpInfo(_HELP_INFO);
                ce.addHelpableProvider((HelpableProvider)_helpSupport);
            }
        }

        public void editorActivated(Editor editor) {
            boolean needPaletteUpdate = editor != this._lastEditor;
            this._lastEditor = editor;
            Context c = editor.getContext();
            if (c != null && needPaletteUpdate) {
                XMLEditorAddin.this._updatePalette(c);
            }
        }

        public void editorClosed(Editor editor) {
            if (this._lastEditor == editor) {
                this._lastEditor = null;
            }
        }

        public void editorDeactivated(Editor editor) {
        }
    }
}

