/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.addin.XMLEditorAddin;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.util.JDevUtils;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.view.View;

class PrettyPrintController
implements ContextMenuListener,
Controller,
DynamicMenuListener {
    private static final String KEY_PRETTY_PRINT = "XMLADDIN.PRETTY_PRINT_MENU";
    private static final String KEY_PRETTY_PRINT_UNDO = "XMLADDIN.PRETTY_PRINT_UNDO";
    private JMenuItem _prettyPrintMenu;
    private JMenuItem _dynamicMenu;
    private final ContextMenuListener _navMenuListener = new NavContextMenuListener();
    private static final HashSet _classes = new HashSet();

    PrettyPrintController() {
    }

    public final void registerForAutoIndent(Class c) {
        if (XMLSourceNode.isXmlSourceNodeSubclass(c)) {
            _classes.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == CodeEditorController.FORMAT_CMD_ID) {
            if (action.isEnabled()) {
                Collection<Object> xmlContexts = Collections.emptyList();
                Project project = context.getProject();
                Node node = context.getNode();
                if (node != null) {
                    if (node instanceof XMLSourceNode) {
                        xmlContexts = Collections.singleton(((XMLSourceNode)node).getXmlContext(project));
                    }
                } else {
                    Element[] selection = context.getSelection();
                    if (selection != null) {
                        xmlContexts = new ArrayList(selection.length);
                        for (int i = 0; i < selection.length; ++i) {
                            if (!(selection[i] instanceof XMLSourceNode)) continue;
                            XMLSourceNode xMLSourceNode = (XMLSourceNode)selection[i];
                            xmlContexts.add((Object)xMLSourceNode.getXmlContext(project));
                        }
                    }
                }
                if (!xmlContexts.isEmpty()) {
                    String undoLabel = XMLEditorAddin.getTranslatedString(KEY_PRETTY_PRINT_UNDO);
                    CommandProcessor.getInstance().beginTrans(undoLabel);
                    try {
                        for (JDevXmlContext jDevXmlContext : xmlContexts) {
                            this._doNewPrettyPrint(undoLabel, jDevXmlContext);
                        }
                    }
                    finally {
                        CommandProcessor.getInstance().endTrans();
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        boolean handled = false;
        int cmdId = action.getCommandId();
        if (cmdId == CodeEditorController.FORMAT_CMD_ID) {
            Node node = context.getNode();
            if (node != null && node instanceof XMLSourceNode) {
                handled = true;
            } else {
                Element[] selection = context.getSelection();
                if (selection != null) {
                    for (int i = 0; i < selection.length; ++i) {
                        if (!(selection[i] instanceof XMLSourceNode)) continue;
                        handled = true;
                        break;
                    }
                }
            }
            boolean[] status = this._checkStatus(context);
            action.setEnabled(status[0] && status[1]);
        }
        return handled;
    }

    public void menuWillShow(ContextMenu popup) {
        View view = popup.getContext().getView();
        if (view instanceof CodeEditor) {
            this._menuWillShowImpl(popup);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public JComponent[] gatherDynamicActions(Context context) {
        if (context.getNode() instanceof XMLSourceNode && context.getView() instanceof CodeEditor) {
            if (this._dynamicMenu == null) {
                this._dynamicMenu = this._buildMenu(context.getView().getContextMenu());
            }
            return new JComponent[]{this._dynamicMenu};
        }
        return null;
    }

    public ContextMenuListener getNavigatorContextMenuListener() {
        return this._navMenuListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doNewPrettyPrint(String undoLabel, JDevXmlContext xmlContext) {
        XmlModel model = xmlContext.getSourceModel();
        DomModel domModel = model.getDomModel();
        org.w3c.dom.Node reformatRoot = null;
        int selStart = -1;
        int selEnd = -1;
        CodeEditor ce = JDevUtils.getCodeEditor(xmlContext);
        if (ce != null) {
            selStart = ce.getSelectionStart();
            selEnd = ce.getSelectionEnd();
        }
        org.w3c.dom.Node cursorNode = null;
        int cursorDelta = 0;
        model.acquireReadLock();
        try {
            cursorNode = domModel.getNodeAtOffset(selStart);
            if (cursorNode != null) {
                org.w3c.dom.Node endNode;
                cursorDelta = selStart - domModel.getTextOffset(DomPositionFactory.before((org.w3c.dom.Node)cursorNode));
                if (selStart != selEnd && (endNode = domModel.getNodeAtOffset(selEnd)) != null) {
                    reformatRoot = DomUtils.lowestCommonAncestor((org.w3c.dom.Node)cursorNode, (org.w3c.dom.Node)endNode);
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
        domModel.reformatSubtree(undoLabel, reformatRoot);
        this._updateCodeEditorSelection(ce, model, cursorNode, cursorDelta, reformatRoot);
        xmlContext.getIdeDocument().postReformatHook(xmlContext);
        this._updateCodeEditorSelection(ce, model, cursorNode, cursorDelta, reformatRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateCodeEditorSelection(CodeEditor ce, XmlModel model, org.w3c.dom.Node cursorNode, int cursorDelta, org.w3c.dom.Node reformatRoot) {
        if (ce != null) {
            model.acquireReadLock();
            try {
                if (reformatRoot != null && !DomUtils.isDocument((org.w3c.dom.Node)reformatRoot)) {
                    if (model.isInModelDocumentHierarchy(reformatRoot)) {
                        ce.setSelectionStart(model.getTextOffset(DomPositionFactory.before((org.w3c.dom.Node)reformatRoot)));
                        ce.setSelectionEnd(model.getTextOffset(DomPositionFactory.after((org.w3c.dom.Node)reformatRoot)));
                    }
                } else if (model.isInModelDocumentHierarchy(cursorNode)) {
                    ce.setCaretPosition(model.getTextOffset(DomPositionFactory.before((org.w3c.dom.Node)cursorNode)) + cursorDelta);
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
    }

    private boolean _supportedDocument(Node node) {
        return _classes.contains(node.getClass());
    }

    private void _menuWillShowImpl(ContextMenu popup) {
        Context context = popup.getContext();
        boolean[] status = this._checkStatus(context);
        boolean shown = status[0];
        if (shown) {
            if (this._prettyPrintMenu == null) {
                this._prettyPrintMenu = this._buildMenu(popup);
            }
            popup.add((Component)this._prettyPrintMenu, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
    }

    private boolean[] _checkStatus(Context context) {
        boolean shown = false;
        boolean enabled = false;
        Node node = context.getNode();
        if (node != null) {
            shown = this._supportedDocument(node);
            enabled = !node.isReadOnly();
        } else {
            Element[] selection = context.getSelection();
            if (selection != null && selection.length > 1) {
                boolean foundSupported = false;
                boolean foundUnsupported = false;
                boolean foundReadOnly = false;
                for (int i = 0; i < selection.length; ++i) {
                    boolean supportedDoc;
                    Element elem = selection[i];
                    boolean bl = supportedDoc = elem instanceof Node && this._supportedDocument((Node)elem);
                    if (supportedDoc) {
                        foundSupported = true;
                        foundReadOnly |= ((Node)elem).isReadOnly();
                        continue;
                    }
                    foundUnsupported = true;
                }
                shown = foundSupported;
                enabled = shown && !foundUnsupported && !foundReadOnly;
            }
        }
        return new boolean[]{shown, enabled};
    }

    private synchronized JMenuItem _buildMenu(ContextMenu mgr) {
        String translatedString = XMLEditorAddin.getTranslatedString(KEY_PRETTY_PRINT);
        String name = StringUtils.stripMnemonic((String)translatedString);
        Integer mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)translatedString));
        IdeAction action = IdeAction.get((int)CodeEditorController.FORMAT_CMD_ID, null, (String)name, (String)null, (Integer)mnemonic, null, null, (boolean)true);
        action.addController((Controller)this);
        return mgr.createMenuItem((ToggleAction)action, 1.0f);
    }

    private class NavContextMenuListener
    implements ContextMenuListener {
        private NavContextMenuListener() {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public void menuWillShow(ContextMenu popup) {
            PrettyPrintController.this._menuWillShowImpl(popup);
        }
    }
}

