/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.handler.classpath;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.JdevClassLocatorFactory;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;

public final class ClasspathHandlerFacade {
    private static ThreadLocal<Project> CONTEXT_PROJECT = new ThreadLocal();
    private static final Logger LOG = Logger.getLogger("oracle.jdeveloper.handler");
    private static final Map<Project, Pair<Collection<JLibrary>, BaseClassLocator>> LOCATORS = new WeakHashMap<Project, Pair<Collection<JLibrary>, BaseClassLocator>>();

    private ClasspathHandlerFacade() {
    }

    public static void setThreadContextProject(Project project) {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Can only override for non-ui event threads");
        }
        if (project == null) {
            throw new IllegalArgumentException("Project cannot be null, should you be using clearThreadContextProject?");
        }
        CONTEXT_PROJECT.set(project);
        LOG.log(Level.FINE, "Setting classpath: project thread context to " + project.getShortLabel() + " on thread " + Thread.currentThread().getName());
    }

    public static void clearThreadContextProject() {
        Project project = CONTEXT_PROJECT.get();
        CONTEXT_PROJECT.set(null);
        LOG.log(Level.FINE, "Clearing classpath: project thread context on thread " + Thread.currentThread().getName() + project != null ? " was " + project.getShortLabel() : " not set");
    }

    public static Project getThreadContextProject() {
        return CONTEXT_PROJECT.get();
    }

    public static URL resolveClasspathURL(URL u) throws IOException {
        Project project = ClasspathHandlerFacade.getThreadContextProject();
        if (project == null) {
            project = Ide.getActiveProject();
        }
        if (project == null) {
            throw new IOException("No active project context found");
        }
        LOG.log(Level.FINEST, "Current project is " + project.getShortLabel());
        return ClasspathHandlerFacade.resolveClasspathURL(project, u);
    }

    public static URL resolveClasspathURL(Project project, URL u) {
        PathsConfiguration pathsConfiguration;
        URL converted;
        String path = u.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        if ((converted = (pathsConfiguration = PathsConfiguration.getInstance((Project)project)).getProjectSourcePath().toBoundURL(path)) == null) {
            JLibrary[] libraries;
            List<JLibrary> libCol;
            Pair pair = LOCATORS.get(project);
            if (pair == null) {
                pair = new Pair(null, null);
                LOCATORS.put(project, (Pair<Collection<JLibrary>, BaseClassLocator>)pair);
            }
            if (!((Object)(libCol = Arrays.asList(libraries = JProjectLibraries.getInstance((PropertyStorage)project).getLibraries()))).equals(pair.getFirst())) {
                pair.setSecond((Object)JdevClassLocatorFactory.getLibraryLocator((Library[])libraries));
                pair.setFirst(libCol);
            }
            converted = ((BaseClassLocator)pair.getSecond()).getResourceURL(path);
        }
        return converted;
    }
}

