/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.progress;

import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.UIManager;

class TruncatedFileLabel
extends JLabel {
    TruncatedFileLabel() {
    }

    @Override
    public void setText(String text) {
        int sepIdx;
        Font font;
        FontMetrics fm;
        int lineWid;
        if (text == null) {
            super.setText(text);
        }
        if ((lineWid = (fm = this.getFontMetrics(font = UIManager.getDefaults().getFont("Label.font"))).stringWidth(text)) < this.getBounds().width) {
            super.setText(text);
        }
        if ((sepIdx = text.indexOf(File.separatorChar)) != -1) {
            String theToken;
            int tokWidth;
            int ellipsisWidth;
            File f = new File(text);
            int fnameWidth = fm.stringWidth(f.getName() + File.separator);
            int remainingSpace = this.getBounds().width - (fnameWidth + (ellipsisWidth = fm.stringWidth("...")));
            if (remainingSpace <= 0) {
                super.setText(text);
            }
            String path = f.getParent();
            StringTokenizer tok = new StringTokenizer(path, File.separator);
            StringBuffer fullString = new StringBuffer(path.length());
            int widthSoFar = 0;
            while (tok.hasMoreTokens() && widthSoFar + (tokWidth = fm.stringWidth(theToken = tok.nextToken() + File.separator)) < remainingSpace) {
                fullString.append(theToken);
                widthSoFar += tokWidth;
            }
            fullString.ensureCapacity(3 + fnameWidth);
            fullString.append("...");
            fullString.append(File.separator);
            fullString.append(f.getName());
            super.setText(fullString.toString());
        } else {
            super.setText(text);
        }
    }
}

