/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bm.util.ResourcePicker;
import oracle.ide.Ide;
import oracle.ide.controls.progress.SteppedProgressPanel;
import oracle.ide.util.SwingWorker;

public class SteppedProgressDialog {
    private SteppedProgressPanel m_component;
    private SwingWorker m_worker;
    private JButton m_cancelOperationButton;
    private JEWTDialog m_dialog;
    private boolean m_isAborted = false;

    public SteppedProgressDialog(SteppedProgressPanel component, SwingWorker worker) {
        this.m_component = component;
        this.m_worker = worker;
    }

    public void showDialog(String title) {
        JEWTDialog jd = this.createDialog(title, this.m_component);
        jd.pack();
        jd.runDialog();
        this.m_dialog.dispose();
    }

    private JEWTDialog createDialog(String title, SteppedProgressPanel c) {
        this.m_dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
        this.m_dialog.setContent(c.getComponent());
        this.m_dialog.setDefaultCloseOperation(0);
        WindowAdapter wa = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                SteppedProgressDialog.this.dialogWasDismissed();
            }
        };
        this.m_dialog.addWindowListener((WindowListener)wa);
        c.setWindowListener(wa);
        this.m_dialog.setButtonMask(0);
        this.m_cancelOperationButton = new JButton((String)UIManager.get("OptionPane.cancelButtonText"));
        this.m_dialog.addCustomButton((Component)this.m_cancelOperationButton);
        this.m_cancelOperationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SteppedProgressDialog.this.cancelWasClicked();
            }
        });
        c.setDialog(this.m_dialog);
        return this.m_dialog;
    }

    private void dialogWasDismissed() {
        if (this.m_component.isCancelled()) {
            return;
        }
        final JDialog blocker = new JDialog((Frame)Ide.getMainWindow());
        blocker.getContentPane().setLayout(new BorderLayout());
        blocker.getContentPane().add((Component)this.m_component.getMessageDisplayLabel(), "Center");
        blocker.setDefaultCloseOperation(0);
        this.m_component.setCancelled(true);
        this.m_component.getMessageDisplayLabel().setText(ResourcePicker.getPicker(SteppedProgressDialog.class).getString("ProgressDialog.Cancelling"));
        blocker.pack();
        blocker.setLocationRelativeTo((Component)Ide.getMainWindow());
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SteppedProgressDialog.this.m_worker.get();
                }
                finally {
                    blocker.setVisible(false);
                    blocker.dispose();
                }
            }
        });
        t.start();
        blocker.setVisible(true);
    }

    private void cancelWasClicked() {
        this.m_component.setCancelled(true);
        this.m_cancelOperationButton.setEnabled(false);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SteppedProgressDialog.this.m_worker.get();
                }
                finally {
                    SteppedProgressDialog.this.m_dialog.setVisible(false);
                }
            }
        });
        t.start();
    }

    public boolean wasSuccessful() {
        if (this.m_isAborted) {
            return false;
        }
        return this.m_component.isSuccessful();
    }
}

