/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.progress;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Writer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.bm.util.ResourcePicker;
import oracle.ide.controls.progress.SteppedProgressDialog;
import oracle.ide.controls.progress.SteppedProgressErrorHandler;
import oracle.ide.controls.progress.SteppedProgressMonitor;
import oracle.ide.controls.progress.SteppedProgressPanel;
import oracle.ide.util.Assert;
import oracle.ide.util.NestedException;
import oracle.ide.util.SafeActionListener;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.MessageDialog;

class SteppedProgressComponent
extends JPanel
implements SteppedProgressMonitor {
    private static final int ICON_SIZE = 16;
    private static final int MINIMUM_WIDTH = 350;
    private static final int LEFT_PADDING = 20;
    private JLabel m_hintLabel;
    private JLabel m_msgDisplayLabel;
    private JLabel[] m_taskLabels;
    private Icon m_emptyIcon;
    private Icon m_currentIcon;
    private Icon m_doneIcon;
    private Icon m_failedIcon;
    private JProgressBar m_progressBar;
    private JLabel m_detailsLabel;
    private JScrollPane m_detailsPane;
    private JTextArea m_detailsArea;
    private JButton m_detailsButton;
    private SteppedProgressPanel m_owner;
    private int m_lastCompletedTask = -1;
    private boolean m_isSuccessful = false;
    private boolean m_cancelled;
    private SteppedProgressErrorHandler m_errorHandler;
    private boolean m_isClosedOnFinish = true;
    private Writer m_detailsWriter = null;

    SteppedProgressComponent(SteppedProgressPanel owner) {
        this.m_owner = owner;
        this.doCreate();
        this.buildLayout();
    }

    @Override
    public void setDialogVisibleAtCompletion(boolean remainOnscreen) {
        this.m_isClosedOnFinish = !remainOnscreen;
    }

    JLabel getMessageDisplayLabel() {
        return this.m_msgDisplayLabel;
    }

    void dialogRepack() {
        if (this.m_owner.getDialog() != null) {
            this.m_owner.getDialog().pack();
        }
    }

    boolean isSuccessful() {
        return this.m_isSuccessful;
    }

    private void doCreate() {
        this.m_hintLabel = new JLabel(this.m_owner.getHint());
        this.m_msgDisplayLabel = new JLabel("");
        this.m_taskLabels = new JLabel[this.m_owner.getTaskCount()];
        for (int i2 = 0; i2 < this.m_owner.getTaskCount(); ++i2) {
            this.m_taskLabels[i2] = new JLabel();
            this.m_taskLabels[i2].setText(this.m_owner.getTaskDescription(i2));
            this.m_taskLabels[i2].setIcon(this.getEmptyIcon());
        }
        this.m_msgDisplayLabel.setText(" ");
        this.m_progressBar = new JProgressBar();
        this.m_detailsButton = new JButton();
        this.m_detailsButton.setText(this.m_owner.getRes().getString("SteppedProgress.Details.show"));
        this.m_detailsButton.setMnemonic(this.m_owner.getRes().getString("SteppedProgress.Details.showMnemonic").charAt(0));
        this.m_detailsLabel = new JLabel(this.m_owner.getRes().getString("SteppedProgress.Details.label"));
        this.m_detailsLabel.setDisplayedMnemonic(this.m_owner.getRes().getString("SteppedProgress.Details.mnemonic").charAt(0));
        this.m_detailsArea = new JTextArea();
        this.m_detailsArea.setRows(5);
        this.m_detailsArea.setEditable(false);
        this.m_detailsArea.setWrapStyleWord(true);
        this.m_detailsArea.setLineWrap(true);
        this.m_detailsLabel.setLabelFor(this.m_detailsArea);
        this.m_detailsLabel.setVisible(false);
        this.m_progressBar.setVisible(false);
        this.m_detailsPane = new JScrollPane(this.m_detailsArea);
        this.m_detailsPane.setVisible(false);
        this.m_detailsButton.addActionListener(new SafeActionListener(){

            @Override
            public void doActionPerformed(ActionEvent e) {
                SteppedProgressComponent.this.detailsButtonClicked();
            }
        });
        this.m_detailsButton.setVisible(false);
    }

    private void detailsButtonClicked() {
        this.m_detailsPane.setVisible(!this.m_detailsPane.isVisible());
        this.m_detailsLabel.setVisible(this.m_detailsPane.isVisible());
        if (this.m_detailsPane.isVisible()) {
            this.m_detailsButton.setText(this.m_owner.getRes().getString("SteppedProgress.Details.hide"));
            this.m_detailsButton.setMnemonic(this.m_owner.getRes().getString("SteppedProgress.Details.hideMnemonic").charAt(0));
            this.dialogRepack();
        } else {
            this.m_detailsButton.setText(this.m_owner.getRes().getString("SteppedProgress.Details.show"));
            this.m_detailsButton.setMnemonic(this.m_owner.getRes().getString("SteppedProgress.Details.showMnemonic").charAt(0));
            this.dialogRepack();
        }
    }

    private void buildLayout() {
        int row;
        Insets insets = new Insets(5, 5, 5, 5);
        Insets padInsets = new Insets(5, 20, 5, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_hintLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        for (row = 1; row < this.m_owner.getTaskCount() + 1; ++row) {
            this.add((Component)this.getTaskLabel(row - 1), new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 17, 2, padInsets, 0, 0));
        }
        this.add((Component)this.m_progressBar, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this.m_msgDisplayLabel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this.m_detailsButton, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this.m_detailsLabel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this.m_detailsPane, new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        JPanel padding = new JPanel();
        Dimension d = new Dimension(350, 0);
        padding.setPreferredSize(d);
        padding.setMinimumSize(d);
        this.add((Component)padding, new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setProgressBarVisible(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedProgressComponent.this.m_progressBar.setVisible(b);
                SteppedProgressComponent.this.dialogRepack();
            }
        });
    }

    private boolean isDetailsVisible() {
        return this.m_detailsButton.isVisible();
    }

    @Override
    public void setDetailsVisible(final boolean isVisible) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedProgressComponent.this.m_detailsButton.setVisible(isVisible);
                if (!isVisible) {
                    SteppedProgressComponent.this.m_detailsLabel.setVisible(false);
                    SteppedProgressComponent.this.m_detailsPane.setVisible(false);
                }
                SteppedProgressComponent.this.dialogRepack();
            }
        });
    }

    public boolean isProgressBarVisible() {
        return this.m_progressBar.isVisible();
    }

    private JLabel getTaskLabel(int i2) {
        return this.m_taskLabels[i2];
    }

    private Icon getEmptyIcon() {
        if (this.m_emptyIcon == null) {
            this.m_emptyIcon = new EmptyIcon();
        }
        return this.m_emptyIcon;
    }

    private Icon getCurrentIcon() {
        if (this.m_currentIcon == null) {
            this.m_currentIcon = this.m_owner.getRes().getImage("SteppedProgress.Image.currentTask");
        }
        return this.m_currentIcon;
    }

    private Icon getDoneIcon() {
        if (this.m_doneIcon == null) {
            this.m_doneIcon = this.m_owner.getRes().getImage("SteppedProgress.Image.doneTask");
        }
        return this.m_doneIcon;
    }

    private Icon getFailedIcon() {
        if (this.m_failedIcon == null) {
            this.m_failedIcon = this.m_owner.getRes().getImage("SteppedProgress.Image.failedTask");
        }
        return this.m_failedIcon;
    }

    @Override
    public void operationStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedProgressComponent.this.m_msgDisplayLabel.setText(" ");
            }
        });
    }

    @Override
    public void taskStarted(int seq) {
        SwingUtilities.invokeLater(new IconSettingRunnable(this.getTaskLabel(seq), this.getCurrentIcon()));
    }

    @Override
    public void taskEnded(int seq) {
        SwingUtilities.invokeLater(new IconSettingRunnable(this.getTaskLabel(seq), this.getDoneIcon()));
        this.m_lastCompletedTask = seq;
    }

    @Override
    public void operationEnded() {
        this.m_isSuccessful = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageDialog.information((Component)SteppedProgressComponent.this, (Object)SteppedProgressComponent.this.m_owner.getFinishedMessage(), (String)SteppedProgressComponent.this.m_owner.getRes().getString("SteppedProgressDialog.Complete"), null);
                SteppedProgressComponent.this.m_progressBar.setVisible(false);
                SteppedProgressComponent.this.dialogRepack();
                SteppedProgressComponent.this.m_owner.finish(SteppedProgressComponent.this.m_isClosedOnFinish);
            }
        });
    }

    @Override
    public void setErrorHandler(SteppedProgressErrorHandler handler) {
        this.m_errorHandler = handler;
    }

    private SteppedProgressErrorHandler getErrorHandler() {
        if (this.m_errorHandler == null) {
            this.m_errorHandler = new DefaultErrorHandler();
        }
        return this.m_errorHandler;
    }

    @Override
    public void operationFailed(final Throwable t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedProgressComponent.this.m_msgDisplayLabel.setText(SteppedProgressComponent.this.m_owner.getFailedMessage());
                for (int i2 = SteppedProgressComponent.this.m_lastCompletedTask + 1; i2 < SteppedProgressComponent.this.m_owner.getTaskCount(); ++i2) {
                    SteppedProgressComponent.this.getTaskLabel(i2).setIcon(SteppedProgressComponent.this.getFailedIcon());
                }
                SteppedProgressComponent.this.getErrorHandler().handleError(t, SteppedProgressComponent.this);
                SteppedProgressComponent.this.m_progressBar.setVisible(false);
                SteppedProgressComponent.this.dialogRepack();
                SteppedProgressComponent.this.m_owner.finish(SteppedProgressComponent.this.m_isClosedOnFinish);
            }
        });
    }

    @Override
    public void start() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedProgressComponent.this.m_progressBar.setValue(SteppedProgressComponent.this.getMinimum());
                SteppedProgressComponent.this.m_detailsArea.setText("");
            }
        });
    }

    @Override
    public void finish() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedProgressComponent.this.m_progressBar.setVisible(false);
                SteppedProgressComponent.this.dialogRepack();
            }
        });
    }

    @Override
    public boolean isCancelled() {
        return this.m_cancelled;
    }

    void setCancelled(boolean isCancelled) {
        this.m_cancelled = isCancelled;
        if (this.m_cancelled) {
            this.displayMessage(ResourcePicker.getPicker(SteppedProgressComponent.class).getString("ProgressDialog.Cancelling"));
        }
    }

    @Override
    public void logMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!SteppedProgressComponent.this.isDetailsVisible()) {
                    SteppedProgressComponent.this.setDetailsVisible(true);
                }
                SteppedProgressComponent.this.m_detailsArea.append(message);
                SteppedProgressComponent.this.m_detailsArea.append("\n");
            }
        });
    }

    @Override
    public Writer getDetailsWriter() {
        if (this.m_detailsWriter == null) {
            this.m_detailsWriter = new TextComponentWriter(this.m_detailsArea);
        }
        return this.m_detailsWriter;
    }

    @Override
    public void displayMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedProgressComponent.this.m_msgDisplayLabel.setText(message);
            }
        });
    }

    @Override
    public void setMinimum(final int m) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedProgressComponent.this.m_progressBar.setMinimum(m);
            }
        });
    }

    @Override
    public int getMinimum() {
        return this.m_progressBar.getMinimum();
    }

    @Override
    public void setMaximum(final int m) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedProgressComponent.this.m_progressBar.setMaximum(m);
            }
        });
    }

    @Override
    public int getMaximum() {
        return this.m_progressBar.getMaximum();
    }

    @Override
    public void setProgress(final int p) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SteppedProgressComponent.this.m_progressBar.setValue(p);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getProgress() {
        return this.m_progressBar.getValue();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void showDialog(Component parent, final String title, SwingWorker worker) {
        final SteppedProgressDialog spd = new SteppedProgressDialog(this.m_owner, worker);
        if (SwingUtilities.isEventDispatchThread()) {
            spd.showDialog(title);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        spd.showDialog(title);
                    }
                });
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }
    }

    private class IconSettingRunnable
    implements Runnable {
        private Icon m_icon;
        private JLabel m_label;

        private IconSettingRunnable(JLabel l, Icon i2) {
            this.m_icon = i2;
            this.m_label = l;
        }

        @Override
        public void run() {
            this.m_label.setIcon(this.m_icon);
        }
    }

    private class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    private class TextComponentWriter
    extends Writer {
        private final JTextComponent m_textComponent;

        public TextComponentWriter(JTextComponent txt) {
            this.m_textComponent = txt;
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String s = new String(cbuf, off, len);
            this.write(s);
        }

        @Override
        public void write(final String str) throws IOException {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        TextComponentWriter.this.m_textComponent.getDocument().insertString(TextComponentWriter.this.m_textComponent.getCaretPosition(), str, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private class DefaultErrorHandler
    implements SteppedProgressErrorHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void handleError(Throwable t, Component c) {
            String exceptionMessage = t.getMessage();
            String title = "";
            if (t instanceof NestedException) {
                Throwable target;
                title = ((NestedException)t).getTitle();
                while (exceptionMessage != null && exceptionMessage.length() == 0 && (target = ((NestedException)t).getTarget()) != null) {
                    exceptionMessage = target.getMessage();
                    if (target instanceof NestedException) continue;
                    break;
                }
            }
            MessageDialog.error((Component)c, (Object)exceptionMessage, (String)title, null);
        }
    }
}

