/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultCaret;
import oracle.bm.util.ui.table.CellUtils;

public class StringEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private final JTextField m_textField;

    public StringEditor(JTextField textField) {
        if (textField == null) {
            throw new IllegalArgumentException("Missing text field for editor");
        }
        this.m_textField = textField;
        this.m_textField.addActionListener(this);
        this.m_textField.setCaret(new DefaultCaret());
    }

    public StringEditor() {
        this(new JTextField());
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_textField.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        CellUtils.setUpEditor(this.m_textField, table);
        this.setValue(this.m_textField, value);
        this.m_textField.selectAll();
        return this.m_textField;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.stopCellEditing();
    }

    protected void setValue(Component component, Object value) {
        ((JTextField)component).setText((String)value);
    }
}

