/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.plaf.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import oracle.bm.util.ui.TriStateCheckBox;
import oracle.bm.util.ui.TriStateModel;

public class PlasticXPTriStateCheckBoxIcon
implements Icon {
    private static final int SIZE = LookUtils.IS_LOW_RESOLUTION ? 13 : 15;

    @Override
    public int getIconWidth() {
        return SIZE;
    }

    @Override
    public int getIconHeight() {
        return SIZE;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        TriStateCheckBox cb = (TriStateCheckBox)c;
        TriStateModel model = (TriStateModel)cb.getModel();
        Graphics2D g2 = (Graphics2D)g;
        Object hint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawBorder(g2, model.isEnabled(), x, y, SIZE - 1, SIZE - 1);
        this.drawFill(g2, model.isPressed(), x + 1, y + 1, SIZE - 2, SIZE - 2);
        if (cb.getState() == TriStateModel.BOTH_STATE) {
            ColorUIResource baseFillColor = MetalLookAndFeel.getControlShadow();
            Paint paint = g2.getPaint();
            g2.setPaint(new GradientPaint(x + 2, y + 2, baseFillColor.brighter(), SIZE - 4, SIZE - 4, baseFillColor));
            g2.fillRect(x + 2, y + 2, SIZE - 4, SIZE - 4);
            g2.setPaint(paint);
        }
        if (model.isEnabled() && model.isArmed() && !model.isPressed()) {
            this.drawFocus(g2, x + 1, y + 1, SIZE - 3, SIZE - 3);
        }
        if (model.isSelected()) {
            this.drawCheck(g2, model.isEnabled(), x + 3, y + 3, SIZE - 7, SIZE - 7);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
    }

    private void drawBorder(Graphics2D g2, boolean enabled, int x, int y, int width, int height) {
        g2.setColor(enabled ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlDisabled());
        g2.drawRect(x, y, width, height);
    }

    private void drawCheck(Graphics2D g2, boolean enabled, int x, int y, int width, int height) {
        g2.setColor(enabled ? UIManager.getColor("CheckBox.check") : MetalLookAndFeel.getControlDisabled());
        int right = x + width;
        int bottom = y + height;
        int startY = y + height / 3;
        int turnX = x + width / 2 - 2;
        g2.drawLine(x, startY, turnX, bottom - 3);
        g2.drawLine(x, startY + 1, turnX, bottom - 2);
        g2.drawLine(x, startY + 2, turnX, bottom - 1);
        g2.drawLine(turnX + 1, bottom - 2, right, y);
        g2.drawLine(turnX + 1, bottom - 1, right, y + 1);
        g2.drawLine(turnX + 1, bottom, right, y + 2);
    }

    private void drawFill(Graphics2D g2, boolean pressed, int x, int y, int w, int h) {
        Color lowerRight;
        ColorUIResource upperLeft;
        if (pressed) {
            upperLeft = MetalLookAndFeel.getControlShadow();
            lowerRight = PlasticLookAndFeel.getControlHighlight();
        } else {
            upperLeft = PlasticLookAndFeel.getControl();
            lowerRight = PlasticLookAndFeel.getControlHighlight().brighter();
        }
        g2.setPaint(new GradientPaint(x, y, upperLeft, x + w, y + h, lowerRight));
        g2.fillRect(x, y, w, h);
    }

    private void drawFocus(Graphics2D g2, int x, int y, int width, int height) {
        g2.setPaint(new GradientPaint(x, y, PlasticLookAndFeel.getFocusColor().brighter(), width, height, PlasticLookAndFeel.getFocusColor()));
        g2.drawRect(x, y, width, height);
        g2.drawRect(x + 1, y + 1, width - 2, height - 2);
    }
}

