/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.plaf.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.plaf.metal.MetalLookAndFeel;
import oracle.bm.util.ui.TriStateCheckBox;
import oracle.bm.util.ui.TriStateModel;

public class PlasticTriStateCheckBoxIcon
implements Icon {
    protected static final int s_ICON_WIDTH = 13;
    protected static final int s_ICON_HEIGHT = 13;

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        TriStateCheckBox cb = (TriStateCheckBox)c;
        TriStateModel model = (TriStateModel)cb.getModel();
        if (model.isEnabled()) {
            if (cb.isBorderPaintedFlat()) {
                g.setColor(PlasticLookAndFeel.getControlDarkShadow());
                g.drawRect(x, y, width - 2, height - 2);
                g.setColor(PlasticLookAndFeel.getControlHighlight());
                g.fillRect(x + 1, y + 1, width - 3, height - 3);
            } else if (model.isPressed() && model.isArmed()) {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(x, y, width - 1, height - 1);
                PlasticTriStateCheckBoxIcon.drawPressed3DBorder(g, x, y, width, height);
            } else {
                PlasticTriStateCheckBoxIcon.drawFlush3DBorder(g, x, y, width, height);
            }
            g.setColor(MetalLookAndFeel.getControlInfo());
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawRect(x, y, width - 2, height - 2);
        }
        if (cb.getState() == TriStateModel.BOTH_STATE) {
            Color color = g.getColor();
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.fillRect(x + 1, y + 1, width - 3, height - 3);
            g.setColor(color);
        }
        if (model.isSelected()) {
            PlasticTriStateCheckBoxIcon.drawCheck(g, x, y);
        }
    }

    @Override
    public int getIconWidth() {
        return 13;
    }

    @Override
    public int getIconHeight() {
        return 13;
    }

    protected static void drawCheck(Graphics g, int x, int y) {
        g.translate(x, y);
        g.drawLine(3, 5, 3, 5);
        g.fillRect(3, 6, 2, 2);
        g.drawLine(4, 8, 9, 3);
        g.drawLine(5, 8, 9, 4);
        g.drawLine(5, 9, 9, 5);
        g.translate(-x, -y);
    }

    public static void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(PlasticLookAndFeel.getControlHighlight());
        PlasticTriStateCheckBoxIcon.drawRect(g, 1, 1, w - 2, h - 2);
        g.drawLine(0, h - 1, 0, h - 1);
        g.drawLine(w - 1, 0, w - 1, 0);
        g.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticTriStateCheckBoxIcon.drawRect(g, 0, 0, w - 2, h - 2);
        g.translate(-x, -y);
    }

    public static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        PlasticTriStateCheckBoxIcon.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawLine(1, 1, 1, h - 3);
        g.drawLine(1, 1, w - 3, 1);
        g.translate(-x, -y);
    }

    public static void drawRect(Graphics g, int x, int y, int w, int h) {
        g.fillRect(x, y, w + 1, 1);
        g.fillRect(x, y + 1, 1, h);
        g.fillRect(x + 1, y + h, w, 1);
        g.fillRect(x + w, y + 1, 1, h);
    }
}

