/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.plaf.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import oracle.bm.util.ui.TriStateCheckBox;
import oracle.bm.util.ui.TriStateModel;

public class MotifTriStateCheckBoxIcon
implements Icon {
    static final int csize = 13;
    private Color control = UIManager.getColor("control");
    private Color foreground = UIManager.getColor("CheckBox.foreground");
    private Color shadow = UIManager.getColor("controlShadow");
    private Color highlight = UIManager.getColor("controlHighlight");
    private Color lightShadow = UIManager.getColor("controlLightShadow");

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        boolean flat = false;
        if (b instanceof JCheckBox) {
            flat = ((JCheckBox)b).isBorderPaintedFlat();
        }
        boolean isPressed = model.isPressed();
        boolean isArmed = model.isArmed();
        boolean isEnabled = model.isEnabled();
        boolean isSelected = model.isSelected();
        boolean checkToggleIn = isPressed && !isArmed && isSelected || isPressed && isArmed && !isSelected;
        boolean uncheckToggleOut = isPressed && !isArmed && !isSelected || isPressed && isArmed && isSelected;
        boolean checkIn = !isPressed && isArmed && isSelected || !isPressed && !isArmed && isSelected;
        g.setColor(this.shadow);
        g.drawRect(x + 2, y, 12, 12);
        if (uncheckToggleOut || checkToggleIn) {
            g.setColor(this.control);
            g.fillRect(x + 3, y + 1, 11, 11);
        }
        x += 2;
        boolean both = false;
        boolean bl = both = b instanceof TriStateCheckBox && ((TriStateCheckBox)b).getState() == TriStateModel.BOTH_STATE;
        if (checkToggleIn) {
            this.drawCheckBezel(g, x, y, 13, true, false, false, flat, both);
        } else if (uncheckToggleOut) {
            this.drawCheckBezel(g, x, y, 13, true, true, false, flat, both);
        } else if (checkIn) {
            this.drawCheckBezel(g, x, y, 13, false, false, true, flat, both);
        } else if (!flat) {
            this.drawCheckBezelOut(g, x, y, 13);
        }
    }

    @Override
    public int getIconWidth() {
        return 13;
    }

    @Override
    public int getIconHeight() {
        return 13;
    }

    public void drawCheckBezelOut(Graphics g, int x, int y, int csize) {
        Color controlShadow = UIManager.getColor("controlShadow");
        int w = csize;
        int h = csize;
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(this.highlight);
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(this.shadow);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, h - 1, w - 1, 1);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public void drawCheckBezel(Graphics g, int x, int y, int csize, boolean shade, boolean out, boolean check, boolean flat, boolean both) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        if (!flat) {
            if (out) {
                g.setColor(this.control);
                g.fillRect(1, 1, csize - 2, csize - 2);
                g.setColor(this.shadow);
            } else {
                g.setColor(this.lightShadow);
                g.fillRect(0, 0, csize, csize);
                g.setColor(this.highlight);
            }
            g.drawLine(1, csize - 1, csize - 2, csize - 1);
            if (shade) {
                g.drawLine(2, csize - 2, csize - 3, csize - 2);
                g.drawLine(csize - 2, 2, csize - 2, csize - 1);
                if (out) {
                    g.setColor(this.highlight);
                } else {
                    g.setColor(this.shadow);
                }
                g.drawLine(1, 2, 1, csize - 2);
                g.drawLine(1, 1, csize - 3, 1);
                if (out) {
                    g.setColor(this.shadow);
                } else {
                    g.setColor(this.highlight);
                }
            }
            g.drawLine(csize - 1, 1, csize - 1, csize - 1);
            if (out) {
                g.setColor(this.highlight);
            } else {
                g.setColor(this.shadow);
            }
            g.drawLine(0, 1, 0, csize - 1);
            g.drawLine(0, 0, csize - 1, 0);
        }
        if (check) {
            g.setColor(this.foreground);
            if (both) {
                g.setColor(this.shadow);
            }
            g.drawLine(csize - 2, 1, csize - 2, 2);
            g.drawLine(csize - 3, 2, csize - 3, 3);
            g.drawLine(csize - 4, 3, csize - 4, 4);
            g.drawLine(csize - 5, 4, csize - 5, 6);
            g.drawLine(csize - 6, 5, csize - 6, 8);
            g.drawLine(csize - 7, 6, csize - 7, 10);
            g.drawLine(csize - 8, 7, csize - 8, 10);
            g.drawLine(csize - 9, 6, csize - 9, 9);
            g.drawLine(csize - 10, 5, csize - 10, 8);
            g.drawLine(csize - 11, 5, csize - 11, 7);
            g.drawLine(csize - 12, 6, csize - 12, 6);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

