/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class SimpleGraph
extends Component {
    int maxErrors = 100;
    protected Vector errorVector = new Vector();

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.white);
        Rectangle rect = this.getBounds();
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        int height = this.getSize().height;
        int width = this.getSize().width;
        double scaleFactorHeight = (double)height / ((double)this.maxErrors * 1.1);
        double scaleFactorWidth = (double)width / ((double)this.maxErrors * 1.1);
        int offsetHeight = 5;
        int offsetWidth = 5;
        double getMaxValue = 0.0;
        double getMinValue = 0.0;
        this.errorVector.trimToSize();
        for (int counter = 0; counter < this.errorVector.size(); ++counter) {
            double temp = ((Number)this.errorVector.elementAt(counter)).doubleValue();
            if (temp > getMaxValue) {
                getMaxValue = temp;
                continue;
            }
            if (!(temp < getMinValue)) continue;
            getMinValue = temp;
        }
        double scaleFactorError = (getMaxValue - getMinValue) / ((double)height - 2.0 * (double)offsetHeight);
        int offsetForError = (int)(getMinValue / scaleFactorError);
        double scaleFactorTime = (double)this.maxErrors / ((double)width - 2.0 * (double)offsetHeight);
        g.setColor(Color.green);
        g.drawLine(offsetWidth, offsetHeight, offsetWidth, height - offsetHeight);
        g.drawLine(offsetWidth, height - offsetHeight + offsetForError, width - offsetWidth, height - offsetHeight + offsetForError);
        int lastx = offsetWidth;
        int lasty = height - offsetHeight;
        for (int counter = 0; counter < this.errorVector.size(); ++counter) {
            int currenty = (int)((double)(height - offsetHeight) - ((Number)this.errorVector.elementAt(counter)).doubleValue() / scaleFactorError) + offsetForError;
            int currentx = (int)((double)offsetWidth + (double)(counter + 1) / scaleFactorTime);
            g.drawLine(lastx, lasty, currentx, currenty);
            lastx = currentx;
            lasty = currenty;
        }
    }

    public void resetErrors() {
        this.errorVector.removeAllElements();
    }

    public void addError(float errorIn) {
        this.errorVector.addElement(new Float(errorIn));
        while (this.errorVector.size() > this.maxErrors) {
            this.errorVector.removeElementAt(0);
        }
        this.repaint();
    }

    public SimpleGraph() {
        this.setBackground(Color.white);
    }

    public SimpleGraph(int maxErrors) {
        this();
        this.maxErrors = maxErrors;
    }

    public Object update(Object input, int itemNumber, long time) {
        if (itemNumber != 1) {
            throw new IllegalStateException("1");
        }
        if (!(input instanceof Number)) {
            throw new IllegalStateException(input.toString());
        }
        this.addError(((Number)input).floatValue());
        return input;
    }
}

