/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.re;

import java.io.PrintStream;
import java.util.Stack;
import java.util.Vector;
import oracle.bm.util.re.CWAutomatonState;
import oracle.bm.util.re.CWFastSet;
import oracle.bm.util.re.CWMappedFA;
import oracle.bm.util.re.FABuilder;
import oracle.bm.util.re.RegExpConstants;

public class CWRegularExpression
implements RegExpConstants {
    private int m_outerFromState;
    private int m_innerFromState;
    private int m_innerToState;
    private int m_outerToState;
    private boolean m_orOperatorFound;
    private Stack subExpStack = new Stack();
    private String regExpString;
    private FABuilder pFABuild;
    private CWMappedFA _fa = new CWMappedFA();
    private CWAutomatonState baseState;
    private int subexpCounter = 0;
    private int activeSubexp;

    public CWRegularExpression(String regex) {
        this.pFABuild = this._fa;
        this.ConvertToFiniteAutomaton(regex);
        this._fa.Freeze();
    }

    public CWRegularExpression() {
        this.pFABuild = this._fa;
    }

    public CWAutomatonState firstMatchWithin(String text) {
        if (this.regExpString == null) {
            return null;
        }
        Vector<CWAutomatonState> itList = new Vector<CWAutomatonState>();
        if (this.baseState == null) {
            this.baseState = new CWAutomatonState(this._fa, 0);
        }
        boolean found = false;
        boolean firstTextChar = true;
        boolean lastTextChar = false;
        int textLen = text.length();
        CWAutomatonState it = null;
        for (int ci = 0; (ci < textLen || lastTextChar) && !found; ++ci) {
            int lookaheadEvt;
            int cp;
            int n = cp = lastTextChar ? 0 : text.charAt(ci);
            int n2 = firstTextChar ? 258 : (lookaheadEvt = lastTextChar ? 259 : (int)cp);
            if (this.baseState.Lookahead(lookaheadEvt) || lookaheadEvt == 258 && this.baseState.Lookahead(cp)) {
                it = (CWAutomatonState)this.baseState.clone();
                itList.addElement(it);
            }
            for (int p = 0; p < itList.size(); ++p) {
                boolean val;
                int oldp = p;
                it = (CWAutomatonState)itList.elementAt(p);
                if (!lastTextChar && lookaheadEvt != cp && it.Lookahead(lookaheadEvt)) {
                    it.NextState(lookaheadEvt);
                }
                if (val = it.NextState(!lastTextChar ? cp : 259)) continue;
                if (it.IsValid()) {
                    found = it.IsAccept();
                    if (!found) continue;
                    return it;
                }
                itList.removeElementAt(oldp);
                --p;
            }
            if (lastTextChar) break;
            lastTextChar = ci + 1 == textLen;
            firstTextChar = false;
        }
        return null;
    }

    public CWAutomatonState longestMatchWithin(String text) {
        if (this.regExpString == null) {
            return null;
        }
        Vector<CWAutomatonState> itList = new Vector<CWAutomatonState>();
        if (this.baseState == null) {
            this.baseState = new CWAutomatonState(this._fa, 0);
        }
        boolean firstTextChar = true;
        boolean lastTextChar = false;
        int textLen = text.length();
        CWAutomatonState it = null;
        CWAutomatonState best = null;
        for (int ci = 0; ci < textLen || lastTextChar; ++ci) {
            int lookaheadEvt;
            int cp;
            int n = cp = lastTextChar ? 0 : text.charAt(ci);
            int n2 = firstTextChar ? 258 : (lookaheadEvt = lastTextChar ? 259 : (int)cp);
            if (this.baseState.Lookahead(lookaheadEvt) || lookaheadEvt == 258 && this.baseState.Lookahead(cp)) {
                it = (CWAutomatonState)this.baseState.clone();
                itList.addElement(it);
            }
            for (int p = 0; p < itList.size(); ++p) {
                int oldp = p;
                it = (CWAutomatonState)itList.elementAt(p);
                if (!lastTextChar && lookaheadEvt != cp && it.Lookahead(lookaheadEvt)) {
                    it.NextState(lookaheadEvt);
                }
                boolean accepted = it.IsAccept();
                boolean val = it.NextState(!lastTextChar ? cp : 259);
                if (val || it.IsValid()) continue;
                if (accepted && (best == null || it.GetSubexp(0).length() > best.GetSubexp(0).length())) {
                    best = it;
                }
                itList.removeElementAt(oldp);
                --p;
            }
            if (lastTextChar) break;
            lastTextChar = ci + 1 == textLen;
            firstTextChar = false;
        }
        for (int p = 0; p < itList.size(); ++p) {
            it = (CWAutomatonState)itList.elementAt(p);
            if (!it.IsAccept() || best != null && it.GetSubexp(0).length() <= best.GetSubexp(0).length()) continue;
            best = it;
        }
        return best;
    }

    public CWAutomatonState exactMatch(String text) {
        if (this.regExpString == null) {
            return null;
        }
        if (this.baseState == null) {
            this.baseState = new CWAutomatonState(this._fa, 0);
        }
        boolean firstTextChar = true;
        boolean lastTextChar = false;
        int textLen = text.length();
        CWAutomatonState it = (CWAutomatonState)this.baseState.clone();
        for (int ci = 0; ci < textLen || lastTextChar; ++ci) {
            int lookaheadEvt;
            int cp;
            int n = cp = lastTextChar ? 0 : text.charAt(ci);
            int n2 = firstTextChar ? 258 : (lookaheadEvt = lastTextChar ? 259 : (int)cp);
            if (!lastTextChar && lookaheadEvt != cp && it.Lookahead(lookaheadEvt)) {
                it.NextState(lookaheadEvt);
            }
            boolean accepted = it.IsAccept();
            boolean val = it.NextState(!lastTextChar ? cp : 259);
            if (!val && !it.IsValid()) {
                return null;
            }
            if (lastTextChar) break;
            lastTextChar = ci + 1 == textLen;
            firstTextChar = false;
        }
        return it.IsAccept() ? it : null;
    }

    public CWAutomatonState prefixMatch(String text) {
        if (this.regExpString == null) {
            return null;
        }
        if (this.baseState == null) {
            this.baseState = new CWAutomatonState(this._fa, 0);
        }
        boolean firstTextChar = true;
        boolean lastTextChar = false;
        int textLen = text.length();
        CWAutomatonState it = (CWAutomatonState)this.baseState.clone();
        for (int ci = 0; ci < textLen || lastTextChar; ++ci) {
            int lookaheadEvt;
            int cp;
            int n = cp = lastTextChar ? 0 : text.charAt(ci);
            int n2 = firstTextChar ? 258 : (lookaheadEvt = lastTextChar ? 259 : (int)cp);
            if (!lastTextChar && lookaheadEvt != cp && it.Lookahead(lookaheadEvt)) {
                it.NextState(lookaheadEvt);
            }
            boolean accepted = it.IsAccept();
            boolean val = it.NextState(!lastTextChar ? cp : 259);
            if (!val) {
                if (!it.IsValid()) {
                    return null;
                }
                if (it.IsAccept()) {
                    return it;
                }
            }
            if (lastTextChar) break;
            lastTextChar = ci + 1 == textLen;
            firstTextChar = false;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void ConvertToFiniteAutomaton(String regexp) {
        this.regExpString = regexp;
        retval = true;
        backslashFound = false;
        inSet = false;
        firstSetChar = true;
        setInverted = false;
        inRange = false;
        lastSetCh = 0;
        this.m_outerFromState = -1;
        this.m_innerFromState = -1;
        this.m_innerToState = -1;
        this.m_outerToState = -1;
        this.m_orOperatorFound = false;
        tempState = -1;
        set = new CWFastSet(260);
        this.m_innerToState = 0;
        this.m_outerToState = this.NewState();
        this.AddEmptyTransition(this.m_innerToState, this.m_outerToState);
        firstReChar = true;
        for (reIndex = 0; reIndex < regexp.length(); ++reIndex) {
            block46: {
                block45: {
                    ch = regexp.charAt(reIndex);
                    if (!backslashFound && CWRegularExpression.SpecialChar((char)ch, inSet)) break block45;
                    if (!backslashFound) ** GOTO lbl-1000
                    backslashFound = false;
                    ch = this.TranslateCh((char)ch);
                    if (inSet) ** GOTO lbl-1000
                    setStr = "";
                    switch (ch) {
                        case 83: {
                            setInverted = true;
                        }
                        case 115: {
                            setStr = " \t\n\r";
                            break;
                        }
                        case 68: {
                            setInverted = true;
                        }
                        case 100: {
                            setStr = "0123456789";
                            break;
                        }
                        case 87: {
                            setInverted = true;
                        }
                        case 119: {
                            setStr = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
                        }
                    }
                    if (setStr.length() > 0) {
                        firstSetChar = false;
                        for (cp = 0; cp < setStr.length(); ++cp) {
                            set.Append(setStr.charAt(cp));
                        }
                        if (ch == 115) {
                            set.Append(258);
                            set.Append(259);
                        }
                        this.AddSetExpression(set, setInverted);
                        set.Empty();
                    } else if (inSet) {
                        if (firstSetChar) {
                            firstSetChar = false;
                        }
                        if (inRange) {
                            for (i = lastSetCh; i < ch; ++i) {
                                set.Append(i);
                            }
                            inRange = false;
                        } else {
                            set.Append(ch);
                        }
                        lastSetCh = ch;
                    } else {
                        this.m_innerFromState = this.NewState();
                        this.m_innerToState = this.NewState();
                        this.AddTransition(this.m_innerFromState, ch, this.m_innerToState);
                        this.ConnectSubExpr();
                        this.m_orOperatorFound = false;
                        backslashFound = false;
                    }
                    break block46;
                }
                switch (ch) {
                    case 124: {
                        this.m_orOperatorFound = true;
                        break;
                    }
                    case 92: {
                        backslashFound = true;
                        break;
                    }
                    case 91: {
                        if (inSet) break;
                        inSet = true;
                        setInverted = false;
                        firstSetChar = true;
                        break;
                    }
                    case 94: {
                        if (inSet) {
                            if (firstSetChar) {
                                setInverted = true;
                                break;
                            }
                            set.Append(ch);
                            lastSetCh = ch;
                            break;
                        }
                        if (firstReChar) {
                            this.AddEventExpression(258);
                        } else {
                            this.AddEventExpression(94);
                        }
                        this.m_orOperatorFound = false;
                        break;
                    }
                    case 36: {
                        if (reIndex + 1 == regexp.length()) {
                            this.AddEventExpression(259);
                        } else {
                            this.AddEventExpression(36);
                        }
                        this.m_orOperatorFound = false;
                        break;
                    }
                    case 45: {
                        if (!inSet) break;
                        if (firstSetChar) {
                            set.Append(ch);
                            lastSetCh = ch;
                            break;
                        }
                        if (!inRange) {
                            inRange = true;
                            break;
                        }
                        for (i = lastSetCh; i < ch; ++i) {
                            set.Append(i);
                        }
                        inRange = false;
                        break;
                    }
                    case 93: {
                        if (!inSet || firstSetChar) break;
                        this.AddSetExpression(set, setInverted);
                        set.Empty();
                        inSet = false;
                        firstSetChar = true;
                        break;
                    }
                    case 42: {
                        this.AddEmptyTransition(this.m_innerFromState, this.m_innerToState);
                        this.AddTransition(this.m_innerToState, 261, this.m_innerFromState);
                        break;
                    }
                    case 43: {
                        this.AddTransition(this.m_innerToState, 261, this.m_innerFromState);
                        break;
                    }
                    case 63: {
                        this.AddTransition(this.m_innerFromState, 261, this.m_innerToState);
                        this.m_orOperatorFound = false;
                        break;
                    }
                    case 46: {
                        this.m_innerFromState = this.NewState();
                        this.m_innerToState = this.NewState();
                        this.AddTransition(this.m_innerFromState, 257, this.m_innerToState);
                        this.ConnectSubExpr();
                        this.m_orOperatorFound = false;
                        break;
                    }
                    case 60: {
                        this.m_innerFromState = this.NewState();
                        ++this.subexpCounter;
                        this.activeSubexp = this.activeSubexp;
                        this.Push(this.activeSubexp);
                        this.m_outerToState = this.m_innerFromState;
                        this.m_orOperatorFound = false;
                        break;
                    }
                    case 62: {
                        this.m_innerToState = this.m_outerToState;
                        this.activeSubexp = this.Pop();
                        if (this.activeSubexp < 0) break;
                        this.pFABuild.AddSubExpression(this.activeSubexp, this.m_innerFromState);
                        this.ConnectSubExpr(true);
                        break;
                    }
                    case 40: {
                        this.m_innerFromState = this.NewState();
                        this.Push(-1);
                        this.m_outerToState = this.m_innerFromState;
                        this.m_orOperatorFound = false;
                        break;
                    }
                    case 41: {
                        this.m_innerToState = this.m_outerToState;
                        this.activeSubexp = this.Pop();
                        this.ConnectSubExpr();
                    }
                }
            }
            firstReChar = false;
        }
        this.SetAcceptState(this.m_outerToState);
    }

    public void Dump(PrintStream out) {
        out.println("RegularExpression::exp " + this.regExpString);
    }

    public int NewState() {
        return this.pFABuild.NewState();
    }

    public void AddTransition(int sourceState, int event, int targetState) {
        this.pFABuild.AddTransition(sourceState, event, targetState);
    }

    public void AddEmptyTransition(int sourceState, int targetState) {
        this.pFABuild.AddEmptyTransition(sourceState, targetState);
    }

    public void SetAcceptState(int a_acceptState) {
        this.pFABuild.SetAcceptState(a_acceptState);
    }

    private char TranslateCh(char inChar) {
        int retval = inChar;
        switch (inChar) {
            case 114: {
                retval = 13;
                break;
            }
            case 110: {
                retval = 10;
                break;
            }
            case 116: {
                retval = 9;
            }
        }
        return (char)retval;
    }

    private void AddSetExpression(CWFastSet set, boolean setInverted) {
        this.m_innerFromState = this.NewState();
        this.m_innerToState = this.NewState();
        if (setInverted) {
            for (int i2 = 0; i2 < 256; ++i2) {
                if (set.Find(i2) != -1) continue;
                this.AddTransition(this.m_innerFromState, i2, this.m_innerToState);
            }
        } else {
            for (int i3 = 0; i3 < set.GetCount(); ++i3) {
                this.AddTransition(this.m_innerFromState, set.elementAt(i3), this.m_innerToState);
            }
        }
        this.ConnectSubExpr();
    }

    private void AddEventExpression(int event) {
        this.m_innerFromState = this.NewState();
        this.m_innerToState = this.NewState();
        this.AddTransition(this.m_innerFromState, event, this.m_innerToState);
        this.ConnectSubExpr();
    }

    private static boolean SpecialChar(char ch, boolean inSet) {
        boolean retval = false;
        switch (ch) {
            case '-': 
            case ']': {
                retval = inSet;
                break;
            }
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case '<': 
            case '>': 
            case '?': 
            case '[': 
            case '|': {
                retval = !inSet;
                break;
            }
            case '\\': 
            case '^': {
                retval = true;
            }
        }
        return retval;
    }

    public static boolean isMeta(char ch) {
        return CWRegularExpression.SpecialChar(ch, false) || CWRegularExpression.SpecialChar(ch, true);
    }

    private void ConnectSubExpr() {
        this.ConnectSubExpr(false);
    }

    private void ConnectSubExpr(boolean captured) {
        int outwardEvent;
        int inwardEvent = captured ? 262 : 256;
        int n = outwardEvent = captured ? 263 : 256;
        if (this.m_orOperatorFound) {
            this.AddTransition(this.m_outerFromState, inwardEvent, this.m_innerFromState);
            this.AddTransition(this.m_innerToState, outwardEvent, this.m_outerToState);
        } else {
            this.m_outerFromState = this.m_outerToState;
            this.AddTransition(this.m_outerFromState, inwardEvent, this.m_innerFromState);
            this.m_outerToState = this.NewState();
            this.AddTransition(this.m_innerToState, outwardEvent, this.m_outerToState);
        }
        this.m_orOperatorFound = false;
    }

    private void Push(int i_se) {
        this.subExpStack.push(new subExpState(this.m_innerFromState, this.m_outerFromState, this.m_outerToState, this.m_orOperatorFound, i_se));
    }

    private int Pop() {
        if (this.subExpStack.empty()) {
            return -1;
        }
        subExpState subExp = (subExpState)this.subExpStack.pop();
        this.m_innerFromState = subExp.m_s1;
        this.m_outerFromState = subExp.m_s2;
        this.m_outerToState = subExp.m_s3;
        this.m_orOperatorFound = subExp.m_f1;
        return subExp.m_se;
    }

    public CWMappedFA fa() {
        return this._fa;
    }

    private class subExpState {
        public int m_s1;
        public int m_s2;
        public int m_s3;
        public boolean m_f1;
        public int m_se;

        public subExpState(int i2, int j, int k, boolean f, int se) {
            this.m_s1 = i2;
            this.m_s2 = j;
            this.m_s3 = k;
            this.m_f1 = f;
            this.m_se = se;
        }
    }
}

