/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.log;

import java.io.PrintWriter;
import java.io.Writer;

public class CWStackInspector {
    protected char[] m_chars;
    protected int m_nChars;
    protected MyWriter m_myWriter;
    protected PrintWriter m_printWriter;
    protected Throwable m_throwable;

    public CWStackInspector(int maxChars) {
        this.m_chars = new char[Math.max(1, maxChars)];
        this.m_myWriter = new MyWriter();
        this.m_printWriter = new PrintWriter(this.m_myWriter);
        this.m_throwable = new Throwable();
    }

    public void inspectStack() {
        this.m_myWriter.rewind();
        this.m_throwable.fillInStackTrace();
        this.m_throwable.printStackTrace(this.m_printWriter);
        this.m_printWriter.flush();
    }

    public void inspectStack(Throwable e) {
        this.m_myWriter.rewind();
        e.printStackTrace(this.m_printWriter);
        this.m_printWriter.flush();
    }

    public char[] getCharBuffer() {
        return this.m_chars;
    }

    public int getCharCount() {
        return this.m_nChars;
    }

    public String getLines(int firstLine, int lineCount) {
        firstLine = Math.max(0, firstLine);
        lineCount = Math.max(1, lineCount);
        int startIndex = firstLine == 0 ? 0 : -1;
        int endIndex = this.m_nChars;
        int line = 0;
        for (int i2 = 0; i2 < this.m_nChars; ++i2) {
            if (this.m_chars[i2] != '\n') continue;
            ++line;
            if (startIndex >= 0) {
                if (--lineCount > 0) continue;
                endIndex = i2;
                break;
            }
            if (line != firstLine) continue;
            startIndex = i2 + 1;
        }
        return startIndex < this.m_nChars ? new String(this.m_chars, startIndex, endIndex - startIndex) : "";
    }

    public static void main(String[] args) {
        System.out.println("\n\nCWStackInspector test harness");
        CWStackInspector si = new CWStackInspector(2000);
        si.inspectStack();
        System.out.println("\n\nFirst stack trace:");
        System.out.println(new String(si.getCharBuffer(), 0, si.getCharCount()));
        long time = CWStackInspector.main2(20, si);
        System.out.println("\n\nSecond stack trace:");
        System.out.println(new String(si.getCharBuffer(), 0, si.getCharCount()));
        System.out.println("\n\nEach inspectStack() took " + time + "us");
    }

    public static long main2(int levelsStillToDescend, CWStackInspector si) {
        if (levelsStillToDescend > 0) {
            return CWStackInspector.main2(levelsStillToDescend - 1, si);
        }
        long startTime = System.currentTimeMillis();
        for (int i2 = 0; i2 < 1000; ++i2) {
            si.inspectStack();
        }
        return System.currentTimeMillis() - startTime;
    }

    private class MyWriter
    extends Writer {
        private MyWriter() {
        }

        void rewind() {
            CWStackInspector.this.m_nChars = 0;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        public void write(char c) {
            if (CWStackInspector.this.m_nChars < CWStackInspector.this.m_chars.length) {
                CWStackInspector.this.m_chars[CWStackInspector.this.m_nChars++] = c;
            }
        }

        @Override
        public void write(char[] charbuff, int offset, int length) {
            int clippedLength;
            if (length > 0 && (clippedLength = Math.min(length, CWStackInspector.this.m_chars.length - CWStackInspector.this.m_nChars)) > 0) {
                System.arraycopy(charbuff, offset, CWStackInspector.this.m_chars, CWStackInspector.this.m_nChars, clippedLength);
                CWStackInspector.this.m_nChars += clippedLength;
            }
        }
    }
}

