/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.cursor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import oracle.bm.util.cursor.AWTCursorHandler;
import oracle.bm.util.cursor.CursorConstants;

public abstract class CursorHandler
implements CursorConstants {
    public static final String s_CLASS_PROPERTY = "oracle.bm.util.cursor.CursorHandler";
    public static final String s_WIN32_CLASS = "oracle.bm.util.cursor.win32.Win32CursorHandler";
    public static final String s_TOOLKIT_ENDBIT = "WObmToolkit";
    private static i s_handlerInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getInstance() {
        if (s_handlerInstance != null) {
            return;
        }
        try {
            String classProperty = System.getProperty(s_CLASS_PROPERTY);
            if (classProperty == null && Toolkit.getDefaultToolkit().getClass().getName().endsWith(s_TOOLKIT_ENDBIT)) {
                classProperty = s_WIN32_CLASS;
            }
            if (classProperty != null) {
                Class<?> classToMake = Class.forName(classProperty);
                s_handlerInstance = (i)classToMake.newInstance();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (s_handlerInstance == null) {
                s_handlerInstance = new AWTCursorHandler();
            }
        }
    }

    public static void setCursor(Component target, int bmCursor, boolean moving) {
        if (s_handlerInstance == null) {
            CursorHandler.getInstance();
        }
        try {
            s_handlerInstance.setCursor(target, bmCursor, moving);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static void main(String[] argv) throws Exception {
        Frame f = new Frame();
        f.setBounds(100, 100, 300, 300);
        f.setVisible(true);
        int[] cursorList = new int[]{0, 1, -1, -5, 3, 13, 8, 9, 6, 7, 4, 5, 10, 11, 12, -16, 2, -21, -2, -3};
        String[] nameList = new String[]{"s_DEFAULT_CURSOR", "s_CREATE_CURSOR", "s_DENIED_CURSOR", "s_HELP_CURSOR", "s_WAIT_CURSOR", "s_GRAB_MOVE_CURSOR", "s_GRAB_NORTH_CURSOR", "s_GRAB_SOUTH_CURSOR", "s_GRAB_NORTH_WEST_CURSOR", "s_GRAB_NORTH_EAST_CURSOR", "s_GRAB_SOUTH_WEST_CURSOR", "s_GRAB_SOUTH_EAST_CURSOR", "s_GRAB_WEST_CURSOR", "s_GRAB_EAST_CURSOR", "s_GRAB_WARP_POINT_CURSOR", "s_GRAB_WARP_POINT_SNAP_CURSOR", "s_TEXT_CURSOR", "s_DROP_DOWN_CURSOR", "s_COPY_CURSOR", "s_MOVE_CURSOR"};
        for (int counter = 0; counter < cursorList.length; ++counter) {
            Thread.sleep(2000L);
            System.out.println("Trying " + cursorList[counter] + " name " + nameList[counter]);
            CursorHandler.setCursor(f, cursorList[counter], false);
        }
    }

    public static interface i {
        public void setCursor(Component var1, int var2, boolean var3);
    }
}

