/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.Frame;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bm.util.alert.CWAlertData;
import oracle.bm.util.alert.CWException;
import oracle.bm.util.alert.CWExceptionData;
import oracle.jdeveloper.engine.EngineException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public abstract class Util {
    public static final String s_GERROR = "GenericUnspecifiedError";
    public static final String s_IOEXCEPTION = "IOException";
    public static final String s_NULLPOINTEREXCEPTION = "NullPointerException";
    public static final String s_RUNTIMEEXCEPTION = "RuntimeException";
    public static final String s_CLASSMISSINGEXCEPTION = "ClassNotFoundException";
    public static final String s_INCOMPATIBLECLASSCHANGERROR = "IncompatibleClassChangeError";
    public static final String s_LINKAGEERROR = "LinkageError";
    public static final String s_VIRTUALMACHINEERROR = "VirtualMachineError";
    public static final String s_NOSUCHMETHODERROR = "NoSuchMethod";

    public static CWAlertData getError(String cause) {
        return Util.getError(s_GERROR, cause);
    }

    public static CWAlertData getError(String key, String cause) {
        CWAlertData aData = new CWAlertData();
        aData.setPackageName("oracle.bm.util.alert");
        aData.setKey(key);
        aData.setCauseParams(new String[]{cause});
        return aData;
    }

    public static CWAlertData getError(Throwable th) {
        StringWriter sw = new StringWriter();
        th.printStackTrace(new PrintWriter(sw));
        String key = s_GERROR;
        try {
            throw th;
        }
        catch (IOException ioex) {
            key = s_IOEXCEPTION;
        }
        catch (NullPointerException npex) {
            key = s_NULLPOINTEREXCEPTION;
        }
        catch (RuntimeException rtex) {
            key = s_RUNTIMEEXCEPTION;
        }
        catch (ClassNotFoundException clfex) {
            key = s_CLASSMISSINGEXCEPTION;
        }
        catch (Exception ex) {
        }
        catch (NoSuchMethodError nsme) {
            key = s_NOSUCHMETHODERROR;
        }
        catch (IncompatibleClassChangeError iccer) {
            key = s_INCOMPATIBLECLASSCHANGERROR;
        }
        catch (LinkageError lerr) {
            key = s_LINKAGEERROR;
        }
        catch (VirtualMachineError vme) {
            key = s_VIRTUALMACHINEERROR;
        }
        catch (ThreadDeath td) {
            throw (ThreadDeath)th;
        }
        catch (Error err) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Util.getError(key, sw.toString());
    }

    private static CWException returnEngineException(EngineException ejbe) {
        CWExceptionData ced = new CWExceptionData();
        ced.setMessage(ejbe.getLocalizedMessage());
        return new CWException(new CWAlertData(ced));
    }

    private static CWException returnSaxException(SAXException saxe) {
        String[] params;
        String key;
        CWException cwe = saxe.getException() != null ? Util.returnException(saxe.getException()) : new CWException();
        String message = saxe.getMessage();
        if (saxe instanceof SAXParseException) {
            key = "SAXException";
            SAXParseException saxp = (SAXParseException)saxe;
            params = new String[]{message, Integer.toString(saxp.getColumnNumber()), Integer.toString(saxp.getLineNumber()), saxp.getPublicId(), saxp.getSystemId()};
        } else {
            params = new String[]{message};
            key = saxe instanceof SAXNotRecognizedException ? "SAXNotRecognizedException" : (saxe instanceof SAXNotSupportedException ? "SAXNotSupportedException" : "SAXException");
        }
        CWAlertData aData = new CWAlertData();
        aData.setPackageName("oracle.bm.util.alert");
        aData.setKey(key);
        aData.setCauseParams(params);
        cwe.addAlert(aData);
        return cwe;
    }

    public static void throwException(Throwable th) throws CWException {
        throw Util.returnException(th);
    }

    public static CWException returnException(Throwable th) {
        if (System.getProperty("oracle.bm.util.alert.Util.stack") != null) {
            th.printStackTrace();
        }
        if (th instanceof CWException) {
            return (CWException)th;
        }
        if (th instanceof SAXException) {
            return Util.returnSaxException((SAXException)th);
        }
        if (th instanceof EngineException) {
            return Util.returnEngineException((EngineException)th);
        }
        return new CWException(Util.getError(th));
    }

    public static void throwException(String pack, String key) throws CWException {
        CWAlertData aData = new CWAlertData();
        aData.setPackageName(pack);
        aData.setKey(key);
        CWException cwe = new CWException();
        cwe.addAlert(aData);
        throw cwe;
    }

    private static void thisIsACat(int counter) {
        if (counter > 200) {
            throw new RuntimeException("Cat overflow");
        }
        Util.thisIsACat(counter + 1);
    }

    public static void main(String[] xxxx) throws Exception {
        final String[] argv = xxxx;
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (argv.length == 1) {
                        if (argv[0].toLowerCase().startsWith("oracle")) {
                            UIManager.setLookAndFeel("oracle.bali.ewt.olaf.OracleLookAndFeel");
                        } else if (argv[0].toLowerCase().startsWith("windows")) {
                            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                        } else if (argv[0].toLowerCase().startsWith("motif")) {
                            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                        } else if (argv[0].toLowerCase().startsWith("mac")) {
                            UIManager.setLookAndFeel("it.unitn.ing.swing.plaf.macos.MacOSLookAndFeel");
                        } else {
                            System.err.println("Usage ... [windows|motif|oracle|mac] not " + argv[0] + " # " + argv.length);
                            System.exit(9);
                        }
                    } else {
                        System.err.println("Usage ... [windows|motif|oracle|mac] not " + argv[0] + " # " + argv.length);
                        System.exit(9);
                    }
                    Frame f = new Frame("Test");
                    f.setVisible(true);
                    CWException cwe = new CWException();
                    cwe.addAlert(Util.getError(new IOException("Pants")));
                    cwe.addAlert(Util.getError(new NullPointerException("Pants")));
                    cwe.addAlert(Util.getError(new RuntimeException("Pants")));
                    cwe.addAlert(Util.getError(new ClassNotFoundException("Pants")));
                    cwe.addAlert(Util.getError(new Exception("Pants")));
                    cwe.addAlert(Util.getError(new IncompatibleClassChangeError("Pants")));
                    cwe.addAlert(Util.getError(new LinkageError("Pants")));
                    cwe.addAlert(Util.getError(new OutOfMemoryError("Pants")));
                    cwe.addAlert(Util.getError(new NoSuchMethodError("Pants")));
                    try {
                        Util.thisIsACat(0);
                    }
                    catch (Throwable th) {
                        cwe.addAlert(Util.getError(th));
                    }
                    cwe.showAlert(f);
                    System.exit(0);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    System.exit(9);
                }
            }
        });
    }
}

