/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.Component;
import java.util.Iterator;
import oracle.bm.util.alert.CWException;
import oracle.bm.util.alert.CWExceptionData;
import oracle.javatools.dialogs.MessageDialog;

public class ExceptionDialog {
    private Component m_parent;
    private CWException m_exception;

    public ExceptionDialog(Component parent, CWException exception) {
        if (parent == null) {
            throw new IllegalArgumentException("An exception dialog must have a parent component");
        }
        if (exception == null) {
            throw new IllegalArgumentException("An exception dialog needs an exception to display");
        }
        this.m_parent = parent;
        this.m_exception = exception;
    }

    public void show() {
        String action;
        Iterator iter = this.m_exception.getAlertsIte();
        if (!iter.hasNext()) {
            throw new IllegalStateException("Exception has no messages to display");
        }
        CWExceptionData message = (CWExceptionData)iter.next();
        String messageType = message.getType();
        StringBuffer sb = new StringBuffer(message.getMessage());
        String cause = message.getCause();
        if (cause != null && cause.trim().length() > 0) {
            sb.append("\n\n");
            sb.append(cause);
        }
        if ((action = message.getAction()) != null && action.trim().length() > 0) {
            sb.append("\n\n");
            sb.append(action);
        }
        if ("I".equals(messageType)) {
            MessageDialog.information((Component)this.m_parent, (Object)sb.toString(), (String)message.getTitle(), null);
        } else if ("W".equals(messageType)) {
            MessageDialog.error((Component)this.m_parent, (Object)sb.toString(), (String)message.getTitle(), null);
        }
    }

    public static void displayException(Component parent, CWException exception) {
        new ExceptionDialog(parent, exception).show();
    }
}

