/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bm.util.alert.ErrorDialog;
import oracle.bm.util.alert.ErrorDialogMediator;

class CausePanel
extends JPanel {
    private ErrorDialogMediator m_med = null;
    private JTextArea m_cause = null;
    private JScrollPane m_causeScrollBox = null;

    CausePanel(String name, ErrorDialogMediator med) {
        super(null);
        this.setName(name);
        this.m_med = med;
        this.m_med.setCausePanel(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.initPanel();
    }

    public void initPanel() {
        JLabel text = new JLabel(" ");
        text.setName("CauseText");
        this.add("West", text);
        this.m_cause = new JTextArea();
        this.m_cause.setEditable(false);
        this.m_cause.setLineWrap(true);
        this.m_cause.setWrapStyleWord(true);
        this.m_causeScrollBox = new JScrollPane(this.m_cause);
        this.m_causeScrollBox.setHorizontalScrollBarPolicy(31);
        this.m_causeScrollBox.setVerticalScrollBarPolicy(20);
        this.m_causeScrollBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.m_causeScrollBox.getBorder()));
        this.add("Center", this.m_causeScrollBox);
    }

    void displayCause(String cause) {
        this.m_cause.setText(cause);
        this.m_cause.setCaretPosition(0);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension m_size = new Dimension(ErrorDialog.m_panelWidth, ErrorDialog.m_panelHeight);
        return m_size;
    }
}

