/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.alert;

import java.awt.Cursor;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.bm.util.alert.Defs;

public class CWMessageBox
implements Defs {
    public static final int TYPE_STOP = 1;
    public static final int TYPE_CAUTION = 2;
    public static final int TYPE_NOTE = 3;
    public static final int TYPE_MISC = 4;
    private JOptionPane m_alert;
    private JDialog m_containerDialog;
    private JButton m_buttonH = null;

    public CWMessageBox(Frame parent, String message, int alertType, int buttons) {
        this.doBaseAlert(parent, message, alertType, buttons);
    }

    public void setIcon(Icon icon) {
        this.m_alert.setIcon(icon);
    }

    public Icon getIcon() {
        return this.m_alert.getIcon();
    }

    public int runDialog() {
        this.m_containerDialog.setVisible(true);
        Object selectedValue = this.m_alert.getValue();
        if (selectedValue == null) {
            return this.type2CW(-1);
        }
        if (selectedValue instanceof Integer) {
            return this.type2CW((Integer)selectedValue);
        }
        return this.type2CW(-1);
    }

    public void enableHelpKey() {
    }

    public void setAutoDispose(boolean dispose) {
    }

    public void setWindowCursor(Cursor cursor) {
    }

    private void doBaseAlert(Frame parent, String message, int alertType, int buttons) {
        int swingButtonMask = 0;
        switch (buttons) {
            case 1: {
                swingButtonMask = 0;
                break;
            }
            case 2: {
                swingButtonMask = 1;
                break;
            }
            case 3: {
                swingButtonMask = 0;
                break;
            }
            case 7: {
                swingButtonMask = 1;
                break;
            }
            case 8: {
                swingButtonMask = -1;
                break;
            }
            case 12: {
                swingButtonMask = 2;
                break;
            }
            default: {
                new IllegalStateException("Not implemented yet " + buttons).printStackTrace();
                swingButtonMask = 1;
            }
        }
        this.m_alert = new JOptionPane(message, this.type2Swing(alertType), swingButtonMask);
        this.m_containerDialog = this.m_alert.createDialog(parent, parent.getTitle());
    }

    private int type2Swing(int type) {
        switch (type) {
            case 2: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        return 3;
    }

    private int type2CW(int type) {
        switch (type) {
            case 2: {
                return 2;
            }
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
        }
        return 4;
    }
}

