/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.io.BufferedReader;
import java.io.IOException;

public class StringUtils {
    private static char[] m_arrChars = null;
    private static char[] m_arrDefaultQuotes = new char[]{'\"'};
    private static char[] m_arrDefaultSpaces = new char[]{' ', '\t'};

    public static synchronized String readLine(BufferedReader bufferedReader) throws IOException {
        String strLine = bufferedReader.readLine();
        if (strLine == null) {
            return null;
        }
        if ((strLine = strLine.trim()).length() == 0) {
            return strLine;
        }
        if (strLine.lastIndexOf(92) == strLine.length() - 1) {
            strLine = strLine.substring(0, strLine.length() - 2);
            strLine = strLine.concat(StringUtils.readLine(bufferedReader));
        }
        return strLine;
    }

    private static boolean isTestChar(char charTest, char[] arrTest) {
        if (arrTest == null) {
            return false;
        }
        for (int nIdx = 0; nIdx < arrTest.length; ++nIdx) {
            if (arrTest[nIdx] != charTest) continue;
            return true;
        }
        return false;
    }

    public static synchronized String[] tokenizeString(String strLine) {
        return StringUtils.tokenizeString(strLine, m_arrDefaultQuotes, m_arrDefaultSpaces);
    }

    public static synchronized String[] tokenizeLine(BufferedReader bufferedReader) throws IOException {
        return StringUtils.tokenizeString(StringUtils.readLine(bufferedReader));
    }

    public static synchronized String[] tokenizeString(String strLine, char charSep) {
        char[] arrSep = new char[]{charSep};
        return StringUtils.tokenizeString(strLine, m_arrDefaultQuotes, arrSep);
    }

    public static synchronized String[] tokenizeString(String strLine, char[] arrQuote, char[] arrSpace) {
        if (strLine == null) {
            return null;
        }
        if (strLine.length() == 0) {
            return new String[0];
        }
        int nLen = strLine.length();
        if (m_arrChars == null || m_arrChars.length < nLen) {
            m_arrChars = new char[nLen];
        }
        strLine.getChars(0, nLen, m_arrChars, 0);
        boolean bQuoted = false;
        int nIdx = 0;
        int nSpaces = 0;
        for (nIdx = 0; nIdx < nLen; ++nIdx) {
            if (StringUtils.isTestChar(m_arrChars[nIdx], arrQuote)) {
                boolean bl = bQuoted = !bQuoted;
            }
            if (bQuoted || !StringUtils.isTestChar(m_arrChars[nIdx], arrSpace) || StringUtils.isTestChar(m_arrChars[nIdx - 1], arrSpace)) continue;
            ++nSpaces;
        }
        char nChar = '\u0000';
        int nStrIdx = 0;
        String[] arrStrings = new String[nSpaces + 1];
        StringBuffer buffer = new StringBuffer();
        bQuoted = false;
        for (nIdx = 0; nIdx < nLen; ++nIdx) {
            nChar = m_arrChars[nIdx];
            if (StringUtils.isTestChar(nChar, arrQuote)) {
                boolean bl = bQuoted = !bQuoted;
            }
            if (StringUtils.isTestChar(nChar, arrSpace) && !bQuoted) {
                arrStrings[nStrIdx++] = buffer.toString();
                while (StringUtils.isTestChar(m_arrChars[nIdx + 1], arrSpace)) {
                    ++nIdx;
                }
                buffer = new StringBuffer();
                continue;
            }
            if (StringUtils.isTestChar(nChar, arrQuote)) continue;
            buffer.append(nChar);
        }
        arrStrings[nStrIdx++] = buffer.toString();
        return arrStrings;
    }

    public static synchronized float[] tokenizeFloatList(String strLine, char charSep) {
        String[] arrTokens = StringUtils.tokenizeString(strLine, charSep);
        float[] arrFloats = new float[arrTokens.length];
        for (int nIdx = 0; nIdx < arrTokens.length; ++nIdx) {
            try {
                arrFloats[nIdx] = Float.valueOf(arrTokens[nIdx]).floatValue();
                continue;
            }
            catch (Exception e) {
                arrFloats[nIdx] = 0.0f;
            }
        }
        return arrFloats;
    }
}

