/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ProcessRunner {
    private int m_returnCode;
    private String m_stderr;
    private String m_stdout;
    private boolean m_haveRun = false;
    private File m_cwd;

    public void setWorkingDirectory(File f) {
        this.m_cwd = f;
    }

    public void run(String command) throws IOException, InterruptedException {
        this.run(command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String command, boolean wait) throws IOException, InterruptedException {
        try {
            StringBuffer outBuffer = new StringBuffer();
            StringBuffer errBuffer = new StringBuffer();
            Process p = Runtime.getRuntime().exec(command, null, this.m_cwd);
            StreamPumper outPumper = new StreamPumper(p.getInputStream(), outBuffer);
            StreamPumper errPumper = new StreamPumper(p.getErrorStream(), errBuffer);
            outPumper.start();
            errPumper.start();
            if (wait) {
                p.waitFor();
                outPumper.join();
                errPumper.join();
                this.m_returnCode = p.exitValue();
            }
            this.m_stderr = errBuffer.toString();
            this.m_stdout = outBuffer.toString();
        }
        finally {
            this.m_haveRun = true;
        }
    }

    public int getExitCode() {
        if (!this.m_haveRun) {
            throw new IllegalStateException("You must call run() before this method");
        }
        return this.m_returnCode;
    }

    public String getOutputText() {
        if (!this.m_haveRun) {
            throw new IllegalStateException("You must call run() before this method");
        }
        return this.m_stdout;
    }

    public String getErrorText() {
        if (!this.m_haveRun) {
            throw new IllegalStateException("You must call run() before this method");
        }
        return this.m_stderr;
    }

    class StreamPumper
    extends Thread {
        private InputStream m_inStream;
        private StringBuffer m_buffer;
        private final int SLEEP_TIME = 50;

        public StreamPumper(InputStream inStream, StringBuffer outBuffer) {
            this.m_inStream = inStream;
            this.m_buffer = outBuffer;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.m_inStream));
                StreamPumper.sleep(50L);
                String line = br.readLine();
                while (line != null) {
                    this.m_buffer.append(line);
                    this.m_buffer.append("\n");
                    StreamPumper.sleep(50L);
                    line = br.readLine();
                }
            }
            catch (IOException ioe) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

