/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LimitedSelectionModel
implements SingleSelectionModel {
    private ChangeEvent m_event = new ChangeEvent(this);
    private int m_selection = -1;
    private int m_maxSelection = -1;
    private Vector m_changeList = new Vector();
    private SelectionChangeVeto m_controller;

    public LimitedSelectionModel() {
        this.m_controller = null;
    }

    public LimitedSelectionModel(SelectionChangeVeto controller) {
        this.m_controller = controller;
    }

    public void setMaxSelection(int max) {
        this.m_maxSelection = max;
        this.fireStateChanged();
    }

    public int getMaxSelection() {
        return this.m_maxSelection;
    }

    @Override
    public int getSelectedIndex() {
        return this.m_selection;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.m_selection != index && (this.m_maxSelection == -1 || index <= this.m_maxSelection && index >= 0) && this.m_controller != null && this.m_controller.canChangeSelection(this.m_selection, index)) {
            this.m_selection = index;
            this.fireStateChanged();
        }
    }

    @Override
    public void clearSelection() {
        this.setSelectedIndex(-1);
    }

    @Override
    public boolean isSelected() {
        return this.getSelectedIndex() != -1;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.m_changeList.addElement(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.m_changeList.removeElement(l);
    }

    protected void fireStateChanged() {
        Enumeration enm = this.m_changeList.elements();
        while (enm.hasMoreElements()) {
            ChangeListener cl = (ChangeListener)enm.nextElement();
            if (cl == null) continue;
            cl.stateChanged(this.m_event);
        }
    }

    public static interface SelectionChangeVeto {
        public boolean canChangeSelection(int var1, int var2);
    }
}

