/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

public class IteratorStack
implements Iterator {
    private Stack m_stack = new Stack();
    private Iterator m_current = null;

    public void push(Iterator it) {
        this.m_stack.push(it);
    }

    private void verifyReady() {
        if (this.m_current == null && !this.m_stack.empty()) {
            this.m_current = (Iterator)this.m_stack.pop();
        }
        while (this.m_current != null && !this.m_current.hasNext()) {
            if (!this.m_stack.empty()) {
                this.m_current = (Iterator)this.m_stack.pop();
                continue;
            }
            this.m_current = null;
        }
    }

    @Override
    public boolean hasNext() {
        this.verifyReady();
        if (this.m_current != null) {
            return this.m_current.hasNext();
        }
        return false;
    }

    public Object next() {
        this.verifyReady();
        if (this.m_current != null) {
            return this.m_current.next();
        }
        throw new NoSuchElementException("No more to get");
    }

    @Override
    public void remove() {
        this.verifyReady();
        if (this.m_current == null) {
            throw new NoSuchElementException("No more to get");
        }
        this.m_current.remove();
    }

    public static void main(String[] argv) {
        Vector<String> one = new Vector<String>();
        one.addElement("one");
        one.addElement("two");
        one.addElement("three");
        one.addElement("four");
        Vector<String> two = new Vector<String>();
        two.addElement("Xone");
        two.addElement("Xtwo");
        two.addElement("Xthree");
        two.addElement("Xfour");
        IteratorStack es = new IteratorStack();
        es.push(two.iterator());
        es.push(one.iterator());
        while (es.hasNext()) {
            System.out.println(es.next());
        }
    }
}

