/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class GeomUtils {
    private static final byte CLIPCODE_LEFT = 1;
    private static final byte CLIPCODE_RIGHT = 2;
    private static final byte CLIPCODE_BOTTOM = 4;
    private static final byte CLIPCODE_TOP = 8;

    public static final Point lineIntersection(int ptRx, int ptRy, int ptSx, int ptSy, int ptIx, int ptIy, int ptJx, int ptJy) {
        if (ptSx == ptRx) {
            if (ptIy == ptJy) {
                if (ptSx >= Math.min(ptIx, ptJx) && ptSx <= Math.max(ptIx, ptJx) && ptIy >= Math.min(ptRy, ptSy) && ptIy <= Math.max(ptRy, ptSy)) {
                    return new Point(ptSx, ptIy);
                }
                return null;
            }
            if (ptIx == ptRx) {
                return null;
            }
        }
        if (ptSy == ptRy) {
            if (ptIx == ptJx && ptSy >= Math.min(ptIy, ptJy) && ptSy <= Math.max(ptIy, ptJy) && ptIx >= Math.min(ptRx, ptSx) && ptIx <= Math.max(ptRx, ptSx)) {
                return new Point(ptIx, ptSy);
            }
            if (ptIy == ptRy) {
                return null;
            }
        }
        double dMrs = 0.0;
        double dCrs = 0.0;
        double dMij = 0.0;
        double dCij = 0.0;
        double nIntX = 0.0;
        double nIntY = 0.0;
        if (ptSx != ptRx) {
            if (ptSy == ptRy) {
                dMrs = 0.0;
                dCrs = ptSy;
            } else {
                dMrs = (double)(ptSy - ptRy) / (double)(ptSx - ptRx);
                dCrs = (double)ptSy - dMrs * (double)ptSx;
            }
        } else {
            dMrs = 0.0;
        }
        if (ptIx != ptJx) {
            if (ptIy == ptJy) {
                dMij = 0.0;
                dCij = ptIy;
            } else {
                dMij = (double)(ptIy - ptJy) / (double)(ptIx - ptJx);
                dCij = (double)ptIy - dMij * (double)ptIx;
            }
        } else {
            dMij = 0.0;
        }
        if (ptRx == ptSx) {
            nIntX = ptRx;
            nIntY = dMij * nIntX + dCij;
        } else if (ptIx == ptJx) {
            nIntX = ptIx;
            nIntY = dMrs * nIntX + dCrs;
        } else {
            if (dMrs == dMij) {
                return null;
            }
            nIntX = (dCij - dCrs) / (dMrs - dMij);
            nIntY = nIntX * dMrs + dCrs;
        }
        if (nIntX >= (double)(Math.min(ptIx, ptJx) - 1) && nIntX >= (double)(Math.min(ptRx, ptSx) - 1) && nIntX <= (double)(Math.max(ptIx, ptJx) + 1) && nIntX <= (double)(Math.max(ptRx, ptSx) + 1) && nIntY >= (double)(Math.min(ptIy, ptJy) - 1) && nIntY >= (double)(Math.min(ptRy, ptSy) - 1) && nIntY <= (double)(Math.max(ptIy, ptJy) + 1) && nIntY <= (double)(Math.max(ptRy, ptSy) + 1)) {
            return new Point((int)nIntX, (int)nIntY);
        }
        return null;
    }

    public static final boolean lineIntersectionLimit(float[] ptR, float[] ptS, float[] ptI, float[] ptJ, float[] intersect) {
        float lambda;
        float alpha;
        float a = ptR[0];
        float b = ptR[1];
        float c = ptS[0] - ptR[0];
        float d = ptS[1] - ptR[1];
        float e = ptI[0];
        float f = ptI[1];
        float g = ptJ[0] - ptI[0];
        float h = ptJ[1] - ptI[1];
        if ((double)c != 0.0) {
            float det = h - d * g / c;
            if (det == 0.0f) {
                return false;
            }
            alpha = (b + d / c * (e - a) - f) / det;
            lambda = (e + alpha * g - a) / c;
        } else if ((double)g != 0.0) {
            float det = d - h * c / g;
            if (det == 0.0f) {
                return false;
            }
            lambda = (f + h / g * (a - e) - b) / det;
            alpha = (a + lambda * c - e) / g;
        } else {
            return false;
        }
        if ((double)alpha < 0.0) {
            return false;
        }
        if ((double)alpha > 1.0) {
            return false;
        }
        intersect[0] = a + lambda * c;
        intersect[1] = b + lambda * d;
        return true;
    }

    public static float euclideanDistance(float[] a, float[] b) {
        float dx = a[0] - b[0];
        float dy = a[1] - b[1];
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static final int[] commonDenominator(int nValue1, int nValue2) {
        int hcf = GeomUtils.highestCommonFactor(nValue1, nValue2);
        int[] arrRC = new int[]{nValue1 / hcf, nValue2 / hcf};
        return arrRC;
    }

    public static final int highestCommonFactor(int nValue1, int nValue2) {
        int hcf = 1;
        int absNValue1 = Math.abs(nValue1);
        int absNValue2 = Math.abs(nValue2);
        while (absNValue1 != 0 && absNValue2 != 0) {
            hcf = absNValue1;
            if (absNValue1 > absNValue2) {
                hcf = absNValue2;
                absNValue1 %= absNValue2;
                continue;
            }
            absNValue2 %= absNValue1;
        }
        return hcf;
    }

    public static final int roundTo(int nValue, int nRound) {
        if (nValue < 0) {
            return -GeomUtils.roundDown(-nValue + nRound / 2, nRound);
        }
        return GeomUtils.roundDown(nValue + nRound / 2, nRound);
    }

    public static final int roundDown(int nValue, int nRound) {
        if (nRound == 0) {
            return nValue;
        }
        if (nValue < 0 && nValue != Integer.MIN_VALUE) {
            return -GeomUtils.roundUp(-nValue, nRound);
        }
        int nRounded = nValue / nRound * nRound;
        return nRounded;
    }

    public static final float roundDown(float nValue, float nRound) {
        if (nRound == 0.0f) {
            return nValue;
        }
        if (nValue < 0.0f && nValue != Float.MIN_VALUE) {
            return -GeomUtils.roundUp(-nValue, nRound);
        }
        float nRounded = nValue / nRound * nRound;
        return nRounded;
    }

    public static final int roundUp(int nValue, int nRound) {
        if (nValue >= Integer.MAX_VALUE) {
            return GeomUtils.roundUp(0x7FFFFFFE - nRound, nRound);
        }
        if (nValue < 0) {
            return -GeomUtils.roundDown(-nValue, nRound);
        }
        int nValueAndABit = nValue + (nRound - 1);
        if (nValueAndABit < nValue) {
            assert (nValueAndABit < nValue) : "Int overflow in roundUp method";
            return GeomUtils.roundDown(nValue, nRound);
        }
        return GeomUtils.roundDown(nValue + (nRound - 1), nRound);
    }

    public static final float roundUp(float nValue, float nRound) {
        if (nValue >= Float.MAX_VALUE) {
            return GeomUtils.roundUp(Float.MAX_VALUE - nRound, nRound);
        }
        if (nValue < 0.0f) {
            return -GeomUtils.roundDown(-nValue, nRound);
        }
        float nValueAndABit = nValue + (nRound - 1.0f);
        if (nValueAndABit < nValue) {
            assert (nValueAndABit < nValue) : "Int overflow in roundUp method";
            return GeomUtils.roundDown(nValue, nRound);
        }
        return GeomUtils.roundDown(nValue + (nRound - 1.0f), nRound);
    }

    public static final boolean pointInRectangle(int pX, int pY, int rectX, int rectY, int rectW, int rectH) {
        boolean bRC = false;
        if (pX >= rectX && pX <= rectX + rectW && pY >= rectY && pY <= rectY + rectH) {
            bRC = true;
        }
        return bRC;
    }

    public static final int lineLength(int nX1, int nY1, int nX2, int nY2) {
        return (int)Math.sqrt(Math.pow(nX1 - nX2, 2.0) + Math.pow(nY1 - nY2, 2.0));
    }

    public static final int lineTravel(int nX1, int nY1, int nX2, int nY2, int nDistTravel, Point pntTravel) {
        int nLength = GeomUtils.lineLength(nX1, nY1, nX2, nY2);
        if (nLength <= nDistTravel) {
            pntTravel.x = nX2;
            pntTravel.y = nY2;
        } else {
            double dXedge = nX2 - nX1;
            double dYedge = nY2 - nY1;
            double deltaTravel = (double)nDistTravel / (double)nLength;
            pntTravel.x = (int)(dXedge *= deltaTravel) + nX1;
            pntTravel.y = (int)(dYedge *= deltaTravel) + nY1;
        }
        return nDistTravel - nLength;
    }

    public static final byte getClipCode(Point ptTest, Point ptLL, Point ptUR) {
        return GeomUtils.getClipCode(ptTest.x, ptTest.y, ptLL.x, ptLL.y, ptUR.x, ptUR.y);
    }

    private static final byte getClipCode(int ptTestx, int ptTesty, int ptLLx, int ptLLy, int ptURx, int ptURy) {
        byte code = 0;
        if (ptTestx < ptLLx) {
            code = (byte)(code | 1);
        } else if (ptTestx > ptURx) {
            code = (byte)(code | 2);
        }
        if (ptTesty < ptLLy) {
            code = (byte)(code | 4);
        } else if (ptTesty > ptURy) {
            code = (byte)(code | 8);
        }
        return code;
    }

    public static final boolean pointNearLine(Point src, Point dst, Point pnt, Dimension wnd) {
        Rectangle rect = new Rectangle(pnt.x - wnd.width, pnt.y - wnd.height, wnd.width * 2 + 1, wnd.height * 2 + 1);
        return GeomUtils.rectNearLine(src, dst, rect);
    }

    public static final boolean rectNearLine(Point src, Point dst, Rectangle rect) {
        byte c1;
        int llx = rect.x;
        int lly = rect.y;
        int urx = rect.x + rect.width;
        int ury = rect.y + rect.height;
        byte c0 = GeomUtils.getClipCode(src.x, src.y, llx, lly, urx, ury);
        if ((c0 & (c1 = GeomUtils.getClipCode(dst.x, dst.y, llx, lly, urx, ury))) != 0) {
            return false;
        }
        if (c0 == 0 || c1 == 0) {
            return true;
        }
        boolean isNear = false;
        int x0 = src.x;
        int y0 = src.y;
        int x1 = dst.x;
        int y1 = dst.y;
        if ((c0 | c1) == 3) {
            isNear = true;
        } else if ((c0 | c1) == 12) {
            isNear = true;
        } else {
            int yp;
            if ((c0 & 1) != 0) {
                int yp2 = (llx - x0) * (y1 - y0) / (x1 - x0) + y0;
                if (lly <= yp2 && yp2 <= ury) {
                    isNear = true;
                }
            } else if ((c0 & 2) != 0 && lly <= (yp = (urx - x0) * (y1 - y0) / (x1 - x0) + y0) && yp <= ury) {
                isNear = true;
            }
            if ((c0 & 4) != 0) {
                int xp = (lly - y0) * (x1 - x0) / (y1 - y0) + x0;
                if (llx <= xp && xp <= urx) {
                    isNear = true;
                }
            } else {
                int xp = (ury - y0) * (x1 - x0) / (y1 - y0) + x0;
                if (llx <= xp && xp <= urx) {
                    isNear = true;
                }
            }
        }
        return isNear;
    }

    public static final int signof(int n) {
        return n > 0 ? 1 : (n == 0 ? 0 : -1);
    }

    public static final double[] getSineCosine(int nAdjacent, int nOpposite) {
        double[] arrRC = new double[2];
        if (nAdjacent == 0) {
            if (nOpposite != 0) {
                arrRC[0] = GeomUtils.signof(nOpposite);
            }
        } else if (nOpposite == 0) {
            arrRC[1] = GeomUtils.signof(nAdjacent);
        } else {
            double dHypot = Math.sqrt(nOpposite * nOpposite + nAdjacent * nAdjacent);
            arrRC[0] = (double)nOpposite / dHypot;
            arrRC[1] = (double)nAdjacent / dHypot;
        }
        return arrRC;
    }

    public static final void rotateThenTransform(Point input, double[] sincos, int xTrans, int yTrans) {
        int x = (int)Math.round((double)input.x * sincos[1] + (double)input.y * -sincos[0] + (double)xTrans);
        int y = (int)Math.round((double)input.x * sincos[0] + (double)input.y * sincos[1] + (double)yTrans);
        input.x = x;
        input.y = y;
    }

    public static final void undoTransformThenRotate(Point input, double[] sincos, int xTrans, int yTrans) {
        int x = input.x - xTrans;
        int y = input.y - yTrans;
        x = (int)Math.round((double)x * sincos[1] + (double)y * sincos[0]);
        y = (int)Math.round((double)(-x) * sincos[0] + (double)y * sincos[1]);
        input.x = x;
        input.y = y;
    }

    public static final void snapPoint(Point ptSnap, int nGridSetting) {
        ptSnap.x = GeomUtils.roundTo(ptSnap.x, nGridSetting);
        ptSnap.y = GeomUtils.roundTo(ptSnap.y, nGridSetting);
    }

    public static final void snapRect(Rectangle rectSnap, int nGridSetting) {
        rectSnap.x = GeomUtils.roundTo(rectSnap.x, nGridSetting);
        rectSnap.y = GeomUtils.roundTo(rectSnap.y, nGridSetting);
    }

    public static final Point constrainLine(Point ptA, Point ptSnap, Point ptB) {
        Vector guess = new Vector();
        GeomUtils.guessConstrainLine(guess, ptA, ptB != null ? ptB : ptSnap);
        GeomUtils.guessConstrainLine(guess, ptB != null ? ptB : ptSnap, ptA);
        Point ptNearest = null;
        int nDist = 0;
        for (int i2 = 0; i2 < guess.size(); ++i2) {
            Point ptGuess = (Point)guess.elementAt(i2);
            int nGuess = GeomUtils.lineLength(ptSnap.x, ptSnap.y, ptGuess.x, ptGuess.y);
            if (ptNearest != null && nGuess >= nDist) continue;
            ptNearest = ptGuess;
            nDist = nGuess;
        }
        return ptNearest;
    }

    private static final void guessConstrainLine(Vector points, Point ptA, Point ptB) {
        int nABDistx = ptB.x - ptA.x;
        int nABDisty = ptB.y - ptA.y;
        boolean index = false;
        points.addElement(new Point(ptA.x, ptB.y));
        if (nABDistx != 0) {
            points.addElement(new Point(ptA.x, ptB.y - nABDistx));
            points.addElement(new Point(ptA.x, ptB.y + nABDistx));
        }
        points.addElement(new Point(ptB.x, ptA.y));
        if (nABDisty != 0) {
            points.addElement(new Point(ptB.x - nABDisty, ptA.y));
            points.addElement(new Point(ptB.x + nABDisty, ptA.y));
        }
        int nMid = (nABDistx - nABDisty) / 2;
        points.addElement(new Point(ptA.x + nMid, ptA.y + nMid));
    }
}

