/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.bm.util.VectorEnumerator;

public class FastVector
implements Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public FastVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public FastVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public FastVector() {
        this(10);
    }

    public final void copyInto(Object[] anArray) {
        int i2 = this.elementCount;
        while (i2-- > 0) {
            anArray[i2] = this.elementData[i2];
        }
    }

    public final void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        Object[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.elementData = new Object[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public final void setSize(int newSize) {
        if (newSize > this.elementCount && newSize > this.elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i2 = newSize; i2 < this.elementCount; ++i2) {
                this.elementData[i2] = null;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public final boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(Object elem, int index) {
        for (int i2 = index; i2 < this.elementCount; ++i2) {
            if (!elem.equals(this.elementData[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final int lastIndexOf(Object elem, int index) {
        for (int i2 = index; i2 >= 0; --i2) {
            if (!elem.equals(this.elementData[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final Object elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(Object obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public final void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void insertElementAt(Object obj, int index) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final void addElement(Object obj) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = obj;
    }

    public final boolean removeElement(Object obj) {
        int i2 = this.indexOf(obj);
        if (i2 >= 0) {
            this.removeElementAt(i2);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = null;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        try {
            FastVector v = (FastVector)super.clone();
            v.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.elements();
        buf.append("[");
        for (int i2 = 0; i2 <= max; ++i2) {
            String s = e.nextElement().toString();
            buf.append(s);
            if (i2 >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

